/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script;

import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parsii.tokenizer.ParseException;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.script.Action;
import promauto.jroboplc.plugin.script.ActionCalc;
import promauto.jroboplc.plugin.script.ActionCopy;
import promauto.jroboplc.plugin.script.ActionScriptJava;

public class ScriptModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(ScriptModule.class);
    protected List<Action> actions = new LinkedList<Action>();
    protected Map<String, ActionCalc.Expr> calcexprs = new HashMap<String, ActionCalc.Expr>();
    protected Map<String, Tag> vars = new HashMap<String, Tag>();
    protected Path javaDirSrc;
    protected Path javaDirBin;
    protected JavaCompiler javaCompiler = null;
    protected URLClassLoader javaURLClassLoader = null;
    protected Map<String, Class<?>> javaClasses = new HashMap();

    public ScriptModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.javaDirSrc = Paths.get(cm.get(conf, "java.src", "scripts/java"), new String[0]);
        if (!this.javaDirSrc.isAbsolute()) {
            this.javaDirSrc = cm.getConfDir().resolve(this.javaDirSrc);
        }
        this.javaDirBin = Paths.get(cm.get(conf, "java.bin", "scripts/bin"), new String[0]);
        if (!this.javaDirBin.isAbsolute()) {
            this.javaDirBin = cm.getConfDir().resolve(this.javaDirBin);
        }
        if (!this.loadVariables(conf)) {
            return false;
        }
        try {
            ActionCalc.loadExprs(conf, this.calcexprs);
        }
        catch (ParseException e) {
            this.env.printError(this.logger, e, this.name, "Error in ActionCalc.loadExpr");
        }
        List<Object> conf_actions = cm.toList(cm.get(conf, "actions"));
        for (Object conf_action : conf_actions) {
            Action sa = this.createAction(conf_action);
            if (sa == null) {
                return false;
            }
            this.actions.add(sa);
        }
        return true;
    }

    private boolean loadVariables(Object conf) {
        Configuration cm = this.env.getConfiguration();
        Pattern patvar1 = Pattern.compile("([\\w\\.]+)(?:\\s*;+\\s*(.*:\\w+))?(?:\\s*=\\s*(.*))?");
        Pattern patvar2 = Pattern.compile("(?<=^|;)\\s*(\\w+)\\s*:\\s*(\\w+)\\s*(?=$|;)");
        List<Object> conf_var = cm.toList(cm.get(conf, "var"));
        for (Object var : conf_var) {
            Tag tag;
            Map<String, Object> varmap;
            Optional<String> opt;
            boolean varsave;
            String vartype;
            String varinit;
            if (var instanceof String) {
                Tag tag2;
                Matcher m = patvar1.matcher(var.toString());
                if (!m.find()) continue;
                String varname = m.group(1);
                String varprop = m.group(2);
                varinit = m.group(3) == null ? "" : m.group(3);
                vartype = "int";
                varsave = true;
                boolean varhidden = false;
                if (varprop != null) {
                    m = patvar2.matcher(varprop);
                    while (m.find()) {
                        switch (m.group(1)) {
                            case "type": {
                                vartype = m.group(2);
                                break;
                            }
                            case "save": {
                                varsave = m.group(2).equals("on");
                                break;
                            }
                            case "hidden": {
                                varhidden = m.group(2).equals("on");
                            }
                        }
                    }
                }
                if ((tag2 = this.tagtable.createTag(vartype, varname, varinit)) == null) {
                    this.env.printError(this.logger, this.name, "Var error:", varname, vartype, varinit);
                    return false;
                }
                if (varsave) {
                    tag2.addFlag(1);
                }
                if (varhidden) {
                    tag2.addFlag(2);
                }
                this.vars.put(varname, tag2);
                continue;
            }
            if (!(var instanceof Map) || !(opt = (varmap = cm.toMap(var)).entrySet().stream().map(ent -> (String)ent.getKey()).filter(tagname -> !tagname.equals("type")).findFirst()).isPresent()) continue;
            String varname = opt.get();
            varinit = cm.get(var, varname, "");
            vartype = cm.get(var, "type", "int");
            varsave = cm.get(var, "save", true);
            Tag tag3 = tag = varsave ? this.tagtable.createTag(vartype, varname, varinit, 1) : this.tagtable.createTag(vartype, varname, varinit);
            if (tag == null) {
                this.env.printError(this.logger, this.name, "Var error:", varname, vartype, varinit);
                return false;
            }
            this.vars.put(varname, tag);
        }
        return true;
    }

    private Action createAction(Object conf) {
        Configuration cm = this.env.getConfiguration();
        Action sa = null;
        Iterator<Map.Entry<String, Object>> it = cm.toMap(conf).entrySet().iterator();
        if (!it.hasNext()) {
            return null;
        }
        Map.Entry<String, Object> ent = it.next();
        String action_name = ent.getKey();
        Object conf_params = ent.getValue();
        switch (action_name) {
            case "calc": {
                sa = new ActionCalc(this);
                break;
            }
            case "copy": {
                sa = new ActionCopy(this);
                break;
            }
            case "java": {
                sa = new ActionScriptJava(this);
                break;
            }
            default: {
                this.env.printError(this.logger, this.name, "Unknown action:", action_name);
            }
        }
        if (sa != null) {
            if (sa.load(conf_params)) {
                return sa;
            }
            this.env.printError(this.logger, this.name, "Action:", action_name, "Id:", sa.getId());
        }
        return null;
    }

    @Override
    public boolean prepareModule() {
        for (Action action : this.actions) {
            if (!action.isEnabled() || action.prepare()) continue;
            this.env.printError(this.logger, this.name, "Action:", action.getClass().getSimpleName(), "Id:", action.getId());
            return false;
        }
        return true;
    }

    @Override
    public boolean executeModule() {
        for (Action action : this.actions) {
            if (!action.isEnabled()) continue;
            action.execute();
        }
        return true;
    }

    @Override
    public String getInfo() {
        return this.enable ? "" : "disabled";
    }

    public String getErrors() {
        StringBuilder sb = new StringBuilder();
        for (Action action : this.actions) {
            if (!action.isEnabled() || action.isValid()) continue;
            sb.append(action.getError());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public ActionCalc.Expr getCalcExpr(String calcexpr) {
        return this.calcexprs.get(calcexpr);
    }

    @Override
    protected boolean reload() {
        boolean res = false;
        State state = new State();
        this.saveState(state);
        ScriptModule tmp = new ScriptModule(this.plugin, this.name);
        if (tmp.load()) {
            this.transferTagsTo(tmp);
            TagTable oldtagtable = this.tagtable;
            this.tagtable = tmp.tagtable;
            if (tmp.prepare()) {
                this.copySettingsFrom(tmp);
                this.actions = tmp.actions;
                this.calcexprs = tmp.calcexprs;
                this.javaClasses = tmp.javaClasses;
                this.loadState(state);
                res = true;
            } else {
                this.tagtable = oldtagtable;
            }
        }
        return res;
    }

    private void transferTagsTo(JrModule dst) {
        TagTable mytbl = this.getTagTable();
        TagTable dsttbl = dst.getTagTable();
        for (Tag dsttag : dsttbl.getTags("", false)) {
            Tag mytag = mytbl.get(dsttag.getName());
            if (mytag == null) continue;
            if (mytag.getType() != dsttag.getType()) {
                try {
                    mytag.copyValueTo(dsttag);
                }
                catch (NumberFormatException e) {
                    this.env.printError(this.logger, e, this.name, mytag.getName() + ", src: type=" + mytag.getType().name() + " val=" + String.valueOf(mytag) + ", dst: type=" + dsttag.getType().name() + " val=" + String.valueOf(dsttag));
                }
                continue;
            }
            dsttbl.remove(dsttag);
            dsttbl.add(mytag);
            mytag.copyFlagsFrom(dsttag);
        }
        for (Tag mytag : this.tagtable.getTags("", false)) {
            if (dsttbl.get(mytag.getName()) != null) continue;
            this.tagtable.remove(mytag);
        }
    }

    @Override
    public void saveState(State state) {
        for (Action action : this.actions) {
            action.saveState(state);
        }
    }

    @Override
    public void loadState(State state) {
        for (Action action : this.actions) {
            action.loadState(state);
        }
    }
}

