/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.SerialPort;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.serial.SerialManagerModule;

public class SerialPortFinsUdp
implements SerialPort {
    final Logger logger = LoggerFactory.getLogger(SerialPortFinsUdp.class);
    private DatagramSocket socket;
    private DatagramPacket packetout;
    private DatagramPacket packetin;
    private volatile boolean valid = true;
    private volatile boolean opened = false;
    private String host;
    private int port;
    private InetAddress addr;
    private static final int BUFFOUT_SIZE = 2048;
    private static final int BUFFIN_SIZE = 2048;
    private byte[] buffin = new byte[2048];
    private byte[] buffout = new byte[2048];
    private int buffinPos;
    private int buffinLast;
    private int id;
    private int timeout_ms;
    private boolean connectionLost = false;
    private long connectionLostTime = 0L;
    private long recon_ms = 3000L;
    private long liveness = 0L;
    private SerialManagerModule module;
    private TagRW tagOpened;
    private int transactSent;

    public SerialPortFinsUdp(SerialManagerModule module) {
        this.module = module;
        this.transactSent = 0;
    }

    public synchronized boolean load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.id = cm.get(conf, "id", 0);
        this.recon_ms = cm.get(conf, "recon_ms", 3000);
        this.timeout_ms = cm.get(conf, "timeout", 500);
        this.host = cm.get(conf, "host", "");
        this.port = cm.get(conf, "port", 0);
        try {
            this.addr = InetAddress.getByName(this.host);
        }
        catch (UnknownHostException e) {
            EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "host = " + this.host);
            return false;
        }
        this.tagOpened = this.module.getTagOpened(this.id);
        return true;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public synchronized boolean open() {
        return this.open(false);
    }

    public synchronized boolean open(boolean silent) {
        if (this.opened) {
            return true;
        }
        this.opened = this.connectSocket(silent);
        if (!this.opened) {
            this.connectionLost = true;
            this.disconnectSocket();
        } else {
            this.connectionLost = false;
            this.tagOpened.setReadValInt(1);
        }
        return this.opened;
    }

    protected boolean connectSocket(boolean silent) {
        this.resetBuffin();
        try {
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(this.timeout_ms);
            this.packetout = new DatagramPacket(this.buffout, 0, this.addr, this.port);
            this.packetin = new DatagramPacket(this.buffin, this.buffin.length);
        }
        catch (Exception e) {
            if (!silent) {
                EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Connect socket:", this.getDescr());
            }
            return false;
        }
        return true;
    }

    private void disconnectSocket() {
        this.resetBuffin();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Disconnect socket:", this.getDescr());
            }
            this.socket = null;
        }
        this.opened = false;
        this.tagOpened.setReadValInt(0);
    }

    @Override
    public synchronized void close() {
        if (!this.opened) {
            return;
        }
        this.disconnectSocket();
        this.connectionLost = false;
    }

    private void checkLiveness() {
        boolean ok = this.socket.isBound();
        if (ok &= !this.socket.isClosed()) {
            if (this.liveness == 0L) {
                this.liveness = System.currentTimeMillis();
                return;
            }
            if (System.currentTimeMillis() - this.liveness < this.recon_ms) {
                return;
            }
        }
        this.liveness = 0L;
        if (this.opened) {
            this.disconnectSocket();
            if (this.open(true)) {
                return;
            }
            EnvironmentInst.get().printError(this.logger, this.module.getName(), this.getDescr(), "Connection lost");
            this.connectionLost = true;
            this.connectionLostTime = System.currentTimeMillis();
        }
    }

    private void affirmLiveness() {
        this.liveness = 0L;
    }

    private String getDescr() {
        return "Serial port " + this.id + " (FinsUdp " + this.host + ":" + this.port + ")";
    }

    private boolean restoreConnectionIfLost() {
        if (!this.connectionLost) {
            return true;
        }
        if (System.currentTimeMillis() - this.connectionLostTime < this.recon_ms) {
            return false;
        }
        if (this.open(true)) {
            EnvironmentInst.get().printInfo(this.logger, this.getDescr(), "Connection restored");
            return true;
        }
        this.connectionLostTime = System.currentTimeMillis();
        return false;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setInvalid() {
        this.valid = false;
    }

    private boolean updateAnswer() {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return false;
        }
        if (this.isBuffinEmpty() && !this.receiveAnswer()) {
            this.checkLiveness();
            return false;
        }
        this.affirmLiveness();
        return true;
    }

    private boolean receiveAnswer() {
        try {
            this.socket.receive(this.packetin);
        }
        catch (IOException e) {
            return false;
        }
        this.buffinLast = this.packetin.getLength() - 1;
        this.buffinPos = 10;
        if (this.buffinLast <= 9) {
            return false;
        }
        return (this.buffin[9] & 0xFF) == this.transactSent;
    }

    private int getByteFromBuffin() {
        return this.buffin[this.buffinPos++] & 0xFF;
    }

    private boolean isBuffinAvailable() {
        return this.buffinPos >= this.buffinLast;
    }

    private void resetBuffin() {
        this.buffinPos = 0;
        this.buffinLast = 0;
    }

    private boolean isBuffinEmpty() {
        return this.buffinLast == 0;
    }

    @Override
    public synchronized int readByte() {
        if (!this.updateAnswer()) {
            return -1;
        }
        if (this.isBuffinAvailable()) {
            return -1;
        }
        return this.getByteFromBuffin();
    }

    @Override
    public synchronized int readBytes(int[] buff, int size) {
        if (!this.updateAnswer()) {
            return 0;
        }
        if (this.isBuffinAvailable()) {
            return 0;
        }
        int n = Math.min(this.buffinLast - this.buffinPos + 1, size);
        for (int i = 0; i < n; ++i) {
            buff[i] = this.getByteFromBuffin();
        }
        return n;
    }

    @Override
    public synchronized int readBytesDelim(int[] buff, int delim) {
        return 0;
    }

    @Override
    public synchronized String readString(int size) {
        return "";
    }

    @Override
    public synchronized String readStringDelim(int delim) {
        return "";
    }

    @Override
    public synchronized boolean writeByte(int data) {
        return false;
    }

    @Override
    public synchronized boolean writeBytes(int[] data, int size) {
        if (!this.restoreConnectionIfLost()) {
            return false;
        }
        if (!this.opened) {
            return false;
        }
        this.resetBuffin();
        ++this.transactSent;
        this.transactSent &= 0xFF;
        int bufflen = size + 10;
        if (bufflen > 2048) {
            EnvironmentInst.get().printError(this.logger, this.module.getName(), "writeBytes: data size is too big " + bufflen + " > 2048");
            return false;
        }
        this.buffout[0] = -128;
        this.buffout[1] = 0;
        this.buffout[2] = 3;
        this.buffout[3] = 0;
        this.buffout[4] = 0;
        this.buffout[5] = 0;
        this.buffout[6] = 0;
        this.buffout[7] = 9;
        this.buffout[8] = 0;
        this.buffout[9] = (byte)(this.transactSent & 0xFF);
        int i = 10;
        for (int j = 0; j < size; ++j) {
            this.buffout[i] = (byte)data[j];
            ++i;
        }
        this.packetout.setLength(bufflen);
        try {
            this.socket.send(this.packetout);
        }
        catch (IOException e) {
            this.checkLiveness();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean writeString(String data) {
        return false;
    }

    @Override
    public synchronized boolean discard() {
        if (!this.opened) {
            return false;
        }
        this.resetBuffin();
        return true;
    }

    @Override
    public String getInfo() {
        return String.format("%d: finsudp %s:%d %d %s", this.id, this.host, this.port, this.timeout_ms, this.opened ? "opened" : "closed");
    }
}

