/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.plugin.serial.SerialManagerModule;
import promauto.jroboplc.plugin.serial.SerialPortStreamed;

public class SerialPortLocal
extends SerialPortStreamed {
    private static final Logger logger = LoggerFactory.getLogger(SerialPortLocal.class);
    private SerialPort port;

    public SerialPortLocal(SerialManagerModule module) {
        super(module);
    }

    @Override
    public synchronized boolean load(Object conf) {
        super.load(conf);
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.portname = cm.get(conf, "sysname", "");
        return true;
    }

    @Override
    protected boolean isPortAlived() {
        return this.port != null && this.port.isOpen();
    }

    @Override
    protected Object getPortType() {
        return "local";
    }

    @Override
    protected void openPort() throws IOException {
        if (this.port == null) {
            this.port = SerialPort.getCommPort(this.portname);
        }
        this.port.setComPortParameters(this.baud, this.databits, this.stopbits == 2 ? 3 : 1, SerialPortLocal.mapParity(this.parity));
        this.port.setComPortTimeouts(16, this.timeout_ms, this.timeout_ms);
        this.port.clearDTR();
        this.port.clearRTS();
        this.port.clearBreak();
        if (!this.port.openPort()) {
            throw new IOException("openPort");
        }
        this.in = this.port.getInputStream();
        this.out = this.port.getOutputStream();
    }

    private static int mapParity(int parity) {
        if (parity == 1) {
            return 1;
        }
        if (parity == 2) {
            return 2;
        }
        return 0;
    }

    @Override
    public void closePort() {
        if (this.port != null) {
            this.port.closePort();
        }
    }
}

