/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.SerialPort;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.serial.SerialManagerModule;

public abstract class SerialPortStreamed
implements SerialPort {
    private static final Logger logger = LoggerFactory.getLogger(SerialPortStreamed.class);
    private static final Charset charset = Charset.forName("windows-1251");
    protected static final int BUFFIN_SIZE = 2048;
    protected final byte[] buffin = new byte[2048];
    private volatile boolean valid = true;
    protected boolean opened = false;
    protected int id;
    protected int baud = 9600;
    protected int databits = 8;
    protected int parity = 0;
    protected int stopbits = 1;
    protected int timeout_ms = 200;
    protected String portname = "";
    protected InputStream in;
    protected OutputStream out;
    protected final SerialManagerModule module;
    protected TagRW tagOpened;
    protected boolean connectionLost = false;
    protected long connectionLostTime = 0L;
    protected long recon_ms = 3000L;
    protected long liveness = 0L;
    private boolean errMesShown;

    public SerialPortStreamed(SerialManagerModule module) {
        this.module = module;
    }

    public synchronized boolean load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.id = cm.get(conf, "id", 0);
        this.baud = cm.get(conf, "baud", this.baud);
        this.recon_ms = cm.get(conf, "recon_ms", 3000);
        this.timeout_ms = cm.get(conf, "timeout", this.timeout_ms);
        String[] bits = cm.get(conf, "bits", "8/0/1").split("/");
        this.databits = bits.length > 0 ? Integer.parseInt(bits[0]) : this.databits;
        this.parity = bits.length > 1 ? Integer.parseInt(bits[1]) : this.parity;
        this.stopbits = bits.length > 2 ? Integer.parseInt(bits[2]) : this.stopbits;
        this.tagOpened = this.module.getTagOpened(this.id);
        return true;
    }

    @Override
    public synchronized boolean open() {
        return this.open(false);
    }

    public boolean open(boolean silent) {
        if (this.opened) {
            return true;
        }
        try {
            this.openPort();
            this.errMesShown = false;
            this.connectionLost = false;
            this.opened = true;
        }
        catch (Exception e) {
            if (!this.errMesShown) {
                String mes = "Open port error";
                if (silent) {
                    EnvironmentInst.get().logError(logger, e, this.module.getName(), this.getDescr(), mes);
                } else {
                    EnvironmentInst.get().printError(logger, e, this.module.getName(), this.getDescr(), mes);
                }
            }
            this.errMesShown = true;
            this.connectionLost = true;
            this.connectionLostTime = System.currentTimeMillis();
            try {
                this.closePort();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tagOpened.setReadValBool(this.opened);
        return this.opened;
    }

    @Override
    public synchronized void close() {
        if (!this.opened) {
            return;
        }
        try {
            this.closePort();
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(logger, e, this.module.getName(), this.getDescr(), "Close port error");
        }
        this.connectionLost = false;
        this.tagOpened.setReadValBool(this.opened);
        this.opened = false;
    }

    protected abstract void closePort() throws IOException;

    protected abstract void openPort() throws Exception;

    protected int read() throws IOException {
        return this.in.read();
    }

    protected void write(int b) throws IOException {
        this.out.write(b);
    }

    protected void flush() throws IOException {
        this.out.flush();
    }

    private void affirmLiveness() {
        this.liveness = 0L;
    }

    private void checkLiveness() {
        if (this.isPortAlived()) {
            if (this.liveness == 0L) {
                this.liveness = System.currentTimeMillis();
                return;
            }
            if (System.currentTimeMillis() - this.liveness < this.recon_ms) {
                return;
            }
        }
        this.loseConnection();
    }

    protected abstract boolean isPortAlived();

    private void loseConnection() {
        this.liveness = 0L;
        if (this.opened) {
            this.close();
            try {
                Thread.sleep(this.timeout_ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.open(true)) {
                return;
            }
            EnvironmentInst.get().printInfo(logger, this.module.getName(), this.getDescr(), "\u001b[01m\u001b[31mConnection lost\u001b[0m");
            this.connectionLost = true;
            this.connectionLostTime = System.currentTimeMillis();
        }
    }

    private boolean restoreConnectionIfLost() {
        if (!this.connectionLost) {
            return true;
        }
        if (System.currentTimeMillis() - this.connectionLostTime < this.recon_ms) {
            return false;
        }
        if (this.open(true)) {
            EnvironmentInst.get().printInfo(logger, this.module.getName(), this.getDescr(), "\u001b[01m\u001b[32mConnection restored\u001b[0m");
            return true;
        }
        this.connectionLostTime = System.currentTimeMillis();
        return false;
    }

    @Override
    public synchronized int readByte() {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return -1;
        }
        try {
            int b = this.read();
            this.affirmLiveness();
            return b;
        }
        catch (Exception e) {
            this.checkLiveness();
            return -1;
        }
    }

    @Override
    public synchronized int readBytes(int[] buff, int size) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return 0;
        }
        long time = System.currentTimeMillis();
        int i = 0;
        try {
            int b;
            while (i < size && System.currentTimeMillis() - time < (long)this.timeout_ms && (b = this.read()) >= 0) {
                buff[i++] = b;
            }
        }
        catch (Exception e) {
            return 0;
        }
        if (i == size) {
            this.affirmLiveness();
            return i;
        }
        this.checkLiveness();
        return -i;
    }

    @Override
    public synchronized int readBytesDelim(int[] buff, int delim) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return 0;
        }
        long time = System.currentTimeMillis();
        int size = buff.length;
        int i = 0;
        try {
            int b;
            while (i < size && System.currentTimeMillis() - time < (long)this.timeout_ms && (b = this.read()) >= 0) {
                buff[i++] = b;
                if (b != delim) continue;
                this.affirmLiveness();
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkLiveness();
        return -i;
    }

    @Override
    public synchronized String readString(int size) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return "";
        }
        if (size > 2048) {
            size = 2048;
        }
        long time = System.currentTimeMillis();
        int i = 0;
        try {
            int b;
            while (i < size && System.currentTimeMillis() - time < (long)this.timeout_ms && (b = this.read()) >= 0) {
                this.buffin[i++] = (byte)b;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (i == size) {
            this.affirmLiveness();
        } else {
            this.checkLiveness();
        }
        return new String(this.buffin, 0, i, charset);
    }

    @Override
    public synchronized String readStringDelim(int delim) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return "";
        }
        long time = System.currentTimeMillis();
        int i = 0;
        try {
            int b;
            while (i < 2048 && System.currentTimeMillis() - time < (long)this.timeout_ms && (b = this.read()) >= 0) {
                this.buffin[i++] = (byte)b;
                if (b != delim) continue;
                this.affirmLiveness();
                return new String(this.buffin, 0, i, charset);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkLiveness();
        return new String(this.buffin, 0, i, charset);
    }

    @Override
    public synchronized boolean writeByte(int data) throws Exception {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return false;
        }
        try {
            this.write(data);
            this.flush();
            return true;
        }
        catch (IOException e) {
            this.loseConnection();
            return false;
        }
    }

    @Override
    public synchronized boolean writeBytes(int[] data, int size) throws Exception {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return false;
        }
        try {
            for (int i = 0; i < size; ++i) {
                this.write(data[i]);
            }
            this.flush();
            return true;
        }
        catch (IOException e) {
            this.loseConnection();
            return false;
        }
    }

    @Override
    public synchronized boolean writeString(String data) throws Exception {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return false;
        }
        try {
            for (byte b : data.getBytes(charset)) {
                this.write(b & 0xFF);
            }
            this.flush();
            return true;
        }
        catch (IOException e) {
            this.loseConnection();
            return false;
        }
    }

    @Override
    public boolean discard() {
        if (!this.opened) {
            return false;
        }
        try {
            while (this.in.available() > 0) {
                this.in.read();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setInvalid() {
        this.valid = false;
    }

    @Override
    public int getId() {
        return this.id;
    }

    protected abstract Object getPortType();

    protected Object getPortName() {
        return this.portname;
    }

    protected String getDescr() {
        return String.format("%d: %s %s", this.id, this.getPortType(), this.getPortName());
    }

    @Override
    public String getInfo() {
        return String.format("%d: %s %s %d %d/%d/%d %d %s", this.id, this.getPortType(), this.getPortName(), this.baud, this.databits, this.parity, this.stopbits, this.timeout_ms, this.opened ? "opened" : "closed");
    }
}

