/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.system.SystemCommands;
import promauto.jroboplc.plugin.system.SystemPlugin;

public class SystemModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(SystemModule.class);
    private final Runtime runtime = Runtime.getRuntime();
    private SystemPlugin plugin;
    protected boolean sdEnabled;
    protected Ref refShutdown;
    protected int sdValue;
    protected int sdDelay;
    protected TagRW tagSdCnt;
    protected TagRW tagSdState;
    protected Tag tagSdEnable;
    private static final int SD_STATE_OK = 0;
    private static final int SD_STATE_COUNTDOWN = 1;
    private static final int SD_STATE_CANCELED = 2;
    private static final int SD_STATE_SHUTDOWN = 3;
    protected String sdCommand;
    protected SystemCommands syscmds = new SystemCommands();
    private Tag tagMemTotal;
    private Tag tagMemUsed;
    private Tag tagMemMax;
    protected TagRW tagLicDate;

    public SystemModule(Plugin plugin, String name) {
        super(plugin, name);
        this.plugin = (SystemPlugin)plugin;
        this.refShutdown = EnvironmentInst.get().getRefFactory().createRef();
    }

    @Override
    public boolean loadModule(Object conf) {
        Object shutdown_conf;
        Configuration cm = this.env.getConfiguration();
        boolean bl = this.sdEnabled = cm.toMap(shutdown_conf = cm.get(conf, "shutdown")).size() > 0;
        if (this.sdEnabled) {
            if (!this.refShutdown.init(shutdown_conf, "tag", this)) {
                this.env.printError(this.logger, this.name, "No shutdown tag");
                return false;
            }
            this.sdValue = cm.get(shutdown_conf, "value", 1);
            this.sdDelay = cm.get(shutdown_conf, "delay_s", 60);
            this.tagSdCnt = this.tagtable.createRWInt("shutdown.cnt", 0);
            this.tagSdState = this.tagtable.createRWInt("shutdown.state", 0);
            this.tagSdEnable = this.tagtable.createBool("shutdown.enable", cm.get(shutdown_conf, "enable", true));
            this.sdCommand = cm.get(shutdown_conf, "cmd." + this.plugin.getOsName(), "");
            if (this.sdCommand.isEmpty()) {
                switch (this.plugin.getOsType()) {
                    case Linux: {
                        this.sdCommand = "shutdown -h now";
                        break;
                    }
                    case Windows: {
                        this.sdCommand = "shutdown.exe -s -t 0";
                    }
                }
            }
        }
        this.syscmds.load(this, conf);
        this.tagMemTotal = this.tagtable.createInt("MemTotal", 0);
        this.tagMemUsed = this.tagtable.createInt("MemUsed", 0);
        this.tagMemMax = this.tagtable.createInt("MemMax", 0);
        this.tagLicDate = this.tagtable.createRWInt("licdate", this.env.getLoggerMode().get());
        return true;
    }

    @Override
    public boolean prepareModule() {
        if (this.sdEnabled) {
            if (!this.refShutdown.prepare()) {
                this.env.printError(this.logger, this.name, "Bad shutdown tag ref");
                return false;
            }
            this.tagSdState.setReadValInt(0);
        }
        return true;
    }

    @Override
    public boolean executeModule() {
        if (this.sdEnabled && this.refShutdown.linkIfNotValid()) {
            if (this.refShutdown.getInt() == this.sdValue && this.tagSdEnable.getBool()) {
                int v;
                if (this.tagSdState.getInt() == 0) {
                    this.tagSdCnt.setReadValInt(this.sdDelay);
                    this.tagSdState.setReadValInt(1);
                }
                if (this.tagSdState.hasWriteValue() && ((v = this.tagSdState.getWriteValInt()) == 1 || v == 2)) {
                    this.tagSdState.setReadValInt(v);
                }
                if (this.tagSdState.getInt() == 1) {
                    if (this.tagSdCnt.getInt() <= 0) {
                        this.doShutdown();
                    } else if (this.tagSdCnt.hasWriteValue()) {
                        this.tagSdCnt.setReadValInt(this.tagSdCnt.getWriteValInt());
                    } else {
                        this.tagSdCnt.setReadValInt(this.tagSdCnt.getInt() - 1);
                    }
                }
            } else if (this.tagSdState.getInt() != 0) {
                this.tagSdState.setReadValInt(0);
            }
        }
        this.syscmds.execute();
        this.tagMemTotal.setInt((int)(this.runtime.totalMemory() / 1024L));
        this.tagMemUsed.setInt((int)((this.runtime.totalMemory() - this.runtime.freeMemory()) / 1024L));
        this.tagMemMax.setInt((int)(this.runtime.maxMemory() / 1024L));
        return true;
    }

    private void doShutdown() {
        this.env.printInfo(this.logger, "[" + this.name + "]", "Shutting system down!!!");
        this.tagSdState.setReadValInt(3);
        try {
            Process p = Runtime.getRuntime().exec(this.sdCommand);
            p.waitFor(10L, TimeUnit.SECONDS);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String s = null;
            Object output = "";
            while ((s = stdInput.readLine()) != null) {
                output = (String)output + s;
            }
            if (!((String)output).isEmpty()) {
                this.env.printInfo(this.logger, new String[]{output});
            }
            output = "";
            while ((s = stdError.readLine()) != null) {
                output = (String)output + s;
            }
            if (!((String)output).isEmpty()) {
                this.env.printError(this.logger, new String[]{this.name, output});
            }
        }
        catch (IOException | InterruptedException e) {
            this.env.printError(this.logger, e, this.name);
        }
    }

    @Override
    public String getInfo() {
        return "";
    }

    @Override
    protected boolean reload() {
        Tag tag;
        SystemModule tmp = new SystemModule(this.plugin, this.name);
        if (!tmp.load() || !tmp.prepare()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.sdEnabled = tmp.sdEnabled;
        this.refShutdown = tmp.refShutdown;
        this.sdValue = tmp.sdValue;
        this.sdDelay = tmp.sdDelay;
        this.sdCommand = tmp.sdCommand;
        if (this.tagSdCnt == null && tmp.tagSdCnt != null) {
            this.tagSdCnt = tmp.tagSdCnt;
            this.tagtable.add(this.tagSdCnt);
            this.tagSdState = tmp.tagSdState;
            this.tagtable.add(this.tagSdState);
        } else if (this.tagSdCnt != null && tmp.tagSdCnt == null) {
            this.tagtable.remove(this.tagSdCnt);
            this.tagtable.remove(this.tagSdState);
            this.tagSdCnt = null;
            this.tagSdState = null;
        }
        for (SystemCommands.Cmd cmd : this.syscmds.cmds) {
            for (SystemCommands.PTag ptag : cmd.ptags) {
                tag = tmp.tagtable.get(ptag.tag.getName());
                if (tag != null && tag.getType() == ptag.tag.getType()) continue;
                this.tagtable.remove(ptag.tag);
            }
        }
        for (SystemCommands.Cmd cmd : tmp.syscmds.cmds) {
            for (SystemCommands.PTag ptag : cmd.ptags) {
                tag = this.tagtable.get(ptag.tag.getName());
                if (tag != null) {
                    ptag.tag = tag;
                    continue;
                }
                this.tagtable.add(ptag.tag);
            }
        }
        this.syscmds = tmp.syscmds;
        return true;
    }
}

