/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.tagsaver;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.plugin.tagsaver.TagsaverModule;

public class CmdLoad
extends AbstractCommand {
    private final Logger logger = LoggerFactory.getLogger(CmdLoad.class);

    @Override
    public String getName() {
        return "load";
    }

    @Override
    public String getUsage() {
        return "filename";
    }

    @Override
    public String getDescription() {
        return "load tag values from a file";
    }

    @Override
    public String execute(Console console, JrModule module, String args) {
        if (args.trim().isEmpty()) {
            return "Use format:\n" + module.getName() + ":" + this.getName() + " " + this.getUsage();
        }
        module.postCommand(this, console, module, args);
        return "";
    }

    @Override
    public void executePosted(Console console, JrModule module, String args) {
        Environment env = EnvironmentInst.get();
        TagsaverModule m = (TagsaverModule)module;
        Path path = env.getConfiguration().getConfDir().resolve(args);
        if (!Files.exists(path, new LinkOption[0])) {
            env.printError(this.logger, module.getName(), "File is not found: \"" + args + "\"");
            return;
        }
        if (!m.readValues(path, false)) {
            env.printError(this.logger, module.getName(), "Load failed!");
            return;
        }
        m.executeModule();
        m.merge();
        env.printInfo(this.logger, module.getName(), "Successfully loaded: \"" + args + "\"");
    }
}

