/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.tcpserver;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.TcpServerChannel;
import promauto.jroboplc.core.api.TcpServerPort;

public class TcpServerChannelImpl
implements TcpServerChannel {
    protected final Logger logger = LoggerFactory.getLogger(TcpServerChannelImpl.class);
    private final Channel channel;
    private final TcpServerPort port;
    private boolean logging = false;
    private Object attachedObject = null;
    private volatile long lastAliveTime;
    private volatile boolean closing;

    public TcpServerChannelImpl(Channel channel, TcpServerPort port) {
        this.channel = channel;
        this.port = port;
        this.lastAliveTime = System.currentTimeMillis();
        this.closing = false;
    }

    @Override
    public String getId() {
        return this.channel.id().asShortText();
    }

    @Override
    public TcpServerPort getPort() {
        return this.port;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public boolean write(String data) {
        if (!this.channel.isActive()) {
            return false;
        }
        this.channel.writeAndFlush(data);
        return true;
    }

    public String toString() {
        String remoteHostAddress = this.getRemoteAddress().getAddress().getHostAddress();
        String remoteHostName = this.getRemoteAddress().getAddress().getCanonicalHostName();
        return remoteHostAddress + "/" + remoteHostName + " (" + this.getId() + ")";
    }

    @Override
    public boolean isLogEnable() {
        return this.logging;
    }

    @Override
    public synchronized void setLogEnable(boolean logging) {
        if (this.logging == logging) {
            return;
        }
        this.logging = logging;
        if (logging) {
            this.channel.pipeline().addAfter("encoder", "logger", new LoggingHandler(LogLevel.DEBUG));
        } else {
            this.channel.pipeline().remove("logger");
        }
    }

    @Override
    public Object getAttachedObject() {
        return this.attachedObject;
    }

    @Override
    public void setAttachedObject(Object obj) {
        this.attachedObject = obj;
    }

    public boolean close(long timeout) {
        ChannelFuture future = this.channel.close();
        return future.awaitUninterruptibly(timeout);
    }

    @Override
    public boolean checkAlive() {
        if (System.currentTimeMillis() - this.lastAliveTime < this.port.getAliveTimeout()) {
            return true;
        }
        if (!this.closing) {
            EnvironmentInst.get().printInfo(this.logger, "Close dead channel: " + this.toString());
            this.channel.disconnect();
            this.closing = true;
        }
        return false;
    }

    @Override
    public void markChannelAsAlive() {
        this.lastAliveTime = System.currentTimeMillis();
    }
}

