/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.tags.RefGroup;
import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class ProductTags {
    private final Logger logger = LoggerFactory.getLogger(ProductTags.class);
    private final WessvrModule module;
    private final RefGroup refs = EnvironmentInst.get().getRefFactory().createRefGroup();
    List<Item> items = new ArrayList<Item>();

    public ProductTags(WessvrModule module) {
        this.module = module;
    }

    public boolean init() {
        this.items.clear();
        String sql = String.format("SELECT P.IDM, P.IDPROD, P.TAGNAME FROM %s P, MODULES M WHERE P.IDM=M.IDM AND M.SVRNAME='%s'", this.module.makeTableName("producttags"), this.module.getSvrname());
        try (Statement st = this.module.getDatabase().getConnection().createStatement();
             ResultSet rs = st.executeQuery(sql);){
            Pattern p = Pattern.compile("(.+)\\.(.+)");
            while (rs.next()) {
                Item item = new Item(this);
                item.idm = rs.getInt(1);
                item.idprod = rs.getInt(2);
                Matcher m = p.matcher(rs.getString(3));
                if (!m.find()) continue;
                item.ref = this.refs.createItem(m.group(1), m.group(2));
                this.items.add(item);
            }
            st.close();
            this.module.getDatabase().commit();
        }
        catch (SQLException e) {
            EnvironmentInst.get().printError(this.logger, e, this.module.getName());
            this.module.getDatabase().rollback();
            return false;
        }
        this.refs.prepare();
        return true;
    }

    public void execute() throws SQLException {
        this.refs.link();
        this.refs.read();
        boolean hasChanges = false;
        for (Item item : this.items) {
            if (!item.ref.isLinked() || item.value == item.ref.getTag().getInt()) continue;
            item.value = item.ref.getTag().getInt();
            if (item.ref.getTag().getInt() <= 0) continue;
            String sql = String.format("update %s set idprod=%d where idm=%d", this.module.makeTableName("modules"), item.idprod, item.idm);
            this.module.executeUpdate(sql);
            hasChanges = true;
        }
        if (hasChanges) {
            this.module.getDatabase().commit();
        }
    }

    private final class Item {
        RefItem ref;
        int idm;
        int idprod;
        int value = 0;

        private Item(ProductTags productTags) {
        }
    }
}

