/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

public class Shiftset {
    private int firstTimeAfterMidnight;
    private Comparator<Shift> shiftComparator = (o1, o2) -> o2.timebeg - o1.timebeg;
    private SortedSet<Shift> shifts = new TreeSet<Shift>(this.shiftComparator);

    public void addShift(int num, int timebeg) {
        this.shifts.add(new Shift(this, num, timebeg));
        this.firstTimeAfterMidnight = this.shifts.last().timebeg;
    }

    public int getShiftNum(LocalDateTime ldt) {
        int time = ldt.getHour() * 100 + ldt.getMinute();
        for (Shift sh : this.shifts) {
            if (time < sh.timebeg) continue;
            return sh.num;
        }
        return this.shifts.first().num;
    }

    public boolean isAfterMidnight(LocalDateTime ldt) {
        int time = ldt.getHour() * 100 + ldt.getMinute();
        return time < this.firstTimeAfterMidnight;
    }

    private class Shift {
        int num;
        int timebeg;

        public Shift(Shiftset shiftset, int num, int timebeg) {
            this.num = num;
            this.timebeg = timebeg;
        }
    }
}

