/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.wessvr.ArchiveConfig;
import promauto.jroboplc.plugin.wessvr.CmdImport;
import promauto.jroboplc.plugin.wessvr.CmdSweep;
import promauto.jroboplc.plugin.wessvr.CmdWmax;
import promauto.jroboplc.plugin.wessvr.CmdWmaxlist;
import promauto.jroboplc.plugin.wessvr.Device;
import promauto.jroboplc.plugin.wessvr.DeviceBase;
import promauto.jroboplc.plugin.wessvr.DeviceFactory;
import promauto.jroboplc.plugin.wessvr.ProductTags;
import promauto.jroboplc.plugin.wessvr.Shiftsets;
import promauto.jroboplc.plugin.wessvr.WessvrPlugin;
import promauto.utils.ParamsMap;

public class WessvrModule
extends AbstractModule
implements Signal.Listener {
    private final Logger logger = LoggerFactory.getLogger(WessvrModule.class);
    private ArchiveConfig archiveConfig = new ArchiveConfig(this);
    private Shiftsets shiftsets = new Shiftsets(this);
    private ProductTags productTags = new ProductTags(this);
    private String databaseModuleName;
    private String svrname;
    private String schema;
    private Database database;
    private List<Device> devices = new ArrayList<Device>();
    private Statement statement;
    private boolean singleTransaction;
    private boolean connected;
    private Tag tagConnected;
    private boolean errorOnInit = false;
    private boolean wesSvrStateEnabled;
    private boolean ignoreZeroStat;
    private String lastSql;
    private boolean modeReload;

    public WessvrModule(Plugin plugin, String name) {
        super(plugin, name);
        this.env.getCmdDispatcher().addCommand(this, CmdImport.class);
        this.env.getCmdDispatcher().addCommand(this, CmdSweep.class);
        this.env.getCmdDispatcher().addCommand(this, CmdWmaxlist.class);
        this.env.getCmdDispatcher().addCommand(this, CmdWmax.class);
    }

    public boolean isIgnoreZeroStat() {
        return this.ignoreZeroStat;
    }

    public ArchiveConfig getArchiveConfig() {
        return this.archiveConfig;
    }

    public Shiftsets getShiftsets() {
        return this.shiftsets;
    }

    public ProductTags getProductTags() {
        return this.productTags;
    }

    public String getDatabaseModuleName() {
        return this.databaseModuleName;
    }

    public String getSvrname() {
        return this.svrname;
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public boolean isSingleTransaction() {
        return this.singleTransaction;
    }

    private Statement getStatement() {
        return this.statement;
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String makeTableName(String table) {
        return this.database.makeSchemaObjectName(this.schema, table);
    }

    @Override
    public final boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.databaseModuleName = cm.get(conf, "database", "db");
        this.svrname = cm.get(conf, "svrname", "");
        this.schema = cm.get(conf, "schema", "");
        this.singleTransaction = cm.get(conf, "singleTransaction", true);
        this.wesSvrStateEnabled = cm.get(conf, "wesSvrStateEnabled", true);
        this.ignoreZeroStat = cm.get(conf, "ignoreZeroStat", false);
        this.ignoreZeroStat = cm.get(conf, "ignoreZeroStat", false);
        this.archiveConfig.load(conf);
        this.tagConnected = this.tagtable.get("connected");
        if (this.tagConnected == null) {
            this.tagConnected = this.tagtable.createBool("connected", false);
        }
        this.modeReload = false;
        return true;
    }

    @Override
    public final boolean prepareModule() {
        JrModule module = this.env.getModuleManager().getModule(this.databaseModuleName);
        if (module == null) {
            this.env.printError(this.logger, this.name, "Not found a database module:", this.databaseModuleName);
            return false;
        }
        if (!(module instanceof Database)) {
            this.env.printError(this.logger, this.name, "Not a database:", this.databaseModuleName);
            return false;
        }
        if (this.modeReload) {
            return true;
        }
        this.database = (Database)module;
        this.database.addSignalListener(this);
        String resourceName = "dbscr/dbscr.wessvr.yml";
        if (this.database.loadScriptFromResource(WessvrPlugin.class, resourceName) == null) {
            return false;
        }
        this.init();
        return true;
    }

    @Override
    public void onSignal(JrModule sender, Signal signal) {
        if (signal.type == Signal.SignalType.CONNECTED) {
            if (!this.connected) {
                this.init();
                this.postSignal(Signal.SignalType.RELOADED);
            }
        } else if (signal.type == Signal.SignalType.DISCONNECTED) {
            this.connected = false;
            this.tagConnected.setBool(false);
        }
    }

    private void init() {
        this.errorOnInit = false;
        this.connected = false;
        this.tagConnected.setBool(false);
        if (!this.enable || this.database == null || !this.database.isConnected()) {
            return;
        }
        boolean res = true;
        ParamsMap params = new ParamsMap(new String[0]);
        res &= this.database.executeScript((String)"wessvr.init1", (Map<String, String>)params).success;
        res &= this.database.executeScript((String)"wessvr.init2", (Map<String, String>)params).success;
        res &= this.archiveConfig.createTables();
        res &= this.shiftsets.init();
        res &= this.productTags.init();
        this.errorOnInit = !(res &= this.initDevices());
        this.connected = res;
        this.tagConnected.setBool(this.connected);
        if (this.errorOnInit) {
            this.env.printError(this.logger, this.name, "Initialization error");
        }
    }

    private boolean initDevices() {
        boolean result = true;
        this.devices.clear();
        try (Statement st = this.database.getConnection().createStatement();){
            this.statement = st;
            String sql = String.format("select mt.name as modtype, m.* from %s m join %s mt on m.idmt=mt.idmt where m.svrname='%s' order by m.idm", this.makeTableName("modules"), this.makeTableName("modtypes"), this.svrname);
            try (ResultSet rs = st.executeQuery(sql);){
                while (rs.next()) {
                    String modtype = rs.getString("modtype");
                    DeviceBase wd = DeviceFactory.create(this, modtype);
                    if (wd != null && wd.load(rs)) {
                        this.devices.add(wd);
                        continue;
                    }
                    this.env.printError(this.logger, this.name, "Unknown MODTYPE:", modtype);
                }
            }
            for (Device wd : this.devices) {
                if (wd.init()) continue;
                result = false;
                break;
            }
            this.database.commit();
        }
        catch (SQLException e) {
            this.env.printError(this.logger, e, this.name, "lastSql:", this.lastSql);
            this.database.rollback();
            result = false;
        }
        this.statement = null;
        return result;
    }

    @Override
    public boolean closedownModule() {
        if (!this.enable) {
            return true;
        }
        this.connected = false;
        this.tagConnected.setBool(false);
        if (this.database != null) {
            this.database.removeSignalListener(this);
        }
        return true;
    }

    @Override
    public boolean executeModule() {
        if (!this.connected || !this.database.isConnected()) {
            return true;
        }
        Connection con = this.database.getConnection();
        try (Statement st = con.createStatement();){
            this.statement = st;
            this.productTags.execute();
            for (Device wd : this.devices) {
                if (!wd.isEnable()) continue;
                wd.execute();
                if (this.singleTransaction) continue;
                this.database.commit();
            }
            st.close();
            if (this.singleTransaction) {
                this.database.commit();
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name, "lastSql:", this.lastSql);
            this.database.rollback();
        }
        this.statement = null;
        return true;
    }

    public boolean isWesSvrStateEnabled() {
        return this.wesSvrStateEnabled;
    }

    public void executeUpdate(String sql) throws SQLException {
        this.lastSql = sql;
        this.statement.executeUpdate(sql);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.lastSql = sql;
        return this.statement.executeQuery(sql);
    }

    @Override
    public String getInfo() {
        if (!this.enable) {
            return "disabled";
        }
        StringBuilder sb = new StringBuilder();
        sb.append((this.errorOnInit ? "\u001b[31m\u001b[01mERROR! \u001b[0m" : "") + this.databaseModuleName + ", " + (String)(this.svrname.isEmpty() ? "" : "svrname=" + this.svrname + ", ") + (String)(this.schema.isEmpty() ? "" : "schema=" + this.schema + ", ") + this.devices.size() + " devices, " + (this.connected ? "connected" : "NOT CONNECTED!"));
        for (Device device : this.devices) {
            sb.append("\r\n");
            sb.append(device.getInfo());
        }
        return sb.toString();
    }

    @Override
    protected boolean reload() {
        WessvrModule tmp = new WessvrModule(this.plugin, this.name);
        boolean res = tmp.load();
        tmp.modeReload = true;
        tmp.closedown();
        if (res &= tmp.prepare()) {
            Object conf = this.env.getConfiguration().getModuleConf(this.plugin.getPluginName(), this.name);
            this.closedown();
            if (this.load(conf)) {
                res = this.prepare();
            }
        }
        return res;
    }
}

