/*
 * Decompiled with CFR 0.152.
 */
package promauto.utils;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.utils.Numbers;

public class CRC {
    private static final Logger logger = LoggerFactory.getLogger(CRC.class);
    private static final int[] crc16_table = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};
    private static final int[] crc8_table = new int[]{0, 94, 188, 226, 97, 63, 221, 131, 194, 156, 126, 32, 163, 253, 31, 65, 157, 195, 33, 127, 252, 162, 64, 30, 95, 1, 227, 189, 62, 96, 130, 220, 35, 125, 159, 193, 66, 28, 254, 160, 225, 191, 93, 3, 128, 222, 60, 98, 190, 224, 2, 92, 223, 129, 99, 61, 124, 34, 192, 158, 29, 67, 161, 255, 70, 24, 250, 164, 39, 121, 155, 197, 132, 218, 56, 102, 229, 187, 89, 7, 219, 133, 103, 57, 186, 228, 6, 88, 25, 71, 165, 251, 120, 38, 196, 154, 101, 59, 217, 135, 4, 90, 184, 230, 167, 249, 27, 69, 198, 152, 122, 36, 248, 166, 68, 26, 153, 199, 37, 123, 58, 100, 134, 216, 91, 5, 231, 185, 140, 210, 48, 110, 237, 179, 81, 15, 78, 16, 242, 172, 47, 113, 147, 205, 17, 79, 173, 243, 112, 46, 204, 146, 211, 141, 111, 49, 178, 236, 14, 80, 175, 241, 19, 77, 206, 144, 114, 44, 109, 51, 209, 143, 12, 82, 176, 238, 50, 108, 142, 208, 83, 13, 239, 177, 240, 174, 76, 18, 145, 207, 45, 115, 202, 148, 118, 40, 171, 245, 23, 73, 8, 86, 180, 234, 105, 55, 213, 139, 87, 9, 235, 181, 54, 104, 138, 212, 149, 203, 41, 119, 244, 170, 72, 22, 233, 183, 85, 11, 136, 214, 52, 106, 43, 117, 151, 201, 74, 20, 246, 168, 116, 42, 200, 150, 21, 75, 169, 247, 182, 232, 10, 84, 215, 137, 107, 53};

    public static int getCrc16(byte[] bytes) {
        int crc = 65535;
        for (byte b : bytes) {
            crc = crc >>> 8 ^ crc16_table[(crc ^ b) & 0xFF];
        }
        return crc;
    }

    public static int getCrc16(byte[] bytes, int first, int last) {
        int crc = 65535;
        for (int index = first; index <= last; ++index) {
            crc = crc >>> 8 ^ crc16_table[(crc ^ bytes[index]) & 0xFF];
        }
        return crc;
    }

    public static int getCrc16(int[] data, int first, int last) {
        int crc = 65535;
        for (int i = first; i <= last; ++i) {
            crc = crc >>> 8 ^ crc16_table[(crc ^ data[i]) & 0xFF];
        }
        return crc;
    }

    public static int getCrc16(int[] data) {
        return CRC.getCrc16(data, data.length);
    }

    public static int getCrc16(int[] data, int size) {
        int crc = 65535;
        for (int i = 0; i < size; ++i) {
            crc = crc >>> 8 ^ crc16_table[(crc ^ data[i]) & 0xFF];
        }
        return crc;
    }

    public static int getCrc16FromWordStream(Stream<Integer> stream) {
        return stream.reduce(65535, (a, v) -> {
            a = a >>> 8 ^ crc16_table[(a ^ v >> 8) & 0xFF];
            return a >>> 8 ^ crc16_table[(a ^ v) & 0xFF];
        });
    }

    public static long getOctoCrc32FromTagStream(Stream<Tag> tags) {
        CRC32 crc = new CRC32();
        tags.forEach(tag -> {
            if (tag == null) {
                crc.update(0);
            } else {
                long value = switch (tag.getType()) {
                    case Tag.Type.BOOL, Tag.Type.INT, Tag.Type.LONG -> tag.getLong();
                    case Tag.Type.DOUBLE -> Numbers.encodeDouble64(tag.getDouble());
                    default -> 0L;
                };
                int bit = 64;
                for (int j = 0; j < 8; ++j) {
                    crc.update((int)(value >> (bit -= 8)) & 0xFF);
                }
            }
        });
        return crc.getValue();
    }

    public static long getCompactCrc32FromTagStream(Stream<Tag> tags) {
        CRC32 crc = new CRC32();
        tags.forEach(tag -> {
            if (tag == null) {
                crc.update(0);
            } else {
                long value;
                int bit = switch (tag.getType()) {
                    case Tag.Type.BOOL -> {
                        value = tag.getInt();
                        yield 8;
                    }
                    case Tag.Type.INT -> {
                        value = tag.getInt();
                        yield 32;
                    }
                    case Tag.Type.LONG -> {
                        value = tag.getLong();
                        yield 64;
                    }
                    case Tag.Type.DOUBLE -> {
                        value = Double.doubleToRawLongBits(tag.getDouble());
                        yield 64;
                    }
                    case Tag.Type.STRING -> {
                        value = tag.getString().hashCode();
                        yield 32;
                    }
                    default -> {
                        value = 0L;
                        yield 0;
                    }
                };
                while (bit > 0) {
                    crc.update((int)(value >> (bit -= 8)) & 0xFF);
                }
            }
        });
        return crc.getValue();
    }

    public static String getHexStringFromTagStream(Stream<Tag> tags) {
        StringBuilder sb = new StringBuilder();
        tags.forEach(tag -> {
            if (tag == null) {
                sb.append("-- ");
            } else {
                long value;
                int bit = switch (tag.getType()) {
                    case Tag.Type.BOOL -> {
                        value = tag.getInt();
                        yield 8;
                    }
                    case Tag.Type.INT -> {
                        value = tag.getInt();
                        yield 32;
                    }
                    case Tag.Type.LONG -> {
                        value = tag.getLong();
                        yield 64;
                    }
                    case Tag.Type.DOUBLE -> {
                        value = Double.doubleToRawLongBits(tag.getDouble());
                        yield 64;
                    }
                    case Tag.Type.STRING -> {
                        value = tag.getString().hashCode();
                        yield 32;
                    }
                    default -> {
                        value = 0L;
                        yield 0;
                    }
                };
                while (bit > 0) {
                    sb.append(Long.toHexString(value >> (bit -= 8) & 0xFFL)).append(' ');
                }
            }
        });
        return sb.toString();
    }

    public static int getCrc8(int[] bytes, int begin, int end) {
        int result = 0;
        for (int index = begin; index <= end; ++index) {
            int data = bytes[index];
            result = crc8_table[(data ^ result) & 0xFF];
        }
        return result;
    }

    public static int getCrc8(String text) {
        int result = 0;
        for (int index = 0; index < text.length(); ++index) {
            char data = text.charAt(index);
            result = crc8_table[(data ^ result) & 0xFF];
        }
        return result;
    }

    public static int getCrc8FromWordStream(Stream<Integer> stream) {
        return stream.reduce(0, (a, v) -> {
            a = crc8_table[(v >> 8 ^ a) & 0xFF];
            return crc8_table[(v ^ a) & 0xFF];
        });
    }

    public static boolean getMD5(Path path, StringBuilder result) {
        boolean bl;
        block8: {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                bl = CRC.getMD5(is, result);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    EnvironmentInst.get().printError(logger, e, "calcMD5");
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public static boolean getMD5(InputStream is, StringBuilder result) {
        byte[] digest;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            EnvironmentInst.get().printError(logger, e, "calcMD5");
            return false;
        }
        try (DigestInputStream dis = new DigestInputStream(is, md);){
            byte[] buffer = new byte[256];
            while (dis.read(buffer) > 0) {
            }
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(logger, e, "calcMD5");
            return false;
        }
        for (byte b : digest = md.digest()) {
            int i = b & 0xFF;
            result.append(Numbers.hexDigitChar[i >> 4 & 0xF]);
            result.append(Numbers.hexDigitChar[i & 0xF]);
        }
        return true;
    }
}

