/*
 * Decompiled with CFR 0.152.
 */
package promauto.utils;

import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Strings {
    public static byte[] intsToBytes(int[] data) {
        byte[] b = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            b[i] = (byte)(data[i] & 0xFF);
        }
        return b;
    }

    public static byte[] intsToBytes(int[] data, int len) {
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (byte)(data[i] & 0xFF);
        }
        return b;
    }

    public static int[] bytesToInts(byte[] data) {
        int[] b = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            b[i] = data[i] & 0xFF;
        }
        return b;
    }

    public static String bytesToHexString(byte[] data) {
        return Strings.bytesToHexString(data, " ");
    }

    public static String bytesToHexString(byte[] data, String delim) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(String.format("%02X", data[i] & 0xFF));
        }
        return sb.toString();
    }

    public static String bytesToHexString(int[] data) {
        return Strings.bytesToHexString(Strings.intsToBytes(data));
    }

    public static String bytesToHexString(int[] data, int from, int to) {
        return Strings.bytesToHexString(Strings.intsToBytes(Arrays.copyOfRange(data, from, to)));
    }

    public static byte[] hexStringToBytes(String s) {
        s = s.replace(" ", "");
        int len = s.length() / 2 * 2;
        byte[] buf = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            buf[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return buf;
    }

    public static String parsePropertyLine(String s, String prmName, String separator) {
        if (s.startsWith(prmName + separator)) {
            return s.substring(prmName.length() + 1);
        }
        return null;
    }

    public static Pattern getFilterPattern(String ipstr) {
        return Strings.getFilterPattern(ipstr, "\\s+");
    }

    public static Pattern getFilterPattern(String ipstr, String delim) {
        if (ipstr == null || ipstr.isEmpty()) {
            return null;
        }
        try {
            Object s = ipstr.startsWith("regex:") ? ipstr.substring(6).trim() : "^(" + ipstr.trim().replace(".", "\\.").replace("*", ".*").replace("?", ".").replaceAll(delim, "|") + ")$";
            return Pattern.compile((String)s);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return Pattern.compile("");
        }
    }

    public static String removeAnsiColors(String text) {
        return text.replaceAll("\u001b\\[\\d+m", "");
    }

    public static boolean bytesStartsWith(String substr, byte[] buff, int first, int end) {
        int n = substr.length();
        if (n > end - first) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (substr.codePointAt(i) == buff[first + i]) continue;
            return false;
        }
        return true;
    }

    public static int getPosReverse(int ch, byte[] buff, int first, int end) {
        byte b = (byte)ch;
        while (--end >= first) {
            if (buff[end] != b) continue;
            return end;
        }
        return -1;
    }

    public static int getPos(int ch, byte[] buff, int first, int end) {
        byte b = (byte)ch;
        while (first < end) {
            if (buff[first] == b) {
                return first;
            }
            ++first;
        }
        return -1;
    }

    public static boolean parsePropString() {
        return true;
    }

    public static String repeat(int length, char charToFill) {
        if (length > 0) {
            char[] array = new char[length];
            Arrays.fill(array, charToFill);
            return new String(array);
        }
        return "";
    }
}

