@echo off
setlocal

REM ============================================================
REM Ensure ServY CLI exists
REM ============================================================
call "%~dp0get-servy.bat"
if errorlevel 1 (
    echo ERROR: ServY CLI is not available
    exit /b 1
)

call config.bat


REM ============================================================
REM Check Java executable
REM ============================================================
if not exist "%JAVA_PATH%" (
    echo ERROR: Java executable not found:
    echo        %JAVA_PATH%
    echo.
    echo Please install Java or fix JAVA_PATH.
    exit /b 1
)

cd ..
SET STARTUP_DIR=%CD%

c:\tools\servy\servy-cli install ^
  --quiet ^
  --name=%SERVICE_NAME% ^
  --description=%SERVICE_DESCR% ^
  --path="%JAVA_PATH%" ^
  --startupDir="%STARTUP_DIR%" ^
  --params="-Xms%HEAP_SIZE_START% -Xmx%HEAP_SIZE_MAX% -jar bin\jroboplc.jar -daemon" ^
  --stdout="%STARTUP_DIR%\log\stdout.log" ^
  --stderr="%STARTUP_DIR%\log\stderr.log" ^
  --enableSizeRotation ^
  --rotationSize=10 ^
  --maxRotations=5 ^
  --enableHealth ^
  --heartbeatInterval=10 ^
  --maxFailedChecks=3 ^
  --recoveryAction="RestartService" ^
  --maxRestartAttempts=5

