/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.api.Console;

public class CmdGc
extends AbstractCommand {
    @Override
    public String getName() {
        return "gc";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "starts garbage collector";
    }

    @Override
    public String execute(Console console, String args) {
        Runtime rt = Runtime.getRuntime();
        long max = Math.round(rt.maxMemory() / 1024L);
        long total1 = Math.round(rt.totalMemory() / 1024L);
        long free1 = Math.round(rt.freeMemory() / 1024L);
        long used1 = total1 - free1;
        double per1 = (double)used1 * 100.0 / (double)total1;
        rt.gc();
        long total2 = Math.round(rt.totalMemory() / 1024L);
        long free2 = Math.round(rt.freeMemory() / 1024L);
        long used2 = total2 - free2;
        double per2 = (double)used2 * 100.0 / (double)total2;
        return String.format("GC: max=%d, before=%d/%d (%.1f%%), after=%s%d%s/%d (%s%.1f%%%s), freed=%d (Kbytes)", max, used1, total1, per1, "\u001b[01m\u001b[32m", used2, "\u001b[0m", total2, "\u001b[01m\u001b[33m", per2, "\u001b[0m", free2 - free1);
    }
}

