/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;

public class TagRWLong
extends TagRW {
    private volatile long valueRd;
    private long valueWr;
    private long valueWrLast = 0L;

    public TagRWLong(String name, long value, int flags) {
        super(name, flags);
        this.valueRd = value;
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.LONG;
    }

    @Override
    public boolean getBool() {
        return this.valueRd != 0L;
    }

    @Override
    public int getInt() {
        return (int)this.valueRd;
    }

    @Override
    public long getLong() {
        return this.valueRd;
    }

    @Override
    public double getDouble() {
        return this.valueRd;
    }

    @Override
    public String getString() {
        return "" + this.valueRd;
    }

    @Override
    public synchronized void setBool(boolean value) {
        this.valueWr = value ? 1L : 0L;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setOn() {
        this.valueWr = 1L;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setOff() {
        this.valueWr = 0L;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setInt(int value) {
        this.valueWr = value;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setLong(long value) {
        this.valueWr = value;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setDouble(double value) {
        this.valueWr = (long)value;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setString(String value) {
        try {
            this.valueWr = Long.parseLong(value.trim());
        }
        catch (NumberFormatException e) {
            this.valueWr = 0L;
        }
        this.valueWrChanged = true;
    }

    @Override
    public boolean getWriteValBool() {
        return this.valueWrLast != 0L;
    }

    @Override
    public int getWriteValInt() {
        return (int)this.valueWrLast;
    }

    @Override
    public long getWriteValLong() {
        return this.valueWrLast;
    }

    @Override
    public double getWriteValDouble() {
        return this.valueWrLast;
    }

    @Override
    public String getWriteValString() {
        return "" + this.valueWrLast;
    }

    @Override
    public void setReadValBool(boolean value) {
        this.valueRd = value ? 1L : 0L;
    }

    @Override
    public void setReadValInt(int value) {
        this.valueRd = value;
    }

    @Override
    public void setReadValLong(long value) {
        this.valueRd = value;
    }

    @Override
    public void setReadValDouble(double value) {
        this.valueRd = (long)value;
    }

    @Override
    public void setReadValString(String value) {
        try {
            this.valueRd = Long.parseLong(value.trim());
        }
        catch (NumberFormatException e) {
            this.valueRd = 0L;
        }
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getLong() == this.valueRd;
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setLong(this.valueRd);
    }

    @Override
    protected void copyWriteToLastWrite() {
        this.valueWrChanged = false;
        this.valueWrLast = this.valueWr;
    }

    @Override
    protected void copyWriteToRead() {
        this.valueRd = this.valueWr;
    }

    @Override
    public void copyLastWriteToRead() {
        this.valueRd = this.valueWrLast;
    }
}

