/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.arcsvr;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.plugin.arcsvr.ArcsvrModule;
import promauto.jroboplc.plugin.arcsvr.ArcvalBase;
import promauto.jroboplc.plugin.arcsvr.ArcvalRegex;
import promauto.jroboplc.plugin.arcsvr.ArcvalRobo;
import promauto.utils.IniFile;
import promauto.utils.ParamsMap;

public class ArcvalHolder {
    private final Logger logger = LoggerFactory.getLogger(ArcvalHolder.class);
    private static final Charset charset = Charset.forName("windows-1251");
    protected final ArcsvrModule module;
    protected final Environment env;
    protected Map<String, ArcvalBase> arcs = new TreeMap<String, ArcvalBase>();
    private boolean enable;

    public ArcvalHolder(ArcsvrModule module) {
        this.module = module;
        this.env = EnvironmentInst.get();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean load(Object conf) {
        Configuration cm = this.env.getConfiguration();
        boolean res = true;
        this.arcs.clear();
        List paths = cm.getStringList(conf, "arcval.robo").stream().map(filename -> Paths.get(filename, new String[0])).map(path -> path.isAbsolute() ? path : cm.getConfDir().resolve((Path)path)).collect(Collectors.toList());
        for (Path path2 : paths) {
            res &= this.loadFile(path2);
        }
        for (Map.Entry entry : cm.toMap(cm.get(conf, "arcval.regex")).entrySet()) {
            String arcname = (String)entry.getKey();
            if (this.arcs.containsKey(arcname)) {
                this.env.printError(this.logger, this.module.getName(), arcname, "Duplicate name");
                return false;
            }
            ArcvalRegex arcval = new ArcvalRegex(this, arcname);
            res &= arcval.load(entry.getValue());
            this.arcs.put(arcname, arcval);
        }
        this.enable = this.arcs.size() > 0;
        return res;
    }

    private boolean loadFile(Path path) {
        try {
            IniFile ini = new IniFile(path);
            String tagpath = ini.getString("TagLogMain", "OpcAccessPath", "");
            int arccount = ini.getInt("TagLogMain", "ArcCount", 0);
            for (int arcnum = 0; arcnum < arccount; ++arcnum) {
                String section = "TagLogArc" + arcnum;
                String arcname = ini.getString(section, "Name", "");
                ArcvalBase arcbase = this.arcs.get(arcname);
                if (arcbase != null && !(arcbase instanceof ArcvalRobo)) {
                    this.env.printError(this.logger, this.module.getName(), arcname, "Duplicate name");
                    return false;
                }
                ArcvalRobo arc = (ArcvalRobo)arcbase;
                if (arc == null) {
                    arc = new ArcvalRobo(this, arcname);
                    this.arcs.put(arcname, arc);
                }
                arc.load(ini, section, tagpath);
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, "File loading error:", path.toString());
            return false;
        }
        return true;
    }

    public void link() {
        if (!this.enable) {
            return;
        }
        for (ArcvalBase arc : this.arcs.values()) {
            arc.link();
        }
    }

    public boolean init() {
        if (!this.enable) {
            return true;
        }
        ParamsMap params = new ParamsMap("schema=" + this.module.getSchema());
        if (!this.module.getDatabase().executeScript((String)"arcsvr_arcval_init", (Map<String, String>)params).success) {
            return false;
        }
        boolean res = true;
        for (ArcvalBase arc : this.arcs.values()) {
            if (arc.init()) continue;
            res = false;
        }
        return res;
    }

    public boolean execute() throws SQLException {
        if (!this.enable) {
            return true;
        }
        boolean res = true;
        for (ArcvalBase arc : this.arcs.values()) {
            if (arc.execute()) continue;
            res = false;
        }
        return res;
    }

    public void closedown() {
        if (!this.enable) {
            return;
        }
        for (ArcvalBase arc : this.arcs.values()) {
            arc.closePreparedStatements();
        }
    }

    public String getInfo() {
        String res = "";
        for (ArcvalBase arc : this.arcs.values()) {
            res = res + arc.getInfo();
        }
        return res;
    }

    public String pack(String arcname) {
        String res = "";
        for (ArcvalBase arc : this.arcs.values()) {
            if (!arcname.isEmpty() && !arc.arcname.equals(arcname)) continue;
            res = res + arc.pack();
        }
        return res;
    }

    public String showNolinks() {
        String res = "";
        for (ArcvalBase arc : this.arcs.values()) {
            String s = arc.getNolinks();
            if (s.isEmpty()) continue;
            res = res + "\u001b[31m\u001b[01m" + arc.arcname + ":\r\n" + "\u001b[0m" + s;
        }
        return res;
    }
}

