/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class OwenTrm200Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(OwenTrm200Module.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Tag tagLvoP_STAT;
    protected Tag tagLvoP_PV1;
    protected Tag tagLvoP_PV2;
    protected Tag tagLvoP_LUPV1;
    protected Tag tagLvoP_LUPV2;

    public OwenTrm200Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagLvoP_STAT = this.tagtable.createInt("LvoP.STAT", 0, 8);
        this.tagLvoP_PV1 = this.tagtable.createInt("LvoP.PV1", 0, 8);
        this.tagLvoP_PV2 = this.tagtable.createInt("LvoP.PV2", 0, 8);
        this.tagLvoP_LUPV1 = this.tagtable.createInt("LvoP.LUPV1", 0, 8);
        this.tagLvoP_LUPV2 = this.tagtable.createInt("LvoP.LUPV2", 0, 8);
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        this.addChannelMapTag(chtags, this.tagLvoP_PV1, "0");
        this.addChannelMapTag(chtags, this.tagLvoP_PV2, "1");
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            result = this.protocol.requestCmd3(0, 5);
            if (result) {
                this.tagLvoP_STAT.setInt(this.protocol.getAnswerWord(0));
                this.tagLvoP_PV1.setInt(this.protocol.getAnswerWord(1));
                this.tagLvoP_PV2.setInt(this.protocol.getAnswerWord(2));
                this.tagLvoP_LUPV1.setInt(this.protocol.getAnswerWord(3));
                this.tagLvoP_LUPV2.setInt(this.protocol.getAnswerWord(4));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

