/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolAA55;

public class PaPdioModule
extends PeripherialModule {
    protected final Logger logger = LoggerFactory.getLogger(PaPdioModule.class);
    protected ProtocolAA55 protocol = new ProtocolAA55(this);
    protected static final int INP_SIZE = 64;
    protected static final int OUT_SIZE = 64;
    protected static final int BRD_SIZE = 4;
    protected Tag[] inputs = null;
    protected Tag[] outputs = null;
    protected Tag[] boards = null;
    protected int[] buffin = new int[9];
    protected int[] buffout = new int[11];
    protected int readcmd = 64;
    protected int writecmd = 32;
    protected Mode mode;
    protected String dependsOnModuleName;
    protected PeripherialModule dependsOnModule;
    private TagRW tagFirmware;
    private Tag tagResetCnt;
    private int resetCntPeriod;

    public PaPdioModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        int i;
        Configuration cm = this.env.getConfiguration();
        this.resetCntPeriod = cm.get(conf, "resetCntPeriod_s", 0) * 1000;
        String smode = cm.get(conf, "mode", "").toLowerCase();
        this.mode = smode.equals("readonly") ? Mode.ReadOnly : (smode.equals("writeonly") ? Mode.WriteOnly : Mode.ReadWrite);
        if (this.mode != Mode.WriteOnly) {
            this.inputs = new Tag[64];
            for (i = 0; i < 64; ++i) {
                this.inputs[i] = this.tagtable.createInt((i < 10 ? "inp0" : "inp") + i, 0, 8);
            }
            this.boards = new Tag[4];
            for (i = 0; i < 4; ++i) {
                this.boards[i] = this.tagtable.createInt("brd" + i, 0, 8);
            }
        }
        if (this.mode != Mode.ReadOnly) {
            this.outputs = new Tag[64];
            for (i = 0; i < 64; ++i) {
                this.outputs[i] = this.tagtable.createInt((i < 10 ? "out0" : "out") + i, 0, 8);
            }
        }
        this.dependsOnModuleName = cm.get(conf, "depends", "");
        this.tagFirmware = this.tagtable.createRWString("firmware", "");
        this.tagResetCnt = this.tagtable.createInt("resetcnt", 0);
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        switch (this.mode) {
            case ReadOnly: {
                for (int i = 0; i < 64; ++i) {
                    this.addChannelMapTag(chtags, this.inputs[i], "" + i);
                }
                break;
            }
            case WriteOnly: {
                for (int i = 0; i < 64; ++i) {
                    this.addChannelMapTag(chtags, this.outputs[i], "" + i);
                }
                break;
            }
            case ReadWrite: {
                for (int i = 0; i < 64; ++i) {
                    this.addChannelMapTag(chtags, this.inputs[i], i + "r");
                    this.addChannelMapTag(chtags, this.outputs[i], i + "w");
                }
                break;
            }
        }
    }

    @Override
    public boolean preparePeripherialModule() {
        if (this.dependsOnModuleName.isEmpty()) {
            this.dependsOnModule = null;
        } else {
            Module m = this.env.getModuleManager().getModule(this.dependsOnModuleName);
            if (m == null) {
                this.env.printError(this.logger, this.name, "Dependency module not found:", this.dependsOnModuleName);
                return false;
            }
            if (!PeripherialModule.class.isInstance(m)) {
                this.env.printError(this.logger, this.name, "Dependency module is not a PeripherialModule:", this.dependsOnModuleName);
                this.dependsOnModule = null;
                return false;
            }
            this.dependsOnModule = (PeripherialModule)m;
        }
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            if (result && this.mode != Mode.WriteOnly) {
                result = false;
                this.buffout[0] = 85;
                this.buffout[1] = this.readcmd + this.netaddr;
                if (this.protocol.request(this.buffout, 2, this.buffin, 9, 0)) {
                    this.decodeBuffinToInputs();
                    for (int i = 0; i < 4; ++i) {
                        this.boards[i].setInt((this.buffin[i * 2 + 1] << 8) + this.buffin[i * 2]);
                    }
                    result = true;
                }
            }
            if (this.dependsOnModule != null && this.dependsOnModule.tagError.getBool()) {
                result = false;
            }
            if (result && this.mode != Mode.ReadOnly) {
                this.buffout[0] = 85;
                this.buffout[1] = this.writecmd + this.netaddr;
                this.encodeOutputsToBuffout();
                this.protocol.setCrcAA55(this.buffout, 11);
                this.protocol.writeBytes(this.buffout, 11);
            }
            if ((result &= this.protocol.requestResetCnt(this.tagResetCnt, this.resetCntPeriod)) && (this.firstPass || this.tagError.getBool())) {
                result = this.protocol.requestFirmware(this.tagFirmware);
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        return result;
    }

    protected void decodeBuffinToInputs() {
        int mask = 1;
        for (int i = 0; i < 64; ++i) {
            this.inputs[i].setInt((this.buffin[i / 8] & mask) > 0 ? 1 : 0);
            if ((mask <<= 1) <= 128) continue;
            mask = 1;
        }
    }

    protected void encodeOutputsToBuffout() {
        int b = 0;
        int mask = 1;
        for (int i = 0; i < 64; ++i) {
            if (this.outputs[i].getInt() > 0) {
                b += mask;
            }
            mask <<= 1;
            if ((i + 1) % 8 != 0) continue;
            this.buffout[i / 8 + 2] = b;
            b = 0;
            mask = 1;
        }
    }

    @Override
    protected boolean reload() {
        PaPdioModule tmp = new PaPdioModule(this.plugin, this.name);
        if (!tmp.load() || !tmp.prepare()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.mode = tmp.mode;
        this.dependsOnModule = tmp.dependsOnModule;
        this.dependsOnModuleName = tmp.dependsOnModuleName;
        this.syncTags(this.inputs, tmp.inputs);
        this.syncTags(this.outputs, tmp.outputs);
        this.syncTags(this.boards, tmp.boards);
        this.inputs = tmp.inputs;
        this.outputs = tmp.outputs;
        this.boards = tmp.boards;
        return true;
    }

    private void syncTags(Tag[] mine, Tag[] theirs) {
        if (mine == null && theirs != null) {
            for (Tag tag : theirs) {
                this.tagtable.add(tag);
            }
        }
        if (mine != null && theirs == null) {
            for (Tag tag : mine) {
                this.tagtable.remove(tag);
            }
        }
    }

    private static enum Mode {
        ReadWrite,
        ReadOnly,
        WriteOnly;

    }
}

