/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.CRC;

public class WessvrAdapterModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(WessvrAdapterModule.class);
    public static final long DEFAULT_COUNTER_SIZE = 0x100000000L;
    private SortedSet<WeightHistoryRec> weightHistoryQueue = new TreeSet<WeightHistoryRec>();
    private long outputPeriodMs = 10000L;
    private long lastHistoryWeight = 0L;
    protected String module;
    protected List<Item> items = new ArrayList<Item>();
    protected List<Tag> crctags;
    protected Item itemSumWeight;
    protected Item itemOutput;
    protected Item itemErrorFlag;
    protected Item itemUpdateTime;
    protected TagRW tagMaxWeight;
    protected TagRW tagMaxNum;
    protected TagRW tagWesSvrState;
    protected Tag tagMul;
    protected Tag tagCrc32;
    private long wesSvrStateTimer;
    private boolean useNowForUpdateTime;

    public WessvrAdapterModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    protected boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.module = cm.get(conf, "module", "");
        this.outputPeriodMs = cm.get(conf, "outputPeriodS", 600) * 1000;
        Map<String, Object> refmap = cm.toMap(cm.get(conf, "tags"));
        this.itemSumWeight = this.addItem("SumWeight", refmap, Tag.Type.LONG);
        this.itemSumWeight.transform = true;
        this.addItem("SumNum", refmap, Tag.Type.LONG);
        this.addItem("CurWeight", refmap, Tag.Type.LONG);
        this.addItem("LastWeight", refmap, Tag.Type.LONG);
        this.addItem("LastTime", refmap, Tag.Type.LONG);
        this.addItem("Status1", refmap, Tag.Type.INT);
        this.addItem("Status2", refmap, Tag.Type.INT);
        this.addItem("Status3", refmap, Tag.Type.INT);
        this.addItem("Status4", refmap, Tag.Type.INT);
        this.addItem("Status5", refmap, Tag.Type.INT);
        this.itemOutput = this.addItem("Output", refmap, Tag.Type.INT);
        this.items.forEach(item -> {
            item.tag.addFlag(8);
            item.tag.setStatus(Tag.Status.Bad);
        });
        this.itemErrorFlag = this.addItem("SYSTEM.ErrorFlag", "SYSTEM.ErrorFlag", Tag.Type.BOOL);
        this.crctags = this.items.stream().map(item -> item.tag).collect(Collectors.toList());
        this.useNowForUpdateTime = cm.get(conf, "useNowForUpdateTime", false);
        this.itemUpdateTime = this.addItem("SYSTEM.UpdateTime", "SYSTEM.UpdateTime", Tag.Type.INT);
        this.tagMaxWeight = this.tagtable.createRWLong("MaxWeight", cm.get(conf, "MaxWeight", 0x100000000L));
        this.tagMaxNum = this.tagtable.createRWLong("MaxNum", cm.get(conf, "MaxNum", 0x100000000L));
        this.tagMul = this.tagtable.createInt("Mul", cm.get(conf, "Mul", 1));
        this.tagCrc32 = this.tagtable.createLong("Crc32", 0L);
        this.tagWesSvrState = this.tagtable.createRWInt("WesSvrState", 0);
        return true;
    }

    private Item addItem(String tagname, Map<String, Object> refmap, Tag.Type tagtype) {
        String refname = refmap.getOrDefault(tagname, "").toString();
        return this.addItem(tagname, refname, tagtype);
    }

    private Item addItem(String tagname, String refname, Tag.Type tagtype) {
        String[] ss = refname.split(",");
        Item item = new Item();
        item.tag = this.tagtable.createTag(tagtype, tagname);
        if (!refname.isEmpty()) {
            if (ss.length == 1) {
                item.refh = this.env.getRefFactory().createRef();
                this.initRef(item.refh, refname);
                item.refl = null;
            } else {
                item.refh = this.env.getRefFactory().createRef();
                this.initRef(item.refh, ss[0].trim());
                item.refl = this.env.getRefFactory().createRef();
                this.initRef(item.refl, ss[1].trim());
            }
        }
        this.items.add(item);
        return item;
    }

    private void initRef(Ref ref, String refname) {
        int k = refname.indexOf(58);
        if (k < 0) {
            ref.init(this.module, refname);
        } else {
            String[] ss = refname.split(":", 2);
            ref.init(ss[0], ss[1]);
        }
    }

    @Override
    protected boolean prepareModule() {
        for (Item item : this.items) {
            if (item.refh != null) {
                item.refh.prepare();
            }
            if (item.refl == null) continue;
            item.refl.prepare();
        }
        return true;
    }

    @Override
    protected boolean executeModule() {
        boolean linkedAll = true;
        for (Item item : this.items) {
            long value;
            if (item == this.itemErrorFlag) continue;
            if (item == this.itemUpdateTime && this.useNowForUpdateTime) {
                int tmpUpdateTime = Integer.parseInt(LocalTime.now().format(PeripherialModule.timeFormatter));
                this.itemUpdateTime.tag.setInt(tmpUpdateTime);
                continue;
            }
            boolean linked = false;
            if (item.refh != null) {
                linked = item.refh.linkIfNotValid();
                linkedAll &= linked;
            }
            if (item.refl != null) {
                linkedAll &= (linked &= item.refl.linkIfNotValid());
            }
            if (!linked) continue;
            if (item.refh.getTag().getType() == Tag.Type.DOUBLE) {
                value = item.transform && this.tagMul.getInt() != 1 ? (long)(item.refh.getDouble() * this.tagMul.getDouble()) : item.refh.getLong();
            } else {
                value = item.refl == null ? item.refh.getLong() : (item.refh.getLong() << 16) + item.refl.getLong();
                if (item.transform && this.tagMul.getInt() != 1) {
                    value *= (long)this.tagMul.getInt();
                }
            }
            item.tag.setLong(value);
        }
        if (this.itemErrorFlag.refh.linkIfNotValid() && linkedAll) {
            this.itemErrorFlag.tag.setBool(this.itemErrorFlag.refh.getBool());
        } else {
            this.itemErrorFlag.tag.setBool(true);
        }
        this.tagtable.setTagState(this.itemErrorFlag.tag.getBool() ? Tag.Status.Bad : Tag.Status.Good, 8);
        if (!this.itemOutput.isAssigned()) {
            this.updateWeightHistory();
            this.itemOutput.tag.setDouble(this.calcOutput());
        }
        this.wesSvrStateTimer = PeripherialModule.updateWesSvrState(this.tagWesSvrState, this.wesSvrStateTimer);
        this.tagCrc32.setLong(CRC.getOctoCrc32FromTagStream(this.crctags.stream()));
        return true;
    }

    @Override
    public String check() {
        String res = "";
        for (Item item : this.items) {
            res = res + this.check1(item.refh);
            res = res + this.check1(item.refl);
        }
        return res;
    }

    private String check1(Ref ref) {
        String res = "";
        if (ref != null) {
            res = ref.check();
            res = res + (res.isEmpty() ? "" : "\n");
        }
        return res;
    }

    @Override
    public String getInfo() {
        return "wessvr.adapter for " + this.module;
    }

    @Override
    protected boolean reload() {
        WessvrAdapterModule tmp = new WessvrAdapterModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.module = tmp.module;
        this.tagMaxWeight.setReadValLong(tmp.tagMaxWeight.getLong());
        this.tagMaxNum.setReadValLong(tmp.tagMaxNum.getLong());
        ArrayList<Tag> addList = new ArrayList<Tag>();
        ArrayList<Tag> delList = new ArrayList<Tag>();
        for (Item item : tmp.items) {
            item.tag = this.tagtable.findByNameOrAddToList(item.tag, addList);
        }
        for (Item item : this.items) {
            tmp.tagtable.findByNameOrAddToList(item.tag, delList);
        }
        this.tagtable.add(addList);
        this.tagtable.remove(delList);
        this.items = tmp.items;
        this.itemErrorFlag = tmp.itemErrorFlag;
        this.itemUpdateTime = tmp.itemUpdateTime;
        this.prepareModule();
        return true;
    }

    private void updateWeightHistory() {
        long curtimems = System.currentTimeMillis();
        if (this.lastHistoryWeight == 0L && this.itemSumWeight.tag.getLong() > 0L) {
            this.lastHistoryWeight = this.itemSumWeight.tag.getLong();
        }
        while (this.weightHistoryQueue.size() > 0 && curtimems - this.weightHistoryQueue.first().timems > this.outputPeriodMs) {
            this.weightHistoryQueue.remove(this.weightHistoryQueue.first());
        }
        while (this.weightHistoryQueue.size() > 0 && curtimems <= this.weightHistoryQueue.last().timems) {
            this.weightHistoryQueue.remove(this.weightHistoryQueue.last());
        }
        if (this.lastHistoryWeight != this.itemSumWeight.tag.getLong()) {
            this.weightHistoryQueue.add(new WeightHistoryRec(curtimems, this.itemSumWeight.tag.getLong()));
            this.lastHistoryWeight = this.itemSumWeight.tag.getLong();
        }
    }

    private double calcOutput() {
        if (this.weightHistoryQueue.size() == 0) {
            return 0.0;
        }
        long weight = this.weightHistoryQueue.last().weight - this.weightHistoryQueue.first().weight;
        if (weight < 0L) {
            weight = this.tagMaxWeight.getLong() - this.weightHistoryQueue.first().weight + this.weightHistoryQueue.last().weight;
        }
        long time = this.weightHistoryQueue.last().timems - this.weightHistoryQueue.first().timems;
        long avgDoseTime = time / (long)this.weightHistoryQueue.size();
        long timeSinceLastDosing = System.currentTimeMillis() - this.weightHistoryQueue.last().timems;
        if (avgDoseTime > 0L && timeSinceLastDosing / avgDoseTime >= 3L) {
            return 0.0;
        }
        double output = time > 1L ? 3600000.0 * (double)weight / (double)time : 0.0;
        return output;
    }

    private static final class WeightHistoryRec
    implements Comparable<WeightHistoryRec> {
        long timems;
        long weight;

        public WeightHistoryRec(long timems, long weight) {
            this.timems = timems;
            this.weight = weight;
        }

        @Override
        public int compareTo(WeightHistoryRec o) {
            return this.timems == o.timems ? 0 : (this.timems > o.timems ? 1 : -1);
        }
    }

    protected static class Item {
        Tag tag;
        Ref refh = null;
        Ref refl = null;
        boolean transform = false;

        protected Item() {
        }

        private boolean isAssigned() {
            return this.refh != null || this.refl != null;
        }
    }
}

