/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.ANSI;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.RefGroup;
import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.raduga.Context;
import promauto.jroboplc.plugin.raduga.Feeder;
import promauto.jroboplc.plugin.raduga.Line;
import promauto.jroboplc.plugin.raduga.Task;

public class Doser {
    private final Logger logger = LoggerFactory.getLogger(Doser.class);
    public static final String ERROR_NONE = "";
    public static final String ERROR_NOT_LINKED = "NOT LINKED";
    public static final String ERROR_NOT_CONNECTED = "NOT CONNECTED";
    public static final String ERROR_CRC = "CRC ERROR";
    public static final String ERROR_TASK_DIFFER = "TASK DIFFER ERROR";
    private final Context ctx;
    public final int doserNum;
    public final Line line;
    private int id;
    private String name;
    private String dupName;
    private String doserModuleName;
    public final List<Feeder> feeders;
    protected TagRW tagName;
    protected TagRW tagRcpWeight;
    protected TagRW tagSetWeight;
    protected TagRW tagExeWeight;
    protected TagRW tagCurWeight;
    protected TagRW tagCurProductName;
    protected TagRW tagConnected;
    protected TagRW tagError;
    protected TagRW tagPassQty;
    protected TagRW tagPassCnt;
    protected RefItem refCurStor;
    protected RefItem refCurWeight;
    protected RefItem refStatus;
    protected RefItem refErrorFlag;
    protected RefItem refSendTask;
    protected RefItem refCmdStartCycle;
    protected RefItem refCmdStartTask;
    protected RefItem refCmdStartLoad;
    protected RefItem refCmdStartUnload;
    protected RefItem refSumWeightMax;
    protected RefItem refSetWeightMax;
    public final RefGroup refgr;

    public Doser(Context ctx, Line line, int doserNum) {
        this.ctx = ctx;
        this.line = line;
        this.doserNum = doserNum;
        this.feeders = new ArrayList<Feeder>();
        this.refgr = ctx.env.getRefFactory().createRefGroup();
        this.dupName = ERROR_NONE;
    }

    public boolean load(Object conf) {
        Configuration cm = this.ctx.env.getConfiguration();
        this.name = cm.get(conf, "name", ERROR_NONE);
        this.doserModuleName = cm.get(conf, "module", ERROR_NONE);
        boolean res = true;
        for (String srcBunker : cm.getStringList(conf, "srcBunkers")) {
            Feeder feeder = new Feeder(this.ctx, this, this.feeders.size() + 1, srcBunker);
            res &= feeder.load();
            feeder.createRefs(this.doserModuleName);
            this.feeders.add(feeder);
        }
        TagTable tt = this.ctx.tagtable;
        Tag[] tagArray = new Tag[2];
        this.tagPassQty = tt.createRWInt(this.makeTagName("PassQty"), 0);
        tagArray[0] = this.tagPassQty;
        this.tagPassCnt = tt.createRWInt(this.makeTagName("PassCnt"), 0);
        tagArray[1] = this.tagPassCnt;
        this.ctx.addRepoTags(tagArray);
        this.tagName = tt.createRWString(this.makeTagName("Name"), this.name);
        this.tagConnected = tt.createRWBool(this.makeTagName("Connected"), false);
        this.tagError = tt.createRWString(this.makeTagName("Error"), ERROR_NONE);
        this.tagRcpWeight = tt.createRWLong(this.makeTagName("RcpWeight"), 0L);
        this.tagSetWeight = tt.createRWLong(this.makeTagName("SetWeight"), 0L);
        this.tagExeWeight = tt.createRWLong(this.makeTagName("ExeWeight"), 0L);
        this.tagCurWeight = tt.createRWLong(this.makeTagName("CurWeight"), 0L);
        this.tagCurProductName = tt.createRWString(this.makeTagName("CurProductName"), ERROR_NONE);
        this.refCurStor = this.refgr.createItem(this.doserModuleName, "CurStor");
        this.refCurWeight = this.refgr.createItem(this.doserModuleName, "CurWeight");
        this.refStatus = this.refgr.createItem(this.doserModuleName, "Status");
        this.refSendTask = this.refgr.createItem(this.doserModuleName, "SendTask");
        this.refCmdStartCycle = this.refgr.createItem(this.doserModuleName, "CmdStartCycle");
        this.refCmdStartTask = this.refgr.createItem(this.doserModuleName, "CmdStartTask");
        this.refCmdStartLoad = this.refgr.createItem(this.doserModuleName, "CmdStartLoad");
        this.refCmdStartUnload = this.refgr.createItem(this.doserModuleName, "CmdStartUnload");
        this.refSumWeightMax = this.refgr.createItem(this.doserModuleName, "SumWeightMax");
        this.refSetWeightMax = this.refgr.createItem(this.doserModuleName, "SetWeightMax");
        this.refErrorFlag = this.refgr.createItemCrc(this.doserModuleName, "SYSTEM.ErrorFlag");
        this.refgr.createItemCrcSum(this.doserModuleName, "Crc32");
        return res;
    }

    public String makeTagName(String tagname) {
        return this.line.makeTagName("D" + this.doserNum + "_" + tagname);
    }

    public void init() throws SQLException {
        this.id = this.ctx.service.syncDoser(this.name);
        for (Feeder feeder : this.feeders) {
            feeder.init();
        }
    }

    public void prepare() {
        this.refgr.prepare();
    }

    public void execute() throws SQLException {
        this.execute(false);
    }

    public void execute(boolean readonly) throws SQLException {
        String error = ERROR_NONE;
        boolean connected = false;
        if (!this.refgr.linkAndRead()) {
            error = ERROR_NOT_LINKED;
        } else if (!this.refgr.checkCrc32()) {
            error = ERROR_CRC;
        } else if (this.refErrorFlag.getTag().getBool()) {
            error = ERROR_NOT_CONNECTED;
        } else {
            connected = true;
            this.executeFeeders(readonly);
            this.updateTags();
            if (!readonly && this.isState(2) && this.isReqWeightDiffer()) {
                error = ERROR_TASK_DIFFER;
            }
        }
        this.tagConnected.setReadValBool(connected);
        this.tagError.setReadValString(error);
    }

    private void updateTags() {
        long rcpWeightSum = 0L;
        long setWeightSum = 0L;
        long exeWeightSum = 0L;
        for (Feeder feeder : this.feeders) {
            rcpWeightSum += feeder.tagRcpWeight.getLong();
            setWeightSum += feeder.tagSetWeight.getLong();
            exeWeightSum += feeder.tagExeWeight.getLong();
        }
        this.tagRcpWeight.setReadValLong(rcpWeightSum);
        this.tagSetWeight.setReadValLong(setWeightSum);
        this.tagExeWeight.setReadValLong(exeWeightSum);
        int curstor = this.refCurStor.getValue().getInt();
        if (curstor > 0 && curstor <= this.feeders.size()) {
            Feeder feeder;
            feeder = this.feeders.get(curstor - 1);
            this.tagCurProductName.setReadValString(feeder.tagProductName.getString());
        } else {
            this.tagCurProductName.setReadValString(ERROR_NONE);
        }
        this.tagCurWeight.setReadValLong(this.refCurWeight.getValue().getLong());
    }

    public void reset() {
        this.tagRcpWeight.setReadValLong(0L);
        this.tagSetWeight.setReadValLong(0L);
        this.tagExeWeight.setReadValLong(0L);
        this.tagCurProductName.setReadValString(ERROR_NONE);
        this.tagPassQty.setReadValInt(0);
        this.tagPassCnt.setReadValInt(0);
        this.feeders.forEach(Feeder::reset);
    }

    public void installTask(Task task) {
        this.reset();
        task.products.stream().filter(tp -> tp.doserName.equals(this.name) || tp.doserName.equals(this.dupName)).filter(tp -> tp.feederNum > 0 && tp.feederNum <= this.feeders.size()).forEach(tp -> {
            Feeder feeder = this.feeders.get(tp.feederNum - 1);
            feeder.tagRcpWeight.setReadValLong(tp.weight);
            feeder.tagSetWeight.setReadValLong(tp.weight);
            feeder.tagProductId.setReadValInt(tp.productId);
            feeder.tagProductName.setReadValString(tp.productName);
        });
        this.updateTags();
        this.updatePassQty();
        this.feeders.forEach(Feeder::calcSetWeightPass);
    }

    public void setSetWeight(long weight) {
        this.tagSetWeight.setReadValLong(weight);
        this.updatePassQty();
        long rcpweightSum = this.feeders.stream().mapToLong(Feeder::getRcpWeight).sum();
        if (rcpweightSum == 0L) {
            return;
        }
        double ratio = (double)weight / this.tagRcpWeight.getDouble();
        long sum = 0L;
        for (Feeder feeder : this.feeders) {
            long w = (rcpweightSum -= feeder.tagRcpWeight.getLong()) == 0L ? weight - sum : Math.round(feeder.tagRcpWeight.getDouble() * ratio);
            feeder.setSetWeight(w);
            sum += w;
        }
    }

    private void updatePassQty() {
        int passqty = this.tagSetWeight.getInt() <= 0 ? 0 : (this.refSetWeightMax.getValue().getLong() <= 0L ? 1 : (int)Math.ceil(this.tagSetWeight.getDouble() / this.refSetWeightMax.getValue().getDouble()));
        this.tagPassQty.setReadValInt(passqty);
    }

    private void executeFeeders(boolean readonly) throws SQLException {
        for (Feeder feeder : this.feeders) {
            feeder.execute(readonly);
        }
    }

    private boolean isState(int state) {
        return this.refStatus.getValue().getInt() == state;
    }

    private boolean isReqWeightDiffer() {
        return this.feeders.stream().anyMatch(Feeder::isReqWeightDiffer);
    }

    public void resetCycle() {
        this.tagPassCnt.setReadValInt(0);
        this.feeders.forEach(Feeder::resetCycle);
    }

    public void resetExeWeight() {
        this.tagExeWeight.setReadValInt(0);
        this.feeders.forEach(Feeder::resetExeWeight);
    }

    public boolean isInUse() {
        return this.tagRcpWeight.getLong() > 0L && this.tagPassCnt.getInt() < this.tagPassQty.getInt();
    }

    public void prepareTaskSend() {
        if (this.tagConnected.getBool() && !this.isState(5)) {
            this.refCmdStartCycle.getTag().setInt(1);
            this.refSendTask.getTag().setInt(0);
        }
    }

    public boolean isTaskSendReady() {
        return this.tagConnected.getBool() && this.refSendTask.getValue().getInt() == 0 && this.isState(4);
    }

    public void sendTask() {
        if (this.tagConnected.getBool()) {
            this.refSendTask.getTag().setInt(1);
        }
    }

    public boolean isTaskAccepted() {
        return this.tagConnected.getBool() && this.refSendTask.getValue().getInt() > 0;
    }

    public boolean isTaskRejected() {
        return this.tagConnected.getBool() && this.refSendTask.getValue().getInt() < 0;
    }

    public boolean isUnloadReady() {
        return this.tagConnected.getBool() && this.isState(3);
    }

    public void startLoad() {
        if (this.tagConnected.getBool()) {
            this.refCmdStartTask.getTag().setInt(1);
            this.refCmdStartLoad.getTag().setInt(1);
        }
    }

    public boolean isUnloaded() {
        return this.tagConnected.getBool() && this.isState(0);
    }

    public void startUnload() {
        if (this.tagConnected.getBool()) {
            this.refCmdStartUnload.getTag().setInt(1);
        }
    }

    public void incrementPassCnt() {
        this.tagPassCnt.setReadValInt(this.tagPassCnt.getInt() + 1);
    }

    public int getNumberOfFeedersUsed() {
        return (int)this.feeders.stream().filter(feeder -> feeder.tagRcpWeight.getLong() > 0L).count();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setDupName(String name) {
        this.dupName = name;
    }

    public long getSumWeightMax() {
        return this.refSumWeightMax.getValue().getLong();
    }

    public long getSetWeight() {
        return this.tagSetWeight.getLong();
    }

    public long getRcpWeight() {
        return this.tagRcpWeight.getLong();
    }

    public String check() {
        return this.refgr.checkln();
    }

    public String getInfo() {
        return String.format("\r\n\r        D%d %s%s %s, f: %d, id=%d %s", this.doserNum, this.name, this.dupName.isEmpty() || this.dupName.equals(this.name) ? ERROR_NONE : "/" + this.dupName, ANSI.yellow(this.doserModuleName), this.feeders.size(), this.id, ANSI.redBold(this.tagError.getString()));
    }
}

