/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.LinkedList;
import java.util.List;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Channel;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceMCHA
extends Device {
    List<Input> inpTrigres = new LinkedList<Input>();
    List<Input> inpSuspend = new LinkedList<Input>();
    List<List<Input>> inpInput = new LinkedList<List<Input>>();
    Tag tagMasterOut;
    Tag tagSost;
    Tag tagAlarm;
    Tag tagPlata;
    Tag tagCnt;
    Tag tagTrigRes;
    Tag tagControl;
    Tag tagBlok;
    Tag tagTimeStart;
    Tag tagTimeStop;
    Channel channelOut;
    Channel channelIn;
    int oldControl;
    int cntManAlarm;
    int sost;
    int cnt;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.createTagDescr();
        this.tagMasterOut = this.getOutputTag("MasterOut", res);
        this.tagSost = this.getOutputTag("Sost", res);
        this.tagAlarm = this.getOutputTag("Alarm", res);
        this.tagPlata = this.getOutputTag("Plata", res);
        this.tagCnt = this.getOutputTag("Cnt", res);
        this.tagTrigRes = this.getOutputTag("TrigRes", res);
        this.tagControl = this.getOutputTag("Control", res);
        this.tagBlok = this.getOutputTag("Blok", res);
        this.tagTimeStart = this.getOutputTag("TimeStart", res);
        this.tagTimeStop = this.getOutputTag("TimeStop", res);
        this.channelOut = this.createChannel("Channel", Channel.Type.Out, res);
        this.channelIn = this.createChannel("Channel", Channel.Type.In, res);
        this.prepareInputArrays();
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagMasterOut.setInt(0);
        this.tagSost.setInt(0);
        this.tagAlarm.setInt(0);
        this.tagPlata.setInt(0);
        this.tagCnt.setInt(0);
        this.tagTrigRes.setInt(0);
        this.sost = 0;
        this.cnt = 0;
        this.oldControl = 0;
    }

    protected void prepareInputArrays() {
        this.inpTrigres.clear();
        this.inpSuspend.clear();
        this.inpInput.clear();
        String curInpName = "";
        LinkedList<Input> curList = null;
        block8: for (Input inp : this.inputs) {
            switch (inp.name) {
                case "TrigRes": {
                    this.inpTrigres.add(inp);
                    continue block8;
                }
                case "Suspend": {
                    this.inpSuspend.add(inp);
                    continue block8;
                }
            }
            if (!inp.name.startsWith("Input")) continue;
            if (!inp.name.equals(curInpName)) {
                curList = null;
                curInpName = inp.name;
            }
            if (curList == null) {
                curList = new LinkedList<Input>();
                this.inpInput.add(curList);
            }
            curList.add(inp);
        }
    }

    public boolean getValueAnd(List<Input> list) {
        for (Input inp : list) {
            if (inp.getInt() != 0) continue;
            return false;
        }
        return list.size() > 0;
    }

    public boolean getValueOr(List<Input> list) {
        for (Input inp : list) {
            if (inp.getInt() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean execute() {
        boolean masterOut;
        boolean mstin;
        boolean pTrig = false;
        boolean pSusp = false;
        boolean pInput = false;
        int sostNew = 0;
        boolean hand_stop = false;
        boolean plataIn = false;
        boolean plataOut = false;
        int control = this.tagControl.getInt();
        this.tagAlarm.setBool(this.sost == 4);
        if (!this.linkChannels()) {
            return true;
        }
        pTrig = this.getValueOr(this.inpTrigres);
        if ((control & 4) > 0) {
            pTrig = true;
            this.tagControl.setInt(control &= 0xFB);
        }
        if (control != this.oldControl) {
            if ((control & 3) == 3 && ((control ^ this.oldControl) & 3) > 0) {
                pTrig = true;
            }
            this.oldControl = control;
        }
        pSusp = this.getValueOr(this.inpSuspend);
        for (List<Input> list : this.inpInput) {
            if (!this.getValueAnd(list)) continue;
            pInput = true;
            break;
        }
        if ((control & 3) > 0) {
            mstin = (control & 2) > 0;
            hand_stop = !mstin;
        } else {
            mstin = pInput;
        }
        boolean mstin_nosusp = mstin;
        if (pSusp) {
            mstin = false;
        } else if (this.sost == 5) {
            this.sost = 0;
        }
        plataIn = this.channelIn.tagValue.getInt() > 0;
        boolean pin = this.tagBlok.getInt() > 0 ? mstin : plataIn;
        switch (this.sost) {
            case 0: {
                if (mstin) {
                    sostNew = 2;
                    plataOut = true;
                    this.cnt = 1;
                    break;
                }
                if (pin) {
                    sostNew = 7;
                    plataOut = false;
                    break;
                }
                sostNew = 0;
                plataOut = false;
                break;
            }
            case 1: {
                if (mstin) {
                    if (pin) {
                        sostNew = 1;
                        plataOut = true;
                        this.cnt = 0;
                        break;
                    }
                    sostNew = 4;
                    plataOut = false;
                    this.cnt = 0;
                    break;
                }
                sostNew = 3;
                plataOut = this.tagTimeStop.getInt() > 0;
                this.cnt = 1;
                break;
            }
            case 2: {
                if (mstin) {
                    if (pin) {
                        if (this.cnt >= this.tagTimeStart.getInt()) {
                            sostNew = 1;
                            plataOut = true;
                            this.cnt = 0;
                            break;
                        }
                        sostNew = 2;
                        plataOut = true;
                        ++this.cnt;
                        break;
                    }
                    if (this.cnt >= this.tagTimeStart.getInt()) {
                        sostNew = 4;
                        plataOut = false;
                        this.cnt = 0;
                        break;
                    }
                    sostNew = 2;
                    plataOut = true;
                    ++this.cnt;
                    break;
                }
                sostNew = 0;
                plataOut = false;
                this.cnt = 0;
                break;
            }
            case 3: {
                if (mstin) {
                    sostNew = 2;
                    plataOut = true;
                    this.cnt = 1;
                    break;
                }
                if (this.cnt >= this.tagTimeStop.getInt() || hand_stop) {
                    if (pin) {
                        sostNew = 7;
                        plataOut = false;
                        this.cnt = 0;
                        break;
                    }
                    sostNew = 0;
                    plataOut = false;
                    this.cnt = 0;
                    break;
                }
                sostNew = 3;
                plataOut = true;
                ++this.cnt;
                break;
            }
            case 4: {
                if (mstin) {
                    if (pTrig) {
                        sostNew = 0;
                        plataOut = false;
                        break;
                    }
                    sostNew = 4;
                    plataOut = false;
                    break;
                }
                plataOut = false;
                if (pin) {
                    sostNew = 7;
                    break;
                }
                sostNew = 0;
                break;
            }
            case 7: {
                if (mstin) {
                    sostNew = 2;
                    plataOut = true;
                    this.cnt = 1;
                    break;
                }
                if (pin) {
                    sostNew = 7;
                    plataOut = false;
                    this.cnt = 0;
                    break;
                }
                sostNew = 0;
                plataOut = false;
            }
        }
        if (pSusp && this.sost != 4 && mstin_nosusp) {
            sostNew = 5;
            this.cnt = 0;
        }
        this.sost = sostNew;
        boolean bl = masterOut = this.sost == 1 && pInput;
        if (((control & 3) == 1 || (control & 3) == 3) && pInput) {
            masterOut = true;
        }
        this.channelOut.tagValue.setBool(plataOut);
        this.tagTrigRes.setBool(pTrig);
        this.tagAlarm.setBool(this.sost == 4);
        this.tagSost.setInt(this.sost);
        this.tagPlata.setBool(plataIn);
        this.tagCnt.setInt(this.cnt);
        this.tagMasterOut.setBool(masterOut);
        return true;
    }

    protected boolean linkChannels() {
        boolean chnl_ok;
        if (this.channelIn.tagAddrNum.getInt() != this.channelOut.tagAddrNum.getInt()) {
            this.channelOut.tagAddrNum.copyValueTo(this.channelIn.tagAddrNum);
        }
        chnl_ok = (chnl_ok = true) && this.channelIn.isOk();
        boolean bl = chnl_ok = chnl_ok && this.channelOut.isOk();
        if (!chnl_ok) {
            this.tagSost.setInt(8);
            return false;
        }
        return chnl_ok;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("oldControl", this.oldControl);
        state.saveVar("cntManAlarm", this.cntManAlarm);
        state.saveVar("sost", this.sost);
        state.saveVar("cnt", this.cnt);
    }

    @Override
    public void loadStateExtra(State state) {
        this.oldControl = state.loadVar("oldControl", this.oldControl);
        this.cntManAlarm = state.loadVar("cntManAlarm", this.cntManAlarm);
        this.sost = state.loadVar("sost", this.sost);
        this.cnt = state.loadVar("cnt", this.cnt);
    }
}

