/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Channel;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceZDVA
extends Device {
    Input inpEnable;
    Input inpDoOpen;
    Tag tagOutput;
    Tag tagSost;
    Tag tagOpened;
    Tag tagClosed;
    Tag tagControl;
    Tag tagBlok;
    Tag tagFlags;
    Tag tagTimeOut;
    Tag tagDlyAlarm;
    Channel chnl1out;
    Channel chnl2out;
    Channel chnl1in;
    Channel chnl2in;
    Tag tagAlarm;
    int sost;
    int almcnt;
    boolean cur_ch1out;
    boolean cur_ch2out;
    int cntChOut;
    boolean cmd_op_old;
    boolean idle_state;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.createTagDescr();
        this.inpEnable = this.getInput("Enable", res);
        this.inpDoOpen = this.getInput("DoOpen", res);
        this.tagOutput = this.getOutputTag("Output", res);
        this.tagSost = this.getOutputTag("Sost", res);
        this.tagOpened = this.getOutputTag("Opened", res);
        this.tagClosed = this.getOutputTag("Closed", res);
        this.tagControl = this.getOutputTag("Control", res);
        this.tagBlok = this.getOutputTag("Blok", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.tagTimeOut = this.getOutputTag("TimeOut", res);
        this.tagDlyAlarm = this.getOutputTag("DlyAlarm", res);
        this.chnl1out = this.createChannel("Chnl1Out", Channel.Type.Out, res);
        this.chnl2out = this.createChannel("Chnl2Out", Channel.Type.Out, res);
        this.chnl1in = this.createChannel("Chnl1In", Channel.Type.In, res);
        this.chnl2in = this.createChannel("Chnl2In", Channel.Type.In, res);
        this.tagAlarm = this.getOutputTag("Alarm", res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagOutput.setInt(0);
        this.tagSost.setInt(0);
        this.tagOpened.setInt(0);
        this.tagClosed.setInt(0);
        this.tagAlarm.setInt(0);
        this.sost = 0;
        this.almcnt = 0;
        this.cur_ch1out = false;
        this.cur_ch2out = false;
        this.cntChOut = 0;
        this.cmd_op_old = false;
        this.idle_state = false;
    }

    @Override
    public boolean execute() {
        boolean disableOutput;
        boolean ch1out = false;
        boolean ch2out = false;
        boolean ch1in = false;
        boolean ch2in = false;
        int flags = this.tagFlags.getInt();
        int control = this.tagControl.getInt();
        boolean ch1out_use = (flags & 0xC) != 8;
        boolean ch2out_use = (flags & 0xC) == 0;
        boolean ch2in_use = (flags & 0x30) != 32;
        boolean chnl_ok = this.chnl1in.isOk();
        if (ch1out_use && chnl_ok) {
            chnl_ok = this.chnl1out.isOk();
        }
        if (ch2out_use && chnl_ok) {
            chnl_ok = this.chnl2out.isOk();
        }
        if (ch2in_use && chnl_ok) {
            chnl_ok = this.chnl2in.isOk();
        }
        if (!chnl_ok) {
            this.tagSost.setInt(8);
            return false;
        }
        boolean enable = this.inpEnable.getInt() > 0;
        int ctrl1 = control & 0xF;
        int ctrl2 = control >> 4 & 0xF;
        int ctrl = ctrl1 == 0 || ctrl2 > 0 && (flags & 0x40) > 0 ? ctrl2 : ctrl1;
        boolean cmd_op = ctrl > 0 ? ctrl == 3 : this.inpDoOpen.getInt() > 0 && enable;
        boolean opened = this.tagOpened.getBool();
        boolean closed = this.tagClosed.getBool();
        if (this.tagBlok.getBool()) {
            opened = cmd_op;
            closed = !cmd_op;
        } else {
            boolean bl = ch1in = this.chnl1in.tagValue.getBool() == (flags & 0x80) > 0;
            if (ch2in_use) {
                ch2in = this.chnl2in.tagValue.getBool() == (flags & 0x80) > 0;
            }
            switch (flags & 0x30) {
                case 0: {
                    opened = ch1in;
                    closed = ch2in;
                    break;
                }
                case 16: {
                    opened = ch1in && ch2in;
                    closed = !ch1in && !ch2in;
                    break;
                }
                case 32: {
                    opened = ch1in;
                    closed = !ch1in;
                }
            }
        }
        ch1out = cmd_op;
        boolean bl = ch2out = !cmd_op;
        if ((flags & 3) < 2 && (flags & 0xC) == 0) {
            if (opened) {
                ch1out = false;
            }
            if (closed) {
                ch2out = false;
            }
        }
        boolean bl2 = disableOutput = ctrl == 1;
        if (ctrl < 2 && (!enable || disableOutput)) {
            ch1out = false;
            ch2out = false;
            cmd_op = false;
        }
        if (this.tagTimeOut.getBool() && (flags & 3) <= 1) {
            if (ch1out != this.cur_ch1out || ch2out != this.cur_ch2out) {
                this.cntChOut = 0;
            }
            this.cur_ch1out = ch1out;
            this.cur_ch2out = ch2out;
            if (!ch1out && !ch2out) {
                this.cntChOut = 0;
            } else if (this.cntChOut >= this.tagTimeOut.getInt()) {
                ch1out = false;
                ch2out = false;
            } else {
                ++this.cntChOut;
            }
        }
        if ((flags & 3) == 0 && !disableOutput) {
            if (!ch1out && !ch2out) {
                this.idle_state = true;
            }
            if (this.cmd_op_old != cmd_op) {
                this.idle_state = false;
            }
            if (this.idle_state) {
                ch1out = false;
                ch2out = false;
            }
            this.cmd_op_old = cmd_op;
        }
        boolean output = !cmd_op && closed || cmd_op && opened;
        boolean alarm = this.tagAlarm.getBool();
        if (!output && enable) {
            if (this.almcnt < this.tagDlyAlarm.getInt()) {
                alarm = false;
                ++this.almcnt;
            } else {
                alarm = true;
            }
        } else {
            alarm = false;
            this.almcnt = 0;
        }
        this.tagSost.setInt(((cmd_op ? 1 : 0) << 2) + ((opened ? 1 : 0) << 1) + (closed ? 1 : 0));
        if (ch1out_use) {
            this.chnl1out.tagValue.setBool(ch1out);
        }
        if (ch2out_use) {
            this.chnl2out.tagValue.setBool(ch2out);
        }
        this.tagOutput.setBool(output);
        this.tagAlarm.setBool(alarm);
        this.tagOpened.setBool(opened);
        this.tagClosed.setBool(closed);
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("sost", this.sost);
        state.saveVar("almcnt", this.almcnt);
        state.saveVar("cur_ch1out", this.cur_ch1out);
        state.saveVar("cur_ch2out", this.cur_ch2out);
        state.saveVar("cntChOut", this.cntChOut);
        state.saveVar("cmd_op_old", this.cmd_op_old);
        state.saveVar("idle_state", this.idle_state);
    }

    @Override
    public void loadStateExtra(State state) {
        this.sost = state.loadVar("sost", this.sost);
        this.almcnt = state.loadVar("almcnt", this.almcnt);
        this.cur_ch1out = state.loadVar("cur_ch1out", this.cur_ch1out);
        this.cur_ch2out = state.loadVar("cur_ch2out", this.cur_ch2out);
        this.cntChOut = state.loadVar("cntChOut", this.cntChOut);
        this.cmd_op_old = state.loadVar("cmd_op_old", this.cmd_op_old);
        this.idle_state = state.loadVar("idle_state", this.idle_state);
    }
}

