/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script.samples;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.plugin.script.ScriptJava;

public class Sample_OtgrelScript
extends ScriptJava {
    private final Logger logger = LoggerFactory.getLogger(Sample_OtgrelScript.class);
    private static DateTimeFormatter dtFormatter1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static DateTimeFormatter dtFormatter2 = DateTimeFormatter.ofPattern("yyyyMMdd");
    Ref refBrutto;
    Ref refNetto;
    Ref refErrorFlag;
    Ref loading;
    Ref dtBeg;
    Ref brutto;
    Ref netto;
    Ref tara;
    String filename;
    int bruttoMin;
    int nettoMin;
    int version;

    @Override
    public boolean load() {
        this.version = this.getArg("version", 1);
        this.bruttoMin = this.getArg("bruttoMin", 0);
        this.nettoMin = this.getArg("nettoMin", 0);
        this.filename = this.getArg("filename", "otgrel");
        String mod = this.getArg("module", "");
        this.refBrutto = this.createRef(mod, "Brutto");
        this.refNetto = this.createRef(mod, "Netto");
        this.refErrorFlag = this.createRef(mod, "SYSTEM.ErrorFlag");
        this.loading = this.createTag("Loading", false);
        this.dtBeg = this.createTag("DtBeg", "");
        this.brutto = this.createTag("Brutto", 0);
        this.netto = this.createTag("Netto", 0);
        this.tara = this.createTag("Tara", 0);
        return true;
    }

    @Override
    public void execute() {
        if (!this.isValid()) {
            this.dtBeg.setString("not linked");
            return;
        }
        if (this.version == 1) {
            if (this.loading.getBool()) {
                if (this.refBrutto.getInt() <= 0) {
                    if (this.brutto.getInt() > this.bruttoMin && !this.saveRecordToFile()) {
                        return;
                    }
                    this.loading.setBool(false);
                    this.brutto.setInt(0);
                    this.netto.setInt(0);
                    this.dtBeg.setString("");
                } else {
                    if (this.refBrutto.getInt() > this.brutto.getInt()) {
                        this.brutto.setInt(this.refBrutto.getInt());
                        this.netto.setInt(this.refNetto.getInt());
                    }
                    if (this.refNetto.getInt() > this.netto.getInt()) {
                        this.netto.setInt(this.refNetto.getInt());
                    }
                }
            } else if (this.refBrutto.getInt() > 0) {
                this.loading.setBool(true);
                this.brutto.setInt(this.refBrutto.getInt());
                this.netto.setInt(this.refNetto.getInt());
                this.dtBeg.setString(LocalDateTime.now().format(dtFormatter1));
            }
        }
        if (this.version == 2) {
            if (this.loading.getBool()) {
                if (this.netto.getInt() > 0 && this.refNetto.getInt() <= 0) {
                    if (this.netto.getInt() > this.nettoMin && !this.saveRecordToFile()) {
                        return;
                    }
                    this.loading.setBool(false);
                    this.netto.setInt(0);
                    this.dtBeg.setString("");
                } else {
                    if (this.refNetto.getInt() > this.netto.getInt()) {
                        this.brutto.setInt(this.refBrutto.getInt());
                        this.netto.setInt(this.refNetto.getInt());
                    }
                    if (this.refBrutto.getInt() > this.brutto.getInt()) {
                        this.brutto.setInt(this.refBrutto.getInt());
                    }
                }
                if (this.refBrutto.getInt() <= 0 && this.refNetto.getInt() <= 0) {
                    this.loading.setBool(false);
                    this.brutto.setInt(0);
                    this.netto.setInt(0);
                    this.dtBeg.setString("");
                }
            } else {
                if (this.refBrutto.getInt() >= this.bruttoMin && this.refNetto.getInt() == 0) {
                    this.loading.setBool(true);
                    this.netto.setInt(0);
                    this.dtBeg.setString(LocalDateTime.now().format(dtFormatter1));
                }
                this.brutto.setInt(this.refBrutto.getInt());
            }
        }
        this.tara.setInt(this.brutto.getInt() - this.netto.getInt());
    }

    private boolean saveRecordToFile() {
        String dtEnd = LocalDateTime.now().format(dtFormatter1);
        String s = String.format("%s,%s,%s,%s", this.dtBeg.getString(), dtEnd, this.brutto.getString(), this.netto.getString()) + System.lineSeparator();
        try {
            Files.write(Paths.get(this.filename + "_" + LocalDateTime.now().format(dtFormatter2) + ".csv", new String[0]), s.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

