/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script.samples;

import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.plugin.script.ScriptJava;

public class Sample_PIDMelassa1
extends ScriptJava {
    Ref vzlErrorFlag;
    Ref vzlFlow;
    Ref vzlVolInt;
    Ref vzlVolFloat;
    Ref dnfErrorFlag;
    Ref dnfMinRef;
    Ref dnfMaxRef;
    Ref dnfSource1;
    Ref dnfState;
    Ref dnfFreqOut;
    Ref dnfFreqSet;
    Ref FlowInp;
    Ref FlowInpMh;
    Ref SumVolume;
    Ref FreqSetHz;
    Ref FreqOutHz;
    Ref PrevError;
    Ref Integral;
    Ref Diff;
    Ref Output;
    Ref Running;
    Ref Connected;
    Ref Enable;
    Ref Manual;
    Ref FlowSet;
    Ref FreqLowHz;
    Ref Kp;
    Ref Ki;
    Ref Kd;

    @Override
    public boolean load() {
        String vzl = this.getArg("vzl", "");
        String dnf = this.getArg("dnf", "");
        this.vzlErrorFlag = this.createRef(vzl, "SYSTEM.ErrorFlag");
        this.vzlFlow = this.createRef(vzl, "Flow");
        this.vzlVolInt = this.createRef(vzl, "VolPlusInt");
        this.vzlVolFloat = this.createRef(vzl, "VolPlusFloat");
        this.dnfErrorFlag = this.createRef(dnf, "SYSTEM.ErrorFlag");
        this.dnfMinRef = this.createRef(dnf, "MinRef");
        this.dnfMaxRef = this.createRef(dnf, "MaxRef");
        this.dnfSource1 = this.createRef(dnf, "Source1");
        this.dnfState = this.createRef(dnf, "State");
        this.dnfFreqOut = this.createRef(dnf, "FreqOut");
        this.dnfFreqSet = this.createRef(dnf, "FreqSet");
        this.FlowInp = this.createTag("FlowInp", 0);
        this.FlowInpMh = this.createTag("FlowInpV", 0);
        this.SumVolume = this.createTag("SumVolume", 0L);
        this.FreqSetHz = this.createTag("FreqSetHz", 0.0);
        this.FreqOutHz = this.createTag("FreqOutHz", 0);
        this.PrevError = this.createTag("Error", 0.0);
        this.Integral = this.createTag("Integral", 0.0);
        this.Diff = this.createTag("Diff", 0.0);
        this.Output = this.createTag("Output", 0.0);
        this.Running = this.createTag("Running", 0);
        this.Connected = this.createTag("Connected", 0);
        this.Enable = this.createTag("Enable", 0, 1);
        this.Manual = this.createTag("Manual", 0, 1);
        this.FlowSet = this.createTag("FlowSet", 0, 1);
        this.FreqLowHz = this.createTag("FreqLowHz", 0, 1);
        this.Kp = this.createTag("Kp", 0, 1);
        this.Kd = this.createTag("Kd", 0, 1);
        this.Ki = this.createTag("Ki", 0, 1);
        return true;
    }

    @Override
    public void execute() {
        boolean enable = this.Enable.getBool();
        boolean manual = this.Manual.getBool();
        boolean running = (this.dnfState.getInt() & 0x800) > 0;
        boolean connected = this.vzlErrorFlag.getInt() + this.dnfErrorFlag.getInt() == 0;
        this.Running.setBool(running);
        this.Connected.setBool(connected);
        this.FlowInp.setInt((int)Math.round(this.vzlFlow.getDouble() * 1000.0));
        this.FlowInpMh.setInt((int)Math.round(this.vzlFlow.getDouble() * 60.0));
        this.SumVolume.setLong(this.vzlVolInt.getLong() * 1000L + Math.round(this.vzlVolFloat.getDouble() * 1000.0));
        double minref = this.dnfMinRef.getDouble();
        double maxref = this.dnfMaxRef.getDouble();
        double refrange = maxref - minref;
        int freqOutHz = (int)Math.round(this.dnfFreqOut.getDouble() / 16384.0 * refrange + minref);
        this.FreqOutHz.setInt(freqOutHz);
        if (this.dnfSource1.getInt() != 0) {
            if (this.dnfFreqSet.getInt() != 0) {
                this.dnfFreqSet.setInt(0);
            }
            this.FreqSetHz.setInt(0);
            this.PrevError.setInt(0);
            this.Integral.setInt(0);
            return;
        }
        if (running && enable && !manual) {
            if (connected) {
                double error = this.FlowSet.getDouble() - this.vzlFlow.getDouble() * 1000.0;
                double kp = this.Kp.getDouble() / 1000.0;
                double kd = this.Kd.getDouble() / 1000.0;
                double ki = this.Ki.getDouble() / 1000.0;
                double integral = this.Ki.getDouble() == 0.0 ? 0.0 : this.Integral.getDouble() + error;
                double diff = kd * (error - this.PrevError.getDouble());
                double output = kp * error + diff + ki * integral;
                double freqSetHz = this.FreqSetHz.getDouble() + output;
                double freqLowHz = this.FreqLowHz.getDouble();
                double freqHighHz = this.dnfMaxRef.getDouble();
                freqSetHz = Math.max(freqSetHz, freqLowHz);
                if ((freqSetHz = Math.min(freqSetHz, freqHighHz)) == freqLowHz && (double)this.FreqSetHz.getInt() == freqLowHz && output < 0.0) {
                    integral = 0.0;
                }
                if (freqSetHz == freqHighHz && (double)this.FreqSetHz.getInt() == freqHighHz && output > 0.0) {
                    integral = 0.0;
                }
                this.Integral.setDouble(integral);
                this.Diff.setDouble(diff);
                this.PrevError.setDouble(error);
                this.Output.setDouble(output);
                this.FreqSetHz.setDouble(freqSetHz);
            }
        } else {
            this.FreqSetHz.setInt(0);
            this.PrevError.setInt(0);
            this.Integral.setInt(0);
            this.Diff.setInt(0);
            this.Output.setInt(0);
        }
        int freqSet = 0;
        if (refrange > 0.0) {
            freqSet = Math.max(0, (int)Math.round((this.FreqSetHz.getDouble() - minref) / refrange * 8192.0));
        }
        if (!manual) {
            this.dnfFreqSet.setInt(freqSet);
        }
    }
}

