/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script.samples;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.plugin.script.ScriptJava;

public class WatchdogScript
extends ScriptJava {
    private final Logger logger = LoggerFactory.getLogger(WatchdogScript.class);
    Ref tagAlarm;
    Ref refLiveTag;
    int lastValue;
    long lastTime;
    long timeout;
    String cmd;
    String liveTagName;

    @Override
    public boolean load() {
        this.tagAlarm = this.createTag("alarm", 0);
        this.liveTagName = this.getArg("livetag", "");
        this.refLiveTag = this.createRef(this.liveTagName);
        this.cmd = this.getArg("cmd", "");
        this.timeout = (long)this.getArg("timeout", 10) * 1000L;
        this.lastValue = 0;
        this.lastTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public void execute() {
        if (!this.refLiveTag.isValid()) {
            this.tagAlarm.setInt(-1);
            return;
        }
        if (this.refLiveTag.getInt() == this.lastValue) {
            if (this.tagAlarm.getInt() != 1) {
                if (this.lastTime > System.currentTimeMillis()) {
                    this.lastTime = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this.lastTime > this.timeout) {
                    this.tagAlarm.setInt(1);
                    if (!this.cmd.isEmpty()) {
                        try {
                            EnvironmentInst.get().printInfo(this.logger, "Watchdog fired: " + this.liveTagName + " = " + this.refLiveTag.getString());
                            Runtime.getRuntime().exec(this.cmd);
                        }
                        catch (IOException e) {
                            EnvironmentInst.get().logError(this.logger, e, new String[0]);
                        }
                    }
                }
            }
        } else {
            this.lastValue = this.refLiveTag.getInt();
            this.tagAlarm.setInt(0);
            this.lastTime = System.currentTimeMillis();
        }
    }
}

