/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.tcpconsole;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractConsole;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.TcpServerChannel;
import promauto.jroboplc.plugin.tcpconsole.TcpConsoleModule;

public class TcpConsoleClient
extends AbstractConsole {
    private final Logger logger = LoggerFactory.getLogger(TcpConsoleClient.class);
    private TcpServerChannel consoleChannel;
    protected TcpConsoleModule module;

    public TcpConsoleClient(Environment env, TcpConsoleModule module, TcpServerChannel channel) {
        super(env);
        this.module = module;
        this.consoleChannel = channel;
    }

    public void onRequest(TcpServerChannel channel, String request) {
        String answer;
        if (this.module.needPassword) {
            if (request.equals(this.module.password)) {
                answer = "\r\n" + this.getPrompt();
                this.module.needPassword = false;
            } else {
                answer = "\r\nIncorrect password!\r\nEnter password: ";
            }
        } else {
            boolean forbidden = false;
            if (this.module.regexForbidden != null) {
                forbidden = this.module.regexForbidden.matcher(request).matches();
            }
            if (this.module.listForbidden != null) {
                forbidden = this.module.listForbidden.stream().anyMatch(forbcmd -> request.startsWith((String)forbcmd));
            }
            answer = forbidden ? "Forbidden command!" : this.env.getCmdDispatcher().execute(this, request);
            answer = answer + "\r\n" + this.getPrompt();
            this.afterRequestExecuted(request);
        }
        channel.write(this.prepareText(answer));
        if (!request.trim().isEmpty()) {
            this.logger.info("[INPUT-" + channel.getRemoteAddress().getAddress().getHostAddress() + "] " + request);
        }
    }

    private String prepareText(String text) {
        return new String(this.parseAnsi(text).getBytes(StandardCharsets.UTF_8), Charset.defaultCharset());
    }

    @Override
    public synchronized void print(String text) {
        try {
            this.consoleChannel.write(this.prepareText(text));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDisconnect() {
        this.stopRepeatingLastRequest();
    }

    @Override
    public boolean initialize() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public void process() {
    }
}

