/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import promauto.jroboplc.core.ModuleManagerImpl;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;

public class ConfigurationYaml
implements Configuration {
    public static final String APPLICATION_YML = "application.yml";
    public static final int MAX_ALIASES_FOR_COLLECTIONS = 100;
    private final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private final String confdir;
    private Map<String, Object> confmap;

    public ConfigurationYaml(String confdir) {
        this.confdir = confdir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean load() {
        Throwable throwable;
        HashMap<String, Object> tmpmap = new HashMap<String, Object>();
        try {
            throwable = null;
            try (InputStream in = ModuleManagerImpl.class.getClassLoader().getResourceAsStream(APPLICATION_YML);){
                Yaml yaml = ConfigurationYaml.createYaml();
                tmpmap.putAll((Map)yaml.load(in));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(null, e, "Failed to load application.yml");
        }
        try {
            throwable = null;
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(Paths.get(this.confdir, new String[0]), "[!.]*.yml");){
                for (Path path : paths) {
                    if (this.loadFile(path, tmpmap)) continue;
                    System.out.println("Configuration error: " + path.toString() + "\r\n");
                    boolean bl = false;
                    return bl;
                }
                this.confmap = tmpmap;
                return true;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException | InvalidPathException e) {
            System.out.println("Configuration error: " + this.confdir + "\r\n");
            e.printStackTrace();
            return false;
        }
    }

    private boolean loadFile(Path path, Map<String, Object> map) {
        Map<Object, Object> root = ConfigurationYaml.loadYamlFileAsMap(path);
        if (root == null) {
            return false;
        }
        for (Map.Entry<Object, Object> ent : root.entrySet()) {
            String key;
            String string = key = ent.getKey() instanceof String ? (String)ent.getKey() : ent.getKey().toString();
            if (key.startsWith("plugin.") && map.containsKey(key)) {
                Map plgmap = (Map)map.get(key);
                Map addmap = (Map)ent.getValue();
                plgmap.putAll(addmap);
                continue;
            }
            map.put(key, ent.getValue());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<Object, Object> loadYamlFileAsMap(Path path) {
        Yaml yaml = ConfigurationYaml.createYaml();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            Object res = yaml.load(in);
            HashMap<Object, Object> hashMap = res == null ? new HashMap() : (Map)res;
            return hashMap;
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(null, e, "File:", path.toString());
            return null;
        }
    }

    private static Yaml createYaml() {
        LoaderOptions lo = new LoaderOptions();
        lo.setMaxAliasesForCollections(100);
        lo.setAllowDuplicateKeys(false);
        lo.setAllowRecursiveKeys(false);
        return new Yaml(lo);
    }

    @Override
    public Map<String, Object> getRoot() {
        return this.confmap;
    }

    @Override
    public Object getModuleConf(String plugin, String module) {
        Object plgconf = this.confmap.get("plugin." + plugin);
        if (plgconf != null) {
            try {
                Object modconf = ((Map)plgconf).get("module." + module);
                if (modconf != null) {
                    return modconf;
                }
            }
            catch (ClassCastException e) {
                EnvironmentInst.get().printError(this.logger, e, plugin, module);
            }
        }
        EnvironmentInst.get().printError(this.logger, "Configuration not found:", plugin, module);
        return null;
    }

    @Override
    public Path getPath(Object conf, String key, String defval) {
        Path path = Paths.get(this.get(conf, key, defval), new String[0]);
        if (!path.isAbsolute()) {
            path = this.getConfDir().resolve(path);
        }
        return path;
    }

    @Override
    public Object get(Object conf, String key) {
        try {
            return ((Map)conf).get(key);
        }
        catch (ClassCastException e) {
            EnvironmentInst.get().printError(this.logger, e, "key:", key);
            return null;
        }
    }

    @Override
    public int get(Object conf, String key, int defval) {
        Object obj = null;
        try {
            obj = ((Map)conf).get(key);
            if (obj != null) {
                return (Integer)obj;
            }
        }
        catch (ClassCastException e) {
            EnvironmentInst.get().printError(this.logger, e, "key:", key, "val:", obj == null ? "" : obj.toString());
        }
        return defval;
    }

    @Override
    public long get(Object conf, String key, long defval) {
        Object obj = null;
        try {
            obj = ((Map)conf).get(key);
            if (obj != null) {
                return obj instanceof Integer ? (long)((Integer)obj).intValue() : (Long)obj;
            }
        }
        catch (ClassCastException e) {
            EnvironmentInst.get().printError(this.logger, e, "key:", key, "val:", obj == null ? "" : obj.toString());
        }
        return defval;
    }

    @Override
    public double get(Object conf, String key, double defval) {
        Object obj = null;
        try {
            obj = ((Map)conf).get(key);
            if (obj != null) {
                return (Double)obj;
            }
        }
        catch (ClassCastException e) {
            EnvironmentInst.get().printError(this.logger, e, "key:", key, "val:", obj == null ? "" : obj.toString());
        }
        return defval;
    }

    @Override
    public boolean get(Object conf, String key, boolean defval) {
        Object obj = null;
        try {
            obj = ((Map)conf).get(key);
            if (obj != null) {
                return (Boolean)obj;
            }
        }
        catch (ClassCastException e) {
            EnvironmentInst.get().printError(this.logger, e, "key:", key, "val:", obj == null ? "" : obj.toString());
        }
        return defval;
    }

    @Override
    public String get(Object conf, String key, String defval) {
        Object obj = null;
        try {
            obj = ((Map)conf).get(key);
            if (obj != null) {
                if (obj instanceof String) {
                    return (String)obj;
                }
                return obj.toString();
            }
        }
        catch (ClassCastException e) {
            EnvironmentInst.get().printError(this.logger, e, "key:", key, "val:", obj == null ? "" : obj.toString());
        }
        return defval;
    }

    @Override
    public List<String> getStringList(Object conf, String key) {
        return this.toList(this.get(conf, key)).stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> toMap(Object conf) {
        if (conf != null) {
            try {
                return (Map)conf;
            }
            catch (ClassCastException e) {
                EnvironmentInst.get().printError(this.logger, e, new String[0]);
            }
        }
        return new HashMap<String, Object>();
    }

    @Override
    public <K, V> Map<K, V> toGenericMap(Object conf) {
        if (conf != null) {
            try {
                return (Map)conf;
            }
            catch (ClassCastException e) {
                EnvironmentInst.get().printError(this.logger, e, new String[0]);
            }
        }
        return new HashMap();
    }

    @Override
    public List<Object> toList(Object conf) {
        if (conf != null) {
            if (conf instanceof List) {
                return (List)conf;
            }
            if (conf instanceof Map) {
                return new ArrayList<Object>(((Map)conf).keySet());
            }
        }
        return new ArrayList<Object>();
    }

    @Override
    public Path getConfDir() {
        try {
            return Paths.get(this.confdir, new String[0]);
        }
        catch (InvalidPathException e) {
            EnvironmentInst.get().printError(this.logger, e, new String[0]);
            return Paths.get(".", new String[0]);
        }
    }
}

