/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class OwenMa110_1tModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(OwenMa110_1tModule.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Tag tagStatus;
    protected Tag tagMode;
    protected TagRW tagDecN;
    protected TagRW tagDecI;
    protected TagRW tagDecF;
    protected Tag tagValueN;
    protected Tag tagValueI;
    protected Tag tagValueF;
    protected TagRW tagApply;

    public OwenMa110_1tModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagStatus = this.tagtable.createInt("Status", 0, 8);
        this.tagMode = this.tagtable.createInt("Mode", 0, 8);
        this.tagDecN = this.protocol.addWriteTag(18, this.tagtable.createRWInt("DecN", 0, 8));
        this.tagDecI = this.protocol.addWriteTag(21, this.tagtable.createRWInt("DecI", 0, 8));
        this.tagDecF = this.protocol.addWriteTag(24, this.tagtable.createRWInt("DecF", 0, 8));
        this.tagValueN = this.tagtable.createInt("ValueN", 0, 8);
        this.tagValueI = this.tagtable.createInt("ValueI", 0, 8);
        this.tagValueF = this.tagtable.createInt("ValueF", 0, 8);
        this.tagApply = this.protocol.addWriteTag(33, this.tagtable.createRWInt("Apply129", 0, 8));
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        this.addChannelMapTag(chtags, this.tagValueF, "0");
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagDecN.acceptWriteValue();
            this.tagDecI.acceptWriteValue();
            this.tagDecF.acceptWriteValue();
            this.tagApply.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            if (result) {
                result = this.protocol.sendWriteTags(6);
            }
            if (result && (result = this.protocol.requestCmd3(16, 18))) {
                this.tagStatus.setInt(this.protocol.getAnswerWord(0));
                this.tagMode.setInt(this.protocol.getAnswerWord(1));
                this.tagDecN.setReadValInt(this.protocol.getAnswerWord(2));
                this.tagValueN.setInt(this.protocol.getAnswerInt32(3));
                this.tagDecI.setReadValInt(this.protocol.getAnswerWord(5));
                this.tagValueI.setInt(this.protocol.getAnswerInt32(6));
                this.tagDecF.setReadValInt(this.protocol.getAnswerWord(8));
                this.tagValueF.setInt(this.protocol.getAnswerInt32(9));
                this.tagApply.setReadValInt(this.protocol.getAnswerWord(17));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

