/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.sql.SQLException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.raduga.Context;
import promauto.jroboplc.plugin.raduga.DataService;
import promauto.jroboplc.plugin.raduga.Doser;
import promauto.jroboplc.plugin.raduga.Task;

public class Feeder {
    private final Logger logger = LoggerFactory.getLogger(Feeder.class);
    private final Context ctx;
    private int id;
    public final int feederNum;
    public final Doser doser;
    public final String bunkerName;
    private int bunkerId;
    protected TagRW tagRcpWeight;
    protected TagRW tagSetWeight;
    protected TagRW tagSetWeightPass;
    protected TagRW tagExeWeight;
    protected TagRW tagSumWeight;
    protected TagRW tagSumWeightBeg;
    protected TagRW tagProductId;
    protected TagRW tagProductName;
    protected RefItem refSumWeight;
    protected RefItem refReqWeight;
    protected RefItem refSetWeight;
    private boolean newborn;

    public Feeder(Context ctx, Doser doser, int feederNum, String bunkerName) {
        this.ctx = ctx;
        this.feederNum = feederNum;
        this.doser = doser;
        this.bunkerName = bunkerName;
        this.newborn = true;
    }

    public boolean load() {
        TagTable tt = this.ctx.tagtable;
        Tag[] tagArray = new Tag[8];
        this.tagRcpWeight = tt.createRWLong(this.makeTagName("RcpWeight"), 0L);
        tagArray[0] = this.tagRcpWeight;
        this.tagSetWeight = tt.createRWLong(this.makeTagName("SetWeight"), 0L);
        tagArray[1] = this.tagSetWeight;
        this.tagSetWeightPass = tt.createRWLong(this.makeTagName("SetWeightPass"), 0L);
        tagArray[2] = this.tagSetWeightPass;
        this.tagExeWeight = tt.createRWLong(this.makeTagName("ExeWeight"), 0L);
        tagArray[3] = this.tagExeWeight;
        this.tagSumWeight = tt.createRWLong(this.makeTagName("SumWeight"), 0L);
        tagArray[4] = this.tagSumWeight;
        this.tagSumWeightBeg = tt.createRWLong(this.makeTagName("SumWeightBeg"), -1L);
        tagArray[5] = this.tagSumWeightBeg;
        this.tagProductId = tt.createRWInt(this.makeTagName("ProductId"), 0);
        tagArray[6] = this.tagProductId;
        this.tagProductName = tt.createRWString(this.makeTagName("ProductName"), "");
        tagArray[7] = this.tagProductName;
        this.ctx.addRepoTags(tagArray);
        return true;
    }

    public void createRefs(String bindModuleName) {
        this.refSumWeight = this.doser.refgr.createItemCrc(bindModuleName, "SumWeight" + this.feederNum);
        this.refReqWeight = this.doser.refgr.createItem(bindModuleName, "ReqWeight" + this.feederNum);
        this.refSetWeight = this.doser.refgr.createItem(bindModuleName, "SetWeight" + this.feederNum);
    }

    private String makeTagName(String tagname) {
        return this.doser.makeTagName("F" + this.feederNum + "_" + tagname);
    }

    public void init() throws SQLException {
        this.id = this.ctx.service.syncFeeder(this.doser.getId(), this.feederNum);
        this.bunkerId = this.ctx.service.syncFeederBunker(this.id, this.bunkerName);
    }

    public void execute() throws SQLException {
        this.execute(false);
    }

    public void execute(boolean readonly) throws SQLException {
        this.calcSetWeightPass();
        if (!readonly) {
            this.refSetWeight.getTag().setLong(this.tagSetWeightPass.getLong());
        }
        if (this.newborn) {
            this.newborn = false;
            this.tagSumWeight.setReadValLong(this.refSumWeight.getValue().getLong());
        }
        if (this.tagSumWeight.getLong() != this.refSumWeight.getValue().getLong()) {
            if (!readonly) {
                this.saveWeight();
            }
            this.tagSumWeight.setReadValLong(this.refSumWeight.getValue().getLong());
        }
        if (!readonly) {
            this.updateTags();
        }
    }

    private long getSubstractedWeight(long weightBeg, long weightEnd) {
        long weight = weightEnd - weightBeg;
        if (weight < 0L) {
            weight += this.doser.getSumWeightMax() + 1L;
        }
        return weight;
    }

    private void saveWeight() throws SQLException {
        DataService svc = this.ctx.service;
        Task.Exec te = new Task.Exec();
        te.dt = this.ctx.now();
        te.periodShift = this.ctx.periods.calcPeriodShift(te.dt);
        te.periodHour = this.ctx.periods.calcPeriodHour(te.dt);
        te.feederId = this.id;
        te.lineId = this.doser.line.getId();
        long weightBeg = this.tagSumWeight.getLong();
        long weightEnd = this.refSumWeight.getValue().getLong();
        Optional<Long> weightEndLast = svc.getTaskExecLastSumWeightEnd(this.id);
        if (weightEndLast.isPresent()) {
            te.weight = this.getSubstractedWeight(weightEndLast.get(), weightBeg);
            if (te.weight > 0L) {
                te.sumWeightBeg = weightEndLast.get();
                te.sumWeightEnd = weightBeg;
                svc.saveTaskExec(te);
            }
        }
        te.taskId = this.doser.line.getTaskId();
        te.cycleId = this.doser.line.getCycleId();
        te.weight = this.getSubstractedWeight(weightBeg, weightEnd);
        te.sumWeightBeg = weightBeg;
        te.sumWeightEnd = weightEnd;
        te.inputProductId = this.tagProductId.getInt();
        te.inputBunkerId = this.bunkerId;
        te.outputProductId = this.doser.line.getDstProductId();
        te.outputBunkerId = this.doser.line.getDstBunkerId();
        svc.saveTaskExec(te);
        if (this.canCalcExeWeight()) {
            this.ctx.taskrepo.addTotalExeWeight(te.taskId, te.weight);
        }
    }

    private void updateTags() {
        this.tagExeWeight.setReadValLong(this.canCalcExeWeight() ? this.getSubstractedWeight(this.tagSumWeightBeg.getLong(), this.refSumWeight.getValue().getLong()) : 0L);
    }

    private boolean canCalcExeWeight() {
        return this.tagSumWeightBeg.getLong() >= 0L;
    }

    public void calcSetWeightPass() {
        int passQty = this.doser.tagPassQty.getInt();
        int passCnt = this.doser.tagPassCnt.getInt();
        long weight = 0L;
        if (passCnt < passQty) {
            if (passQty == 1) {
                weight = this.tagSetWeight.getLong();
            } else {
                weight = Math.round(this.tagSetWeight.getDouble() / (double)passQty);
                if (passCnt == passQty - 1) {
                    weight = this.tagSetWeight.getLong() - weight * (long)passCnt;
                }
            }
        }
        this.tagSetWeightPass.setReadValLong(weight);
    }

    public void setSetWeight(long weight) {
        this.tagSetWeight.setReadValLong(weight);
        this.calcSetWeightPass();
    }

    public void reset() {
        this.tagRcpWeight.setReadValLong(0L);
        this.tagSetWeight.setReadValLong(0L);
        this.tagSetWeightPass.setReadValLong(0L);
        this.tagExeWeight.setReadValLong(0L);
        this.tagSumWeightBeg.setReadValLong(-1L);
        this.tagProductId.setReadValInt(0);
        this.tagProductName.setReadValString("");
    }

    public void resetCycle() {
        this.tagSumWeightBeg.setReadValLong(this.refSumWeight.getValue().getLong());
    }

    public void resetExeWeight() {
        this.tagExeWeight.setReadValLong(0L);
        this.tagSumWeightBeg.setReadValLong(-1L);
    }

    public boolean isReqWeightDiffer() {
        return this.tagSetWeightPass.getLong() != this.refReqWeight.getValue().getLong();
    }

    public long getRcpWeight() {
        return this.tagRcpWeight.getLong();
    }

    public int getId() {
        return this.id;
    }
}

