/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.RoboplantModule;

public class ConnectManager {
    private final Logger logger = LoggerFactory.getLogger(ConnectManager.class);
    private State state = new State();
    private State backup = null;
    private Environment env;

    public ConnectManager(Environment env) {
        this.env = env;
    }

    public boolean loadConnectors(RoboplantModule _module, Object conf) {
        boolean result = true;
        this.removeConnectors(_module);
        Configuration cm = this.env.getConfiguration();
        Map<String, Object> conf_connect = cm.toMap(cm.get(conf, "connect"));
        for (Map.Entry<String, Object> ent : conf_connect.entrySet()) {
            String devicename = _module.getName() + ':' + ent.getKey();
            String modulename = ent.getValue().toString();
            if (modulename.equals("---")) {
                this.state.notConnectedModuleNames.add(devicename);
            }
            this.state.deviceModule.put(devicename, modulename);
        }
        if (conf_connect.size() > 0 || this.state.notConnectedModuleNames.size() > 0) {
            this.state.roboplantModules.add(_module);
        }
        return result;
    }

    public void removeConnectors(RoboplantModule _module) {
        if (this.state.roboplantModules.contains(_module)) {
            String modname = _module.getName() + ":";
            this.state.deviceModule.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(modname));
            this.state.notConnectedModuleNames.removeIf(devmodname -> devmodname.startsWith(modname));
        }
    }

    public Module getConnectedModule(RoboplantModule module, Device device) {
        String modulename = this.state.deviceModule.get(module.getName() + ':' + device.devtype + '.' + device.tagname);
        if (modulename == null) {
            return null;
        }
        return this.env.getModuleManager().getModule(modulename);
    }

    public boolean isNotConnected(RoboplantModule module, Device device) {
        return this.state.notConnectedModuleNames.contains(module.getName() + ':' + device.devtype + '.' + device.tagname);
    }

    public void backupState() {
        this.backup = new State();
        this.backup.deviceModule.putAll(this.state.deviceModule);
        this.backup.roboplantModules.addAll(this.state.roboplantModules);
        this.backup.notConnectedModuleNames.addAll(this.state.notConnectedModuleNames);
    }

    public void restoreState() {
        if (this.backup == null) {
            return;
        }
        this.state.deviceModule.putAll(this.backup.deviceModule);
        this.state.roboplantModules.addAll(this.backup.roboplantModules);
        this.state.notConnectedModuleNames.addAll(this.backup.notConnectedModuleNames);
        this.resetState();
    }

    public void resetState() {
        this.backup = null;
    }

    public static class State {
        public Map<String, String> deviceModule = new HashMap<String, String>();
        public Set<RoboplantModule> roboplantModules = new HashSet<RoboplantModule>();
        public Set<String> notConnectedModuleNames = new HashSet<String>();
    }
}

