/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceDIFFA
extends Device {
    Input inpInpVal;
    Input inpSetVal;
    Tag tagOutVal;
    Tag tagInpVal;
    Tag tagSetVal;
    Tag tagCycleTime;
    Tag tagDlyStart;
    Tag tagGain;
    Tag tagMaxOutVal;
    Tag tagEnable;
    int cnt;
    int startCnt;
    int outval;
    int inpval;
    int setval;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpInpVal = this.getInput("InpVal", res);
        this.inpSetVal = this.getInput("SetVal", res);
        this.tagOutVal = this.getOutputTag("OutVal", res);
        this.tagInpVal = this.getOutputTag("InpVal", res);
        this.tagSetVal = this.getOutputTag("InpSet", res);
        this.tagCycleTime = this.getOutputTag("CycleTime", res);
        this.tagDlyStart = this.getOutputTag("DlyStart", res);
        this.tagGain = this.getOutputTag("Gain", res);
        this.tagMaxOutVal = this.getOutputTag("maxOutVal", res);
        this.tagEnable = this.getOutputTag("Enable", res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagOutVal.setInt(0);
        this.cnt = 0;
        this.startCnt = 0;
        this.outval = 0;
        this.inpval = 0;
        this.setval = 0;
    }

    @Override
    public boolean execute() {
        if (this.inpInpVal.refaddr != 28672) {
            this.inpval = this.inpInpVal.getInt();
            this.tagInpVal.setInt(this.inpval);
        } else {
            this.inpval = this.tagInpVal.getInt();
        }
        if (this.inpSetVal.refaddr != 28672) {
            this.setval = this.inpSetVal.getInt();
            this.tagSetVal.setInt(this.setval);
        } else {
            this.setval = this.tagSetVal.getInt();
        }
        if (this.inpval == 0 || !this.tagEnable.getBool()) {
            this.outval = this.setval;
            this.startCnt = 0;
        } else if (this.startCnt < this.tagDlyStart.getInt()) {
            ++this.startCnt;
            this.outval = this.setval;
            this.cnt = 0;
        } else if (++this.cnt >= this.tagCycleTime.getInt()) {
            this.cnt = 0;
            float r = (float)this.outval + ((float)this.setval - (float)this.inpval) * (float)this.tagGain.getInt() / 100.0f;
            if (r < 0.0f) {
                r = 0.0f;
            }
            if (r > 65535.0f) {
                r = 65535.0f;
            }
            if (this.tagMaxOutVal.getInt() > 0 && r > (float)this.tagMaxOutVal.getInt()) {
                r = this.tagMaxOutVal.getInt();
            }
            this.outval = Math.round(r);
        }
        this.tagOutVal.setInt(this.outval);
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("cnt", this.cnt);
        state.saveVar("startCnt", this.startCnt);
        state.saveVar("outval", this.outval);
        state.saveVar("inpval", this.inpval);
        state.saveVar("setval", this.setval);
    }

    @Override
    public void loadStateExtra(State state) {
        this.cnt = state.loadVar("cnt", this.cnt);
        this.startCnt = state.loadVar("startCnt", this.startCnt);
        this.outval = state.loadVar("outval", this.outval);
        this.inpval = state.loadVar("inpval", this.inpval);
        this.setval = state.loadVar("setval", this.setval);
    }
}

