/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceVALA
extends Device {
    private static final int ALWAYS_ENABLED = 1;
    private static final int VALIN_IGNORED = 2;
    private static final int VALIN_TO_VALSET_DISABLED = 4;
    Input inpValIn;
    Input inpEnable;
    Tag tagValOut;
    Tag tagValSet;
    Tag tagDlyEnOn;
    Tag tagDlyEnOff;
    Tag tagFlags;
    int enable;
    int timer;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpValIn = this.getInput("ValIn", res);
        this.inpEnable = this.getInput("Enable", res);
        this.tagValOut = this.getOutputTag("ValOut", res);
        this.tagValSet = this.getOutputTag("ValSet", res);
        this.tagDlyEnOn = this.getOutputTag("DlyEnOn", res);
        this.tagDlyEnOff = this.getOutputTag("DlyEnOff", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagValOut.setInt(0);
        this.enable = 0;
        this.timer = 0;
    }

    @Override
    public boolean execute() {
        int flags = this.tagFlags.getInt();
        int valout = this.tagValSet.getInt();
        if (!this.inpValIn.isEmpty() && (flags & 2) == 0) {
            valout = this.inpValIn.getInt();
            if ((flags & 4) == 0) {
                this.tagValSet.setInt(valout);
            }
        }
        if ((flags & 1) > 0) {
            this.enable = 1;
        } else if (this.enable != this.inpEnable.getInt()) {
            this.timer = this.timer <= 0 ? (this.inpEnable.tag.getBool() ? this.tagDlyEnOn.getInt() : this.tagDlyEnOff.getInt()) : --this.timer;
            if (this.timer <= 0) {
                this.enable = this.inpEnable.getInt();
            }
        } else {
            this.timer = 0;
        }
        this.tagValOut.setInt(this.enable > 0 ? valout : 0);
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("enable", this.enable);
        state.saveVar("timer", this.timer);
    }

    @Override
    public void loadStateExtra(State state) {
        this.enable = state.loadVar("enable", this.enable);
        this.timer = state.loadVar("timer", this.timer);
    }
}

