/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.Set;
import java.util.stream.Collectors;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Comp;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;
import promauto.jroboplc.plugin.roboplant.Output;
import promauto.jroboplc.plugin.roboplant.RoboplantModule;
import promauto.jroboplc.plugin.roboplant.RoboplantPlugin;

public class Reloader {
    protected RoboplantPlugin plg;
    protected RoboplantModule mod;
    protected RoboplantModule tmp;
    protected State state = new State();

    public Reloader(RoboplantModule mod) {
        this.mod = mod;
        this.plg = (RoboplantPlugin)mod.getPlugin();
    }

    public boolean reload() {
        this.saveState();
        this.plg.getConnectManager().backupState();
        this.plg.getConnectManager().removeConnectors(this.mod);
        this.tmp = new RoboplantModule((RoboplantPlugin)this.mod.getPlugin(), this.mod.getName());
        Object conf = EnvironmentInst.get().getConfiguration().getModuleConf(this.mod.getPlugin().getPluginName(), this.mod.getName());
        if (conf == null) {
            return false;
        }
        if (this.tmp.load(conf)) {
            this.mod.copySettingsFrom(this.tmp);
            this.transferTags();
            try {
                if (this.tmp.prepare()) {
                    this.mod.channelManager = this.tmp.channelManager;
                    this.assignNewDevices();
                    this.loadState();
                    this.plg.getConnectManager().resetState();
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.tmp.closedown();
            }
        }
        this.plg.getConnectManager().restoreState();
        return false;
    }

    protected void saveState() {
        for (Device d : this.mod.devicesByOrder) {
            d.saveState(this.state);
        }
    }

    protected void loadState() {
        for (Device d : this.mod.devicesByOrder) {
            d.loadState(this.state);
        }
    }

    protected void transferTags() {
        for (Device d : this.tmp.devicesByOrder) {
            for (Input inp : d.inputs) {
                if (!inp.isConst()) continue;
                int constvalue = inp.tag.getInt();
                this.replaceCompTag(inp);
                inp.tag.setInt(constvalue);
            }
            for (Output out : d.outputs) {
                this.replaceCompTag(out);
            }
        }
    }

    private void replaceCompTag(Comp comp) {
        Tag tag = this.mod.getTagTable().get(comp.tag.getName());
        if (tag != null && tag.getType() == comp.tag.getType()) {
            tag.copyFlagsFrom(comp.tag);
            this.tmp.getTagTable().remove(comp.tag);
            this.tmp.getTagTable().add(tag);
            comp.tag = tag;
        }
    }

    protected void assignNewDevices() {
        this.mod.devicesByAddr = this.tmp.devicesByAddr;
        this.mod.devicesByOrder = this.tmp.devicesByOrder;
        this.mod.devicesByAddrCount = this.tmp.devicesByAddrCount;
        Set<String> oldtags = this.mod.getTagTable().values().stream().map(Tag::getName).collect(Collectors.toSet());
        Set newtags = this.tmp.getTagTable().values().stream().map(Tag::getName).collect(Collectors.toSet());
        oldtags.removeAll(newtags);
        oldtags.forEach(tagname -> this.mod.getTagTable().remove((String)tagname));
        this.mod.getTagTable().clear();
        this.tmp.getTagTable().values().forEach(tag -> this.mod.getTagTable().add(tag));
        this.tmp.getTagTable().clear();
    }
}

