/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.rpsvrtcp;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.TcpServerChannel;
import promauto.jroboplc.core.api.TcpServerPort;
import promauto.jroboplc.core.api.TcpSubscriber;
import promauto.jroboplc.plugin.rpsvrtcp.CmdDebugInfoWrite;
import promauto.jroboplc.plugin.rpsvrtcp.CmdHiddenTags;
import promauto.jroboplc.plugin.rpsvrtcp.CmdInfofSetFlag;
import promauto.jroboplc.plugin.rpsvrtcp.RpsvrtcpClient;
import promauto.utils.Strings;

public class RpsvrtcpModule
extends AbstractModule
implements TcpSubscriber {
    private final Logger logger = LoggerFactory.getLogger(RpsvrtcpModule.class);
    private int portnum;
    protected boolean hiddentags;
    protected Pattern incl;
    protected Pattern excl;
    private Set<RpsvrtcpClient> clients = new HashSet<RpsvrtcpClient>();
    protected Set<String> transparentModules = new HashSet<String>();
    public boolean infoSetFlag = false;
    protected Console debugConsole = null;
    protected boolean debugInfoWrite = false;

    public RpsvrtcpModule(Plugin plugin, String name) {
        super(plugin, name);
        this.taskable = false;
        this.env.getCmdDispatcher().addCommand(this, CmdHiddenTags.class);
        this.env.getCmdDispatcher().addCommand(this, CmdInfofSetFlag.class);
        this.env.getCmdDispatcher().addCommand(this, CmdDebugInfoWrite.class);
    }

    @Override
    public boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.portnum = cm.get(conf, "portnum", 0);
        this.enable = cm.get(conf, "enable", true);
        this.hiddentags = cm.get(conf, "hiddentags", false);
        this.incl = Strings.getFilterPattern(cm.get(conf, "incl", ""));
        this.excl = Strings.getFilterPattern(cm.get(conf, "excl", ""));
        cm.toList(cm.get(conf, "transparent")).stream().forEach(obj -> this.transparentModules.add(obj.toString()));
        return true;
    }

    @Override
    public boolean prepareModule() {
        if (this.env.getTcpServer().subscribe(this.portnum, this)) {
            return true;
        }
        this.env.printError(this.logger, this.name);
        return false;
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.enable) {
            sb.append("p" + this.portnum + ", ");
            sb.append("hidden=" + this.hiddentags);
            sb.append("\r\n");
            int i = 0;
            for (RpsvrtcpClient client : this.clients) {
                sb.append("  " + ++i + ": ");
                sb.append(client.getInfo());
                sb.append("\r\n");
            }
            return sb.toString();
        }
        return "disabled";
    }

    @Override
    public boolean onTcpServerClientConnected(TcpServerChannel channel) {
        String clientAddress = channel.getRemoteAddress().getAddress().getHostAddress();
        this.env.printInfo(this.logger, this.name, "Connected:", clientAddress);
        RpsvrtcpClient client = new RpsvrtcpClient(this, clientAddress);
        channel.setAttachedObject(client);
        this.clients.add(client);
        channel.write("100-Roboplant OPC Server (TCP)\r\n100 RpSvrTcp ver3\r\n");
        return true;
    }

    @Override
    public boolean onTcpServerClientDisconnected(TcpServerChannel channel) {
        this.env.printInfo(this.logger, this.name, "Disconnected:", channel.getRemoteAddress().getAddress().getHostAddress());
        Object obj = channel.getAttachedObject();
        if (obj != null && obj instanceof RpsvrtcpClient) {
            RpsvrtcpClient client = (RpsvrtcpClient)obj;
            client.release();
            return this.clients.remove(client);
        }
        return false;
    }

    @Override
    public boolean onTcpServerRequest(TcpServerChannel channel, String request) {
        if (channel.getAttachedObject() != null && channel.getAttachedObject() instanceof RpsvrtcpClient) {
            ((RpsvrtcpClient)channel.getAttachedObject()).onRequest(channel, request);
        }
        return true;
    }

    @Override
    protected boolean reload() {
        RpsvrtcpModule tmp = new RpsvrtcpModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        TcpServerPort port_old = this.env.getTcpServer().getPortBySubscriber(this);
        TcpServerPort port_new = this.env.getTcpServer().getPortByNum(tmp.portnum);
        if (tmp.enable && port_new == null) {
            this.env.printError(this.logger, this.name, "Port not found: " + tmp.portnum);
            return false;
        }
        this.copySettingsFrom(tmp);
        int portnum_old = this.portnum;
        this.portnum = tmp.portnum;
        this.hiddentags = tmp.hiddentags;
        this.incl = tmp.incl;
        this.excl = tmp.excl;
        this.transparentModules = tmp.transparentModules;
        if (this.enable && this.env.isRunning() && port_new != null && port_old != port_new) {
            port_new.setSubscriber(this);
        }
        if (port_old != null && port_old != port_new) {
            this.env.getTcpServer().disconnect(portnum_old);
            port_old.setSubscriber(null);
        }
        return true;
    }
}

