/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.SerialPort;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.serial.SerialManagerModule;

public class SerialPortUsriot
implements SerialPort {
    final Logger logger = LoggerFactory.getLogger(SerialPortUsriot.class);
    private static final Charset charset = Charset.forName("windows-1251");
    private Socket socketData;
    private InputStream inputData;
    private OutputStream outputData;
    private volatile boolean valid = true;
    private volatile boolean opened = false;
    private String host;
    private int port;
    private InetSocketAddress addrData;
    private static final int BUFFIN_SIZE = 2048;
    private byte[] buffin = new byte[2048];
    private int id;
    private int baud;
    private int databits;
    private int parity;
    private int stopbits;
    private int timeout_ms;
    private boolean noTcpDelay;
    private boolean connectionLost = false;
    private long connectionLostTime = 0L;
    private long recon_ms = 3000L;
    private long liveness = 0L;
    private SerialManagerModule module;
    private TagRW tagOpened;

    public SerialPortUsriot(SerialManagerModule module) {
        this.module = module;
    }

    public synchronized boolean load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.id = cm.get(conf, "id", 0);
        this.baud = cm.get(conf, "baud", 9600);
        this.recon_ms = cm.get(conf, "recon_ms", 3000);
        this.timeout_ms = cm.get(conf, "timeout", 500);
        this.noTcpDelay = cm.get(conf, "no_tcpdelay", true);
        this.host = cm.get(conf, "host", "");
        this.port = cm.get(conf, "port", 0);
        this.addrData = new InetSocketAddress(this.host, this.port);
        String sbits = cm.get(conf, "bits", "8/0/1");
        String[] bits = sbits.split("/");
        this.databits = bits.length > 0 ? Integer.parseInt(bits[0]) : 8;
        this.parity = bits.length > 1 ? Integer.parseInt(bits[1]) : 0;
        this.stopbits = bits.length > 2 ? Integer.parseInt(bits[2]) : 1;
        this.tagOpened = this.module.getTagOpened(this.id);
        return this.checkParams(this.databits, this.parity, this.stopbits);
    }

    private boolean checkParams(int databits, int parity, int stopbits) {
        if (115200 % this.baud > 0 || this.baud < 50 || databits < 5 || databits > 8 || parity < 0 || parity > 4 || stopbits < 1 || stopbits > 2) {
            EnvironmentInst.get().printError(this.logger, this.module.getName(), this.getDescr(), "Bad bits configuration");
            return false;
        }
        return true;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public synchronized boolean setParams(int baud, int databits, int parity, int stopbits, int timeout) {
        boolean reopen = false;
        reopen |= baud != this.baud;
        reopen |= databits != this.databits;
        reopen |= parity != this.parity;
        reopen |= stopbits != this.stopbits;
        reopen &= this.opened;
        if (!this.checkParams(databits, parity, stopbits)) {
            return false;
        }
        this.baud = baud;
        this.databits = databits;
        this.parity = parity;
        this.stopbits = stopbits;
        this.timeout_ms = timeout;
        boolean res = true;
        if (reopen) {
            this.close();
            res = this.open();
        }
        return res;
    }

    @Override
    public synchronized boolean open() {
        return this.open(false);
    }

    public synchronized boolean open(boolean silent) {
        if (this.opened) {
            return true;
        }
        boolean bl = this.opened = this.connectSocket(silent) && this.applyParams();
        if (!this.opened) {
            this.connectionLost = true;
            this.disconnectSocket();
        } else {
            this.connectionLost = false;
            this.tagOpened.setReadValInt(1);
        }
        return this.opened;
    }

    protected boolean connectSocket(boolean silent) {
        try {
            this.socketData = null;
            this.socketData = new Socket();
            this.socketData.setSoTimeout(this.timeout_ms);
            this.socketData.setTcpNoDelay(this.noTcpDelay);
            this.socketData.connect(this.addrData, this.timeout_ms);
            this.inputData = this.socketData.getInputStream();
            this.outputData = this.socketData.getOutputStream();
        }
        catch (Exception e) {
            if (!silent) {
                EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Connect socket:", this.getDescr());
            }
            return false;
        }
        return true;
    }

    private void disconnectSocket() {
        if (this.socketData != null) {
            try {
                this.socketData.close();
            }
            catch (Exception e) {
                EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Disconnect socket", this.getDescr());
            }
            this.socketData = null;
        }
        this.opened = false;
        this.tagOpened.setReadValInt(0);
    }

    private boolean applyParams() {
        try {
            this.buffin[0] = 85;
            this.buffin[1] = -86;
            this.buffin[2] = 85;
            this.buffin[3] = (byte)(this.baud >> 16 & 0xFF);
            this.buffin[4] = (byte)(this.baud >> 8 & 0xFF);
            this.buffin[5] = (byte)(this.baud & 0xFF);
            this.buffin[6] = (byte)(this.databits - 5 + (this.stopbits > 1 ? 4 : 0) + (this.parity > 0 ? 8 + (this.parity << 4) : 0));
            this.buffin[7] = (byte)(this.buffin[3] + this.buffin[4] + this.buffin[5] + this.buffin[6] & 0xFF);
            this.outputData.write(this.buffin, 0, 8);
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Apply params:", this.getDescr());
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (!this.opened) {
            return;
        }
        this.disconnectSocket();
        this.connectionLost = false;
    }

    private void checkLiveness() {
        boolean ok = this.socketData.isBound();
        ok &= !this.socketData.isClosed();
        ok &= this.socketData.isConnected();
        ok &= !this.socketData.isInputShutdown();
        if (ok &= !this.socketData.isOutputShutdown()) {
            if (this.liveness == 0L) {
                this.liveness = System.currentTimeMillis();
                return;
            }
            if (System.currentTimeMillis() - this.liveness < this.recon_ms) {
                return;
            }
        }
        this.liveness = 0L;
        if (this.opened) {
            this.disconnectSocket();
            if (this.open(true)) {
                return;
            }
            EnvironmentInst.get().printError(this.logger, this.module.getName(), this.getDescr(), "Connection lost");
            this.connectionLost = true;
            this.connectionLostTime = System.currentTimeMillis();
        }
    }

    private void affirmLiveness() {
        this.liveness = 0L;
    }

    private String getDescr() {
        return "Serial port " + this.id + " (Usr410 " + this.host + ":" + this.port + ")";
    }

    private boolean restoreConnectionIfLost() {
        if (!this.connectionLost) {
            return true;
        }
        if (System.currentTimeMillis() - this.connectionLostTime < this.recon_ms) {
            return false;
        }
        if (this.open(true)) {
            EnvironmentInst.get().printInfo(this.logger, this.getDescr(), "Connection restored");
            return true;
        }
        this.connectionLostTime = System.currentTimeMillis();
        return false;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setInvalid() {
        this.valid = false;
    }

    @Override
    public int getAvailable() throws IOException {
        return this.inputData.available();
    }

    @Override
    public synchronized int readByte() {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return -1;
        }
        try {
            int b = this.inputData.read();
            this.affirmLiveness();
            return b;
        }
        catch (IOException iOException) {
            this.checkLiveness();
            return -1;
        }
    }

    @Override
    public synchronized int readBytes(int[] buff, int size) {
        if (!this.restoreConnectionIfLost()) {
            return 0;
        }
        if (!this.opened) {
            return 0;
        }
        long time = System.currentTimeMillis();
        int n = 0;
        byte[] bufftmp = new byte[size];
        try {
            int p = 0;
            while ((n += this.inputData.read(bufftmp, p, size - p)) < size && System.currentTimeMillis() - time < (long)this.timeout_ms) {
                p = n;
            }
        }
        catch (IOException p) {
            // empty catch block
        }
        if (n > size) {
            n = size;
        }
        for (int i = 0; i < n; ++i) {
            buff[i] = bufftmp[i] & 0xFF;
        }
        if (n == size) {
            this.affirmLiveness();
            return n;
        }
        this.checkLiveness();
        return -n;
    }

    @Override
    public synchronized int readBytesDelim(int[] buff, int delim) {
        int size;
        block7: {
            if (!this.restoreConnectionIfLost()) {
                return 0;
            }
            if (!this.opened) {
                return 0;
            }
            long time = System.currentTimeMillis();
            int sizemax = buff.length;
            size = 0;
            try {
                block6: {
                    int b;
                    do {
                        if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                            this.checkLiveness();
                            return -size;
                        }
                        b = this.inputData.read();
                        if (size >= sizemax) break block6;
                        buff[size++] = b;
                    } while (b != delim);
                    break block7;
                }
                return -size;
            }
            catch (IOException e) {
                this.checkLiveness();
                return -size;
            }
        }
        this.affirmLiveness();
        return size;
    }

    @Override
    public synchronized String readString(int size) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return "";
        }
        long time = System.currentTimeMillis();
        int n = 0;
        try {
            byte[] bufftmp = new byte[size];
            int p = 0;
            while ((n += this.inputData.read(bufftmp, p, size - p)) != size) {
                if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                    this.checkLiveness();
                    return "";
                }
                p = n;
            }
            if (n == size) {
                this.affirmLiveness();
                return new String(bufftmp, charset);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.checkLiveness();
        return "";
    }

    @Override
    public synchronized String readStringDelim(int delim) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return "";
        }
        long time = System.currentTimeMillis();
        StringBuilder sb = null;
        int i = 0;
        int b = -1;
        try {
            while (true) {
                if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                    this.checkLiveness();
                    return "";
                }
                b = this.inputData.read();
                this.buffin[i++] = (byte)b;
                if (b != delim) {
                    if (i < 2048) continue;
                    i = 0;
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(new String(Arrays.copyOf(this.buffin, i), charset));
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (b != delim) {
            this.checkLiveness();
        } else {
            this.affirmLiveness();
        }
        if (sb == null) {
            return new String(Arrays.copyOf(this.buffin, i), charset);
        }
        sb.append(new String(Arrays.copyOf(this.buffin, i), charset));
        return sb.toString();
    }

    @Override
    public synchronized boolean writeByte(int data) {
        if (!this.restoreConnectionIfLost()) {
            return false;
        }
        if (!this.opened) {
            return false;
        }
        try {
            this.outputData.write(data);
        }
        catch (IOException e) {
            this.checkLiveness();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean writeBytes(int[] data, int size) {
        if (!this.restoreConnectionIfLost()) {
            return false;
        }
        if (!this.opened) {
            return false;
        }
        byte[] bufftmp = new byte[size];
        for (int i = 0; i < size; ++i) {
            bufftmp[i] = (byte)data[i];
        }
        try {
            this.outputData.write(bufftmp);
        }
        catch (IOException e) {
            this.checkLiveness();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean writeString(String data) {
        if (!this.restoreConnectionIfLost()) {
            return false;
        }
        if (!this.opened) {
            return false;
        }
        try {
            this.outputData.write(data.getBytes(charset));
        }
        catch (IOException e) {
            this.checkLiveness();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean discard() {
        if (!this.opened) {
            return false;
        }
        try {
            if (this.inputData.available() > 0) {
                this.inputData.skip(this.inputData.available());
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public String getInfo() {
        return String.format("%d: usr410 %s:%d %d %d/%d/%d %d %s", this.id, this.host, this.port, this.baud, this.databits, this.parity, this.stopbits, this.timeout_ms, this.opened ? "opened" : "closed");
    }
}

