/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.plugin.wessvr.DeviceBase;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class DeviceGeliosMaslo2v2
extends DeviceBase {
    public static final String MODTYPE = "GeliosMaslo2v2";
    protected RefItem refCrc;
    protected RefItem refWeightHigh1;
    protected RefItem refWeightLow1;
    protected RefItem refNumHigh1;
    protected RefItem refNumLow1;
    protected RefItem refWeightHigh2;
    protected RefItem refWeightLow2;
    protected RefItem refNumHigh2;
    protected RefItem refNumLow2;
    protected RefItem refWeightHigh;
    protected RefItem refWeightLow;
    protected RefItem refNumHigh;
    protected RefItem refNumLow;
    protected RefItem refState;
    protected RefItem refErrorCode;
    protected RefItem refStopCode;
    private int counter;
    private String name_without_counter;

    public DeviceGeliosMaslo2v2(WessvrModule module) {
        super(module);
        this.sizeSumWeight = 0x100000000L;
        this.sizeSumNum = 0x100000000L;
    }

    @Override
    public String getModtype() {
        return MODTYPE;
    }

    @Override
    public boolean load(ResultSet rs) throws SQLException {
        this.name_without_counter = this.name;
        boolean res = super.load(rs);
        this.counter = 1;
        Matcher m = Pattern.compile("(.*)\\.(\\d+)$").matcher(this.name);
        if (m.matches()) {
            this.name_without_counter = m.group(1);
            this.counter = Integer.parseInt(m.group(2));
        }
        return res;
    }

    @Override
    protected void createRefs() {
        String name_original = this.name;
        this.name = this.name_without_counter;
        super.createRefs();
        this.refCrc = this.refs.createItemCrcSum(this.name, "Crc16");
        this.refWeightHigh1 = this.refs.createItemCrc(this.name, "WeightHigh1");
        this.addVldZero(this.addVldFFFF(this.refWeightHigh1));
        this.refWeightLow1 = this.refs.createItemCrc(this.name, "WeightLow1");
        this.addVldZero(this.addVldFFFF(this.refWeightLow1));
        this.refNumHigh1 = this.refs.createItemCrc(this.name, "NumHigh1");
        this.addVldZero(this.addVldFFFF(this.refNumHigh1));
        this.refNumLow1 = this.refs.createItemCrc(this.name, "NumLow1");
        this.addVldZero(this.addVldFFFF(this.refNumLow1));
        this.refWeightHigh2 = this.refs.createItemCrc(this.name, "WeightHigh2");
        this.addVldZero(this.addVldFFFF(this.refWeightHigh2));
        this.refWeightLow2 = this.refs.createItemCrc(this.name, "WeightLow2");
        this.addVldZero(this.addVldFFFF(this.refWeightLow2));
        this.refNumHigh2 = this.refs.createItemCrc(this.name, "NumHigh2");
        this.addVldZero(this.addVldFFFF(this.refNumHigh2));
        this.refNumLow2 = this.refs.createItemCrc(this.name, "NumLow2");
        this.addVldZero(this.addVldFFFF(this.refNumLow2));
        if (this.counter == 2) {
            this.refWeightHigh = this.refWeightHigh2;
            this.refWeightLow = this.refWeightLow2;
            this.refNumHigh = this.refNumHigh2;
            this.refNumLow = this.refNumLow2;
        } else {
            this.refWeightHigh = this.refWeightHigh1;
            this.refWeightLow = this.refWeightLow1;
            this.refNumHigh = this.refNumHigh1;
            this.refNumLow = this.refNumLow1;
        }
        this.refs.addItemCrc(this.refErrorFlag);
        this.refState = this.refs.createItem(this.name, "State");
        this.refErrorCode = this.refs.createItem(this.name, "ErrorCode");
        this.refStopCode = this.refs.createItem(this.name, "StopCode");
        this.name = name_original;
    }

    @Override
    protected long getSumWeight() {
        return ((long)this.refWeightHigh.getValue().getInt() << 16) + (long)this.refWeightLow.getValue().getInt();
    }

    @Override
    protected long getSumNum() {
        return ((long)this.refNumHigh.getValue().getInt() << 16) + (long)this.refNumLow.getValue().getInt();
    }

    @Override
    protected boolean updateValuesStatus() {
        if (!this.hasStatusValuesChanged(this.refState, this.refErrorCode, this.refStopCode)) {
            return false;
        }
        this.statusValues[0] = this.refState.getValue().getInt();
        this.statusValues[1] = this.refErrorCode.getValue().getInt();
        this.statusValues[2] = this.refStopCode.getValue().getInt();
        return true;
    }

    @Override
    protected boolean updateValuesArcval() {
        if (this.arcvalValues[0] == this.getSumWeight() && this.arcvalValues[1] == this.getSumNum()) {
            return false;
        }
        this.arcvalValues[0] = this.getSumWeight();
        this.arcvalValues[1] = this.getSumNum();
        this.arcvalValues[4] = this.refErrorCode.getValue().getInt();
        return true;
    }
}

