/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.util.List;
import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.plugin.wessvr.DeviceBase;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class DeviceStandard
extends DeviceBase {
    public static final String MODTYPE = "Standard";
    protected RefItem refCrc;
    protected RefItem refSumWeight;
    protected RefItem refSumNum;
    protected RefItem refCurWeight;
    protected RefItem refLastWeight;
    protected RefItem refLastTime;
    protected RefItem refStatus1;
    protected RefItem refStatus2;
    protected RefItem refStatus3;
    protected RefItem refStatus4;
    protected RefItem refStatus5;
    protected RefItem refOutput;
    private RefItem refMaxWeight;
    private RefItem refMaxNum;
    private boolean modeCrc32;

    public DeviceStandard(WessvrModule module) {
        super(module);
        this.sizeSumWeight = 0x80000000L;
        this.sizeSumNum = 0x80000000L;
        this.modeCrc32 = true;
    }

    @Override
    public String getModtype() {
        return MODTYPE;
    }

    @Override
    protected void createRefs() {
        super.createRefs();
        this.refCrc = this.refs.createItemCrcSum(this.name, "Crc32");
        this.refSumWeight = this.addVldZero(this.refs.createItemCrc(this.name, "SumWeight"));
        this.refSumNum = this.addVldZero(this.refs.createItemCrc(this.name, "SumNum"));
        this.refCurWeight = this.addVldZero(this.refs.createItemCrc(this.name, "CurWeight"));
        this.refLastWeight = this.addVldZero(this.refs.createItemCrc(this.name, "LastWeight"));
        this.refLastTime = this.addVldZero(this.refs.createItemCrc(this.name, "LastTime"));
        this.refStatus1 = this.addVldZero(this.refs.createItemCrc(this.name, "Status1"));
        this.refStatus2 = this.addVldZero(this.refs.createItemCrc(this.name, "Status2"));
        this.refStatus3 = this.addVldZero(this.refs.createItemCrc(this.name, "Status3"));
        this.refStatus4 = this.addVldZero(this.refs.createItemCrc(this.name, "Status4"));
        this.refStatus5 = this.addVldZero(this.refs.createItemCrc(this.name, "Status5"));
        this.refOutput = this.refs.createItemCrc(this.name, "Output");
        this.refs.addItemCrc(this.refErrorFlag);
        this.refMaxWeight = this.refs.createItem(this.name, "MaxWeight");
        this.refMaxNum = this.refs.createItem(this.name, "MaxNum");
    }

    @Override
    protected void doAfterRefsRead() {
        this.sizeSumWeight = this.refMaxWeight.getValue().getLong();
        this.sizeSumNum = this.refMaxNum.getValue().getLong();
    }

    @Override
    protected boolean checkCrc() {
        return !this.modeCrc32 || this.refs.checkCrc32();
    }

    @Override
    protected boolean linkRefs() {
        List<RefItem> notlinked;
        boolean linked = this.refs.link();
        if (this.modeCrc32 && !linked && (notlinked = this.refs.getItemsNotLinked()).size() == 1 && notlinked.get(0) == this.refCrc) {
            this.refs.removeItem(this.refCrc);
            linked = true;
            this.modeCrc32 = false;
        }
        return linked;
    }

    @Override
    protected long getSumWeight() {
        return this.refSumWeight.getValue().getLong();
    }

    @Override
    protected long getSumNum() {
        return this.refSumNum.getValue().getLong();
    }

    @Override
    protected boolean updateValuesStatus() {
        if (!this.hasStatusValuesChanged(this.refStatus1, this.refStatus2, this.refStatus3, this.refStatus4, this.refStatus5)) {
            return false;
        }
        this.statusValues[0] = this.refStatus1.getValue().getInt();
        this.statusValues[1] = this.refStatus2.getValue().getInt();
        this.statusValues[2] = this.refStatus3.getValue().getInt();
        this.statusValues[3] = this.refStatus4.getValue().getInt();
        this.statusValues[4] = this.refStatus5.getValue().getInt();
        return true;
    }

    @Override
    protected boolean updateValuesArcval() {
        if (this.arcvalValues[0] == this.getSumWeight() && this.arcvalValues[1] == this.getSumNum()) {
            return false;
        }
        this.arcvalValues[0] = this.getSumWeight();
        this.arcvalValues[1] = this.getSumNum();
        this.arcvalValues[2] = this.refLastWeight.getValue().getInt();
        this.arcvalValues[3] = this.refLastTime.getValue().getInt();
        this.arcvalValues[4] = 0L;
        return true;
    }

    @Override
    protected double getArcoutValue() {
        return this.refOutput.getValue().getDouble();
    }
}

