/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.arcsvr;

import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.arcsvr.ArcvalBase;
import promauto.jroboplc.plugin.arcsvr.ArcvalHolder;
import promauto.utils.IniFile;

public class ArcvalRobo
extends ArcvalBase {
    private final Logger logger = LoggerFactory.getLogger(ArcvalRobo.class);
    private Map<String, Rec> recs = new TreeMap<String, Rec>();

    public ArcvalRobo(ArcvalHolder arcvalHolder, String arcname) {
        super(arcvalHolder, arcname);
        this.ftype = ArcvalBase.FieldType.INT16;
    }

    public void load(IniFile ini, String section, String tagpath) throws Exception {
        this.descr = ini.getString(section, "Description", "");
        this.period_ms = ini.getInt(section, "Period", 2000);
        this.arcsize = ini.getInt(section, "Size", 604800);
        int tagcount = ini.getInt(section, "TagCount", 0);
        String stype = ini.getString(section, "Type", "INT16");
        try {
            this.ftype = ArcvalBase.FieldType.valueOf(stype.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.env.printError(this.logger, e, this.module.getName(), this.arcname, "Bad type = " + stype);
        }
        Pattern p = Pattern.compile("([^.]*)\\.(.*)");
        for (int i = 0; i < tagcount; ++i) {
            String s = ini.getString(section, "Tag" + i, "");
            String[] ss = s.split(";");
            Rec rec = new Rec();
            if (tagpath.isEmpty()) {
                Matcher m = p.matcher(ss[0]);
                if (!m.find()) {
                    throw new Exception("Tag rec error: " + section + ", " + i + " = " + s);
                }
                rec.tagpath = m.group(1).trim();
                rec.tagname = m.group(2).trim();
            } else {
                rec.tagpath = tagpath;
                rec.tagname = ss[0].trim();
            }
            rec.descr = ss.length > 1 ? ss[1] : "";
            rec.tag = null;
            this.recs.put(rec.getPathTagname(), rec);
        }
    }

    @Override
    public void link() {
        for (Module mod : this.env.getModuleManager().getModules()) {
            for (Tag tag : mod.getTagTable().values()) {
                String tagname;
                Rec rec;
                if (tag.getType() == Tag.Type.STRING || tag.getStatus() == Tag.Status.Deleted || (rec = this.recs.get(tagname = tag.hasFlags(4) ? tag.getName() : mod.getName() + '.' + tag.getName())) == null) continue;
                rec.tag = tag;
            }
        }
    }

    @Override
    public boolean init() {
        super.init();
        boolean bl = this.period_align = this.period_ms >= 60000;
        if (this.period_align) {
            long curms = System.currentTimeMillis();
            long curdayms = LocalTime.now().toNanoOfDay() / 1000000L;
            this.lastpass_ms = curms - curdayms % (long)this.period_ms;
        }
        boolean res = false;
        Database db = this.module.getDatabase();
        try (Statement st = db.getConnection().createStatement();){
            this.initArc(st);
            this.initTags(st);
            db.commit();
            List<Integer> idtags = this.recs.values().stream().map(rec -> rec.idtag).collect(Collectors.toList());
            this.initArctable(st, idtags);
            db.commit();
            this.initPst(idtags);
            this.initCurrec(st);
            db.commit();
            res = true;
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.module.getName(), this.arcname, "Init error");
            db.rollback();
        }
        return res;
    }

    private void initTags(Statement st) throws SQLException {
        Map<String, ArcvalBase.DescrTagid> tmp = this.getTaglistMap(st);
        for (Rec rec : this.recs.values()) {
            ArcvalBase.DescrTagid dti = tmp.get(rec.getPathTagname());
            if (dti == null) {
                rec.idtag = this.createTaglistRec(st, rec.getPathTagname(), rec.descr);
            } else {
                rec.idtag = dti.tagid;
                if (!rec.descr.equals(dti.descr)) {
                    this.updateTaglistRec(st, rec.idtag, rec.descr);
                }
                tmp.remove(rec.getPathTagname());
            }
            rec.hasError = false;
        }
        for (String tagname : tmp.keySet()) {
            this.deleteTaglistRec(st, tmp.get((Object)tagname).tagid, tagname);
        }
    }

    @Override
    protected void setPstInsertData() throws SQLException {
        int i = 0;
        for (Rec rec : this.recs.values()) {
            if (rec.tag == null) {
                this.pstInsert.setNull(i + 1, this.ftypeSql);
            } else {
                this.setPstInsertFunc.apply(i + 1, rec.tag);
            }
            ++i;
        }
        this.pstInsert.setLong(++i, this.currec);
        this.pstInsert.setTimestamp(++i, Timestamp.valueOf(LocalDateTime.now()));
    }

    @Override
    public boolean execute() throws SQLException {
        long curms = System.currentTimeMillis();
        if (!this.hasExecTimeCome(curms)) {
            return true;
        }
        return super.execute();
    }

    @Override
    public String getInfo() {
        long nolink_cnt = this.recs.values().stream().filter(rec -> rec.tag == null).count();
        return String.format("\r\n%s: ROBO per=%d size=%d cur=%d tags=%d%s", this.arcname, this.period_ms, this.arcsize, this.currec, this.recs.size(), nolink_cnt == 0L ? "" : "/\u001b[31m" + nolink_cnt + " nolink" + "\u001b[0m");
    }

    @Override
    public String getNolinks() {
        StringBuilder sb = new StringBuilder();
        this.recs.values().stream().filter(rec -> rec.tag == null).forEach(rec -> sb.append("  " + rec.tagname + "\r\n"));
        return sb.toString();
    }

    private static class Rec {
        String tagpath;
        String tagname;
        String descr;
        Tag tag;
        int idtag;
        boolean hasError;

        private Rec() {
        }

        public String getPathTagname() {
            if (this.tagpath.isEmpty()) {
                return this.tagname;
            }
            return this.tagpath + '.' + this.tagname;
        }
    }
}

