/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.kkmansvr;

import promauto.jroboplc.core.api.ANSI;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.tags.RefGroup;
import promauto.jroboplc.core.tags.RefItem;

public class Doser {
    public static final int DOZMAN_STATUS_CODE_MASK = 127;
    public static final int DOZMAN_STATUS_STOP = 0;
    private int doserId;
    private String name;
    private String descr;
    private boolean manual;
    private boolean canControl;
    public final RefGroup refgr = EnvironmentInst.get().getRefFactory().createRefGroup();
    private RefItem refIsEmptyCur;
    private RefItem refIsEmptyTot;
    private RefItem refSetEmptyCur;
    private RefItem refSetEmptyTot;
    private RefItem refWeightReq;
    private RefItem refWeightCur;
    private RefItem refWeightTot;
    private RefItem refStable;
    private RefItem refFinished;
    private RefItem refRun;
    private RefItem refStatus;
    private RefItem refErrorFlag;

    public boolean load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.name = cm.get(conf, "name", "");
        this.descr = cm.get(conf, "descr", this.name);
        this.manual = cm.get(conf, "manual", false);
        this.canControl = cm.get(conf, "canControl", false);
        this.refgr.clear();
        this.refIsEmptyCur = this.refgr.createItem(this.name, "IsEmptyCur");
        this.refIsEmptyTot = this.refgr.createItem(this.name, "IsEmptyTot");
        this.refSetEmptyCur = this.refgr.createItem(this.name, "SetEmptyCur");
        this.refSetEmptyTot = this.refgr.createItem(this.name, "SetEmptyTot");
        this.refWeightReq = this.refgr.createItem(this.name, "WeightReq");
        this.refWeightCur = this.refgr.createItemCrc(this.name, "WeightCur");
        this.refWeightTot = this.refgr.createItemCrc(this.name, "WeightTot");
        this.refStable = this.refgr.createItemCrc(this.name, "Stable");
        this.refFinished = this.refgr.createItemCrc(this.name, "Finished");
        this.refRun = this.refgr.createItemCrc(this.name, "Run");
        this.refStatus = this.refgr.createItemCrc(this.name, "Status");
        this.refErrorFlag = this.refgr.createItemCrc(this.name, "SYSTEM.ErrorFlag");
        this.refgr.createItemCrcSum(this.name, "Crc32");
        return true;
    }

    public void init() {
        this.refgr.prepare();
    }

    public String getName() {
        return this.name;
    }

    public void setDoserId(int doserId) {
        this.doserId = doserId;
    }

    public String getDescr() {
        return this.descr;
    }

    public boolean isManual() {
        return this.manual;
    }

    public boolean isCanControl() {
        return this.canControl;
    }

    public int getWeightCur() {
        return this.refWeightCur.getValue().getInt();
    }

    public int getWeightTot() {
        return this.refWeightTot.getValue().getInt();
    }

    public boolean getStable() {
        return this.refStable.getValue().getBool();
    }

    public void setEmptyTot(boolean value) {
        this.refSetEmptyTot.getTag().setBool(value);
    }

    public boolean getIsEmptyTot() {
        return this.refIsEmptyTot.getValue().getBool();
    }

    public boolean isFinished() {
        return this.refFinished.getValue().getBool();
    }

    public void setWeightReq(int value) {
        this.refWeightReq.getTag().setInt(value);
    }

    public void setEmptyCur(boolean value) {
        this.refSetEmptyCur.getTag().setBool(value);
    }

    public void setRun(boolean value) {
        this.refRun.getTag().setBool(value);
    }

    public boolean isEmptyCur() {
        return this.refIsEmptyCur.getValue().getBool();
    }

    public boolean isStatusStop() {
        return (this.refStatus.getValue().getInt() & 0x7F) == 0;
    }

    public boolean isStable() {
        return this.refStable.getValue().getBool();
    }

    public boolean isConnected() {
        return !this.refErrorFlag.getValue().getBool();
    }

    public String getInfo() {
        String error = "";
        if (!this.refgr.link()) {
            error = "NO LINK ";
        } else if (!this.refgr.checkCrc32()) {
            error = "CRC ";
        } else if (this.refErrorFlag.getValue().getBool()) {
            error = "NOT CONNECTED ";
        }
        return String.format("  %s%s (%d) %s%s%s", ANSI.redBold(error), this.name, this.doserId, this.descr, this.manual ? ", manual" : "", this.canControl ? ", canControl" : "");
    }

    public String check() {
        return this.refgr.check();
    }
}

