/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.messenger;

import java.nio.charset.Charset;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;

public class MessengerModule
extends AbstractModule {
    private static final int BUFF_SIZE = 32768;
    private final Logger logger = LoggerFactory.getLogger(MessengerModule.class);
    private static final Charset charset = Charset.forName("UTF-8");
    protected Tag tagSubj;
    protected Tag tagText;
    protected TagRW tagSend;
    protected Tag tagSuccess;
    protected Tag tagError;
    protected Tag tagErrcnt;
    protected String host;
    protected int port;
    protected String user;
    protected String pass;
    protected String from;
    protected String to;

    public MessengerModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.tagSubj = this.tagtable.createString("subj", cm.get(conf, "subj", ""));
        this.tagText = this.tagtable.createString("text", cm.get(conf, "text", ""));
        this.tagSend = this.tagtable.createRWInt("send", 0);
        this.tagSuccess = this.tagtable.createInt("success", 0);
        this.tagError = this.tagtable.createBool("error", false);
        this.tagErrcnt = this.tagtable.createInt("errcnt", 0);
        this.port = cm.get(conf, "port", 25);
        this.user = cm.get(conf, "user", "");
        this.pass = cm.get(conf, "pass", "");
        this.host = cm.get(conf, "host", "");
        this.from = cm.get(conf, "from", "");
        this.to = cm.get(conf, "to", "");
        return true;
    }

    @Override
    public boolean prepareModule() {
        return true;
    }

    @Override
    public boolean closedownModule() {
        return true;
    }

    @Override
    public boolean executeModule() {
        if (this.tagSend.hasWriteValue()) {
            int sendval = this.tagSend.getWriteValInt();
            this.tagSend.setReadValInt(sendval);
            if (sendval > 0) {
                boolean res = this.sendEmail();
                if (res) {
                    this.tagSuccess.setInt(this.tagSuccess.getInt() + 1);
                    this.tagError.setBool(false);
                } else {
                    this.tagErrcnt.setInt(this.tagErrcnt.getInt() + 1);
                    this.tagError.setBool(true);
                }
            }
        }
        return true;
    }

    private boolean sendEmail() {
        Properties properties = System.getProperties();
        properties.put("mail.smtp.host", this.host);
        properties.put("mail.smtp.port", (Object)this.port);
        properties.put("mail.smtp.socketFactory.port", (Object)this.port);
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.ssl.enable", "true");
        properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        Session session = Session.getDefaultInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MessengerModule.this.user, MessengerModule.this.pass);
            }
        });
        try {
            String[] tos;
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.from));
            for (String s : tos = this.to.split("\\s* \\s*")) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(s));
            }
            message.setSubject(this.tagSubj.getString());
            message.setText(this.tagText.getString());
            Transport.send((Message)message);
            return true;
        }
        catch (MessagingException e) {
            this.env.printError(this.logger, e, this.name);
            return false;
        }
    }

    @Override
    protected boolean reload() {
        MessengerModule tmp = new MessengerModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.closedown();
        this.copySettingsFrom(tmp);
        this.tagSubj.copyFlagsFrom(tmp.tagSubj);
        this.tagText.copyFlagsFrom(tmp.tagText);
        this.port = tmp.port;
        this.user = tmp.user;
        this.pass = tmp.pass;
        this.host = tmp.host;
        this.from = tmp.from;
        this.to = tmp.to;
        return this.prepare();
    }
}

