/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolAA55;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;
import promauto.utils.CRC;
import promauto.utils.Numbers;

public class PaGeliosDozkkmcModule
extends PeripherialModule {
    private static final long SUM_WEIGHT_MAX = 3999999999L;
    private static final int STATE_IDLE = 1;
    private static final int STATE_WAITING_FOR_TASK = 2;
    private static final int STATE_LOADING = 4;
    private static final int STATE_UNLOADING = 8;
    private static final int STATE_ALARM = 16;
    public static final int STATUS_IDLE = 0;
    public static final int STATUS_LOAD_READY = 1;
    public static final int STATUS_LOAD = 2;
    public static final int STATUS_UNLOAD_READY = 3;
    public static final int STATUS_TASK_READY = 4;
    public static final int STATUS_ALARM = 5;
    public static final int STATUS_UNLOAD_SUSP = 6;
    public static final int STATUS_UNLOAD = 7;
    private static final int CMD_START = 0;
    private static final int CMD_TASK = 6;
    private static final int CMD_LOAD = 2;
    private static final int CMD_UNLOAD = 4;
    private static final int CMD_SUSPEND = 8;
    private static final int CMD_STOPLOAD = 10;
    private static final int PROTOCOL_VERSION_AA55_V1 = 1;
    private static final int PROTOCOL_VERSION_AA55_V2 = 2;
    private static final int PROTOCOL_VERSION_MODBUS = 3;
    private final Logger logger = LoggerFactory.getLogger(PaGeliosDozkkmcModule.class);
    protected ProtocolAA55 protocolAA55 = new ProtocolAA55(this);
    protected ProtocolModbus protocolModbus = new ProtocolModbus(this);
    private boolean multireq;
    protected StorRec[] recs;
    protected Tag tagOnlineWeight;
    protected Tag tagSumWeightMax;
    protected Tag tagSetWeightMax;
    protected Tag tagDelayUnload;
    protected Tag tagCurStor;
    protected Tag tagCurWeight;
    protected Tag tagCurPercent;
    protected Tag tagCurPercentTotal;
    protected Tag tagState;
    protected Tag tagCmdStartCycle;
    protected Tag tagCmdStartTask;
    protected Tag tagCmdStartLoad;
    protected Tag tagCmdStartUnload;
    protected Tag tagCmdSuspUnload;
    protected Tag tagCmdStopLoad;
    protected TagRW tagSendTask;
    protected TagRW tagStorQnt;
    protected Tag tagStorQntActual;
    protected Tag tagTaskMode;
    protected Tag tagStatus;
    protected Tag tagErrorCode;
    protected TagRW tagCmd;
    protected Tag tagReplacement;
    private TagRW tagFirmware;
    protected Tag tagStable;
    protected Tag tagStableTime;
    protected Tag tagStableRange;
    private long stableMs;
    private int stableWeight;
    private int[] buffout;
    private int version;
    private int storqnt;
    private int lastSendTaskEmuVal;
    private boolean success;
    private final AtomicLong timerUnload;
    private int emulateSpeedLoad;
    private int emulateSpeedUnload;
    private int emulateDelay;
    private long emulateTimer;
    private long emulateSumWeight;

    public PaGeliosDozkkmcModule(Plugin plugin, String name) {
        super(plugin, name);
        this.useSN = true;
        this.lastSendTaskEmuVal = 0;
        this.timerUnload = new AtomicLong(0L);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        int i;
        Configuration cm = this.env.getConfiguration();
        this.multireq = cm.get(conf, "multireq", false);
        this.emulateDelay = cm.get(conf, "emulateDelay", 2000);
        this.emulateSpeedLoad = cm.get(conf, "emulateSpeedLoad", 0);
        this.emulateSpeedUnload = cm.get(conf, "emulateSpeedUnload", this.emulateSpeedLoad * 3);
        this.version = cm.get(conf, "version", 2);
        this.storqnt = cm.get(conf, "storqnt", 1);
        if (this.storqnt < 1) {
            this.storqnt = 1;
        }
        this.buffout = new int[8 + 5 * this.storqnt];
        this.tagStorQnt = this.tagtable.createRWInt("StorQnt", this.storqnt);
        this.tagStorQntActual = this.tagtable.createInt("StorQntActual", 0, 8);
        this.recs = new StorRec[this.storqnt];
        int flags = 8 + (this.emulated && this.emulateSpeedLoad > 0 ? 1 : 0);
        for (i = 0; i < this.storqnt; ++i) {
            this.recs[i] = new StorRec();
            this.recs[i].tagSumWeight = this.tagtable.createLong("SumWeight" + (i + 1), 0L, flags);
            this.recs[i].tagReqWeight = this.tagtable.createLong("ReqWeight" + (i + 1), 0L, flags);
            this.recs[i].tagSetWeight = this.tagtable.createLong("SetWeight" + (i + 1), 0L, flags);
            this.recs[i].tagActive = this.tagtable.createBool("Active" + (i + 1), false, 8);
        }
        this.tagOnlineWeight = this.tagtable.createLong("OnlineWeight", 0L, 8);
        this.tagSumWeightMax = this.tagtable.createRWLong("SumWeightMax", cm.get(conf, "SumWeightMax", 3999999999L));
        this.tagSetWeightMax = this.tagtable.createInt("SetWeightMax", 0, 1);
        this.tagDelayUnload = this.tagtable.createInt("DelayUnload", 0, 1);
        this.tagCurStor = this.tagtable.createInt("CurStor", 0, flags);
        this.tagCurWeight = this.tagtable.createLong("CurWeight", 0L, 8);
        this.tagCurPercent = this.tagtable.createInt("CurPercent", 0, 8);
        this.tagCurPercentTotal = this.tagtable.createInt("CurPercentTotal", 0, 8);
        this.tagTaskMode = this.tagtable.createInt("TaskMode", 0, flags);
        this.tagStatus = this.tagtable.createInt("Status", 0, flags);
        this.tagState = this.tagtable.createInt("State", 0, flags);
        this.tagErrorCode = this.tagtable.createInt("ErrorCode", 0, 8);
        this.tagStable = this.tagtable.createBool("Stable", false, 8);
        this.tagStableTime = this.tagtable.createInt("StableTime", 0, 1);
        this.tagStableRange = this.tagtable.createInt("StableRange", 0, 1);
        this.tagCmdStartCycle = this.tagtable.createInt("CmdStartCycle", 0);
        this.tagCmdStartTask = this.tagtable.createInt("CmdStartTask", 0);
        this.tagCmdStartLoad = this.tagtable.createInt("CmdStartLoad", 0);
        this.tagCmdStartUnload = this.tagtable.createInt("CmdStartUnload", 0);
        this.tagCmdSuspUnload = this.tagtable.createInt("CmdSuspUnload", 0);
        this.tagCmdStopLoad = this.tagtable.createInt("CmdStopLoad", 0);
        this.tagCmd = this.tagtable.createRWInt("Cmd", 0);
        this.tagSendTask = this.tagtable.createRWInt("SendTask", 0);
        this.tagReplacement = this.tagtable.createBool("Replacement", false, 1);
        this.tagFirmware = this.tagtable.createRWString("firmware", "");
        this.initCrc32Tags();
        for (i = 0; i < this.storqnt; ++i) {
            this.crc32Tags.add(this.recs[i].tagSumWeight);
        }
        this.crc32Tags.add(this.tagError);
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < this.storqnt; ++i) {
            this.addChannelMapTag(chtags, this.recs[i].tagActive, "" + (i + 1));
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return this.emulate();
        }
        boolean result = true;
        try {
            boolean versionModbus = this.version == 3;
            boolean bl = result = versionModbus ? this.readStatusModbus() : this.readStatusAA55();
            if (result) {
                this.updateStable();
                this.updateActives();
                this.updateState();
            }
            boolean bl2 = result && (versionModbus ? this.readSumCountersModbus() : this.readSumCountersAA55()) ? true : (result = false);
            boolean bl3 = result && (versionModbus ? this.readTaskWeightModbus() : this.readTaskWeightAA55()) ? true : (result = false);
            if (result) {
                this.calcPercent();
            }
            if (result && this.tagSendTask.hasWriteValue()) {
                int sendtask = this.tagSendTask.getWriteValInt();
                if (sendtask <= 0) {
                    this.tagSendTask.setReadValInt(0);
                } else {
                    boolean bl4 = result = versionModbus ? this.writeTaskWeightModbus() : this.writeTaskWeightAA55();
                    if (result) {
                        this.tagSendTask.setReadValInt(this.success ? sendtask : -sendtask);
                    } else {
                        this.tagSendTask.raiseWriteValue();
                    }
                }
            }
            if (result) {
                this.processCmds();
                if (this.tagCmd.hasWriteValue()) {
                    boolean bl5 = result = versionModbus ? this.writeCmdModbus() : this.writeCmdAA55();
                    if (!result) {
                        this.tagCmd.raiseWriteValue();
                    }
                }
            }
            if (result && (this.firstPass || this.tagError.getBool())) {
                result = versionModbus ? this.requestFirmwareModbus() : this.requestFirmwareAA55();
            }
        }
        catch (Exception e) {
            result = false;
            this.env.printError(this.logger, e, this.name);
        }
        return result;
    }

    private boolean emulate() {
        if (this.tagSendTask.hasWriteValue()) {
            if (this.tagSendTask.getWriteValInt() == 0) {
                this.tagSendTask.setReadValInt(0);
            } else {
                this.tagSendTask.setReadValInt(this.lastSendTaskEmuVal);
                this.lastSendTaskEmuVal = this.tagSendTask.getWriteValInt();
                if (this.tagSendTask.getInt() == 0) {
                    this.tagSendTask.setReadValInt(this.lastSendTaskEmuVal);
                }
            }
        }
        if (this.emulateSpeedLoad <= 0) {
            this.tagCmd.acceptWriteValue();
        } else {
            this.processCmds();
            Arrays.stream(this.recs).forEach(rec -> rec.tagSetWeight.copyValueTo(rec.tagReqWeight));
            int status = this.tagStatus.getInt();
            int stor = this.tagCurStor.getInt();
            long curWeight = this.tagCurWeight.getLong();
            if (status == 0 && !this.isTimerStarted() && this.isCmd(0)) {
                this.startTimer();
            }
            if (status == 0 && this.isTimerStarted() && this.isTimerDone()) {
                status = 4;
            }
            if (status == 4 && !this.isTimerStarted() && this.isCmd(6)) {
                this.startTimer();
            }
            if (status == 4 && this.isTimerStarted() && this.isTimerDone()) {
                status = 1;
            }
            if (status == 1 && !this.isTimerStarted() && this.isCmd(2)) {
                this.startTimer();
            }
            if (status == 1 && this.isTimerStarted() && this.isTimerDone()) {
                status = 2;
                stor = 1;
                curWeight = 0L;
                this.emulateSumWeight = 0L;
            }
            if (status == 2 && !this.isTimerStarted()) {
                if (this.isCmd(10)) {
                    this.startTimer();
                    this.emulateSumWeight += curWeight;
                } else if (stor > 0 && stor <= this.recs.length) {
                    StorRec rec2 = this.recs[stor - 1];
                    if (curWeight >= rec2.tagReqWeight.getLong()) {
                        rec2.tagSumWeight.setLong(rec2.tagSumWeight.getLong() + curWeight);
                        this.emulateSumWeight += curWeight;
                        if (++stor > this.recs.length) {
                            this.startTimer();
                        } else {
                            curWeight = 0L;
                        }
                    } else {
                        curWeight += Math.round((double)this.emulateSpeedLoad * (0.8 + 0.4 * Math.random()));
                    }
                }
            }
            if (status == 2 && this.isTimerStarted() && this.isTimerDone()) {
                stor = 0;
                curWeight = this.emulateSumWeight;
                status = 3;
            }
            if (status == 3 && !this.isTimerStarted() && this.isCmd(4)) {
                this.startTimer();
            }
            if (status == 3 && this.isTimerStarted() && this.isTimerDone()) {
                status = 7;
            }
            if (status == 7) {
                if (this.isCmd(8)) {
                    status = 6;
                } else if (curWeight <= 0L) {
                    curWeight = 0L;
                    status = 0;
                } else {
                    curWeight -= Math.round((double)this.emulateSpeedUnload * (0.8 + 0.4 * Math.random()));
                }
            }
            if (status == 5 && this.isCmd(0)) {
                status = 0;
            }
            if (status == 6 && this.isCmd(4)) {
                status = 7;
            }
            this.tagStatus.setInt(status);
            this.tagCurStor.setInt(stor);
            this.tagCurWeight.setLong(curWeight);
        }
        this.calcPercent();
        this.updateActives();
        this.updateStable();
        this.updateState();
        return true;
    }

    private boolean isCmd(int cmd) {
        return this.tagCmd.hasWriteValue() && this.tagCmd.getWriteValInt() == cmd;
    }

    private boolean isTimerStarted() {
        return this.emulateTimer > 0L;
    }

    private boolean isTimerDone() {
        if (this.emulateTimer < System.currentTimeMillis()) {
            this.emulateTimer = 0L;
            return true;
        }
        return false;
    }

    private void startTimer() {
        this.emulateTimer = System.currentTimeMillis() + Math.round(Math.random() * (double)this.emulateDelay);
    }

    private void processCmds() {
        int status = this.tagStatus.getInt();
        this.processCmd(this.tagCmdStartCycle, 0, status == 0 || status == 5);
        this.processCmd(this.tagCmdStartTask, 6, status == 4);
        this.processCmd(this.tagCmdStartLoad, 2, status == 1);
        this.processCmd(this.tagCmdStopLoad, 10, status == 2);
        this.processCmdDly(this.tagCmdStartUnload, 4, status == 3 || status == 6, this.tagDelayUnload, this.timerUnload);
        this.processCmd(this.tagCmdSuspUnload, 8, status == 7);
    }

    private void updateState() {
        int status = this.tagStatus.getInt();
        this.tagState.setInt((status == 0 ? 1 : 0) + (status == 4 ? 2 : 0) + (status == 1 || status == 2 ? 4 : 0) + (status == 3 || status == 7 || status == 6 ? 8 : 0) + (status == 5 ? 16 : 0));
    }

    private void updateStable() {
        boolean res = true;
        if (this.tagStableRange.getInt() > 0) {
            if (Math.abs(this.tagCurWeight.getInt() - this.stableWeight) > this.tagStableRange.getInt()) {
                this.stableWeight = this.tagCurWeight.getInt();
                this.stableMs = System.currentTimeMillis();
                res = false;
            } else if (System.currentTimeMillis() - this.stableMs < this.tagStableTime.getLong() * 1000L) {
                res = false;
            }
        }
        this.tagStable.setBool(res);
    }

    protected boolean readStatusAA55() throws Exception {
        this.buffout[0] = 85;
        this.buffout[1] = 32 + this.netaddr;
        this.buffout[2] = 2;
        int crc = CRC.getCrc16(this.buffout, 1, 2);
        Numbers.wordToBytes(crc, this.buffout, 3);
        if (!this.protocolAA55.request(this.buffout, 5) || this.protocolAA55.bufinp[0] != this.netaddr) {
            return false;
        }
        int status = 0;
        if (this.version == 1) {
            this.tagTaskMode.setInt(Numbers.bytesToWord(this.protocolAA55.bufinp, 2));
            this.tagCurWeight.setLong(Numbers.bytesToInt(this.protocolAA55.bufinp, 4));
            status = this.protocolAA55.bufinp[13];
            this.tagStatus.setInt(status);
            this.tagErrorCode.setInt(this.protocolAA55.bufinp[14]);
            if (status == 0 || status == 5) {
                this.tagCurStor.setInt(0);
            } else {
                this.tagCurStor.setInt(1);
            }
        }
        if (this.version == 2) {
            this.tagTaskMode.setInt(Numbers.bytesToWord(this.protocolAA55.bufinp, 2));
            this.tagCurStor.setInt(this.protocolAA55.bufinp[4]);
            this.tagCurWeight.setLong(Numbers.bytesToInt(this.protocolAA55.bufinp, 6));
            status = this.protocolAA55.bufinp[17];
            this.tagStatus.setInt(status);
            this.tagErrorCode.setInt(this.protocolAA55.bufinp[18]);
        }
        return true;
    }

    protected boolean readSumCountersAA55() throws Exception {
        this.buffout[0] = 85;
        this.buffout[1] = 64 + this.netaddr;
        this.buffout[2] = 3;
        this.buffout[3] = this.storqnt;
        int crc = CRC.getCrc16(this.buffout, 1, 3);
        Numbers.wordToBytes(crc, this.buffout, 4);
        boolean res = !this.multireq ? this.protocolAA55.request(this.buffout, 6) : this.protocolAA55.multiRequest(this.buffout, 6);
        if (!res || this.protocolAA55.bufinp[0] != this.netaddr) {
            return false;
        }
        int qnt = Math.min(this.protocolAA55.bufinp[2], this.storqnt);
        int k = 4;
        long[] weights = new long[qnt];
        for (int i = 0; i < qnt; ++i) {
            weights[i] = Numbers.bytesToDWord(this.protocolAA55.bufinp, k);
            k += 5;
        }
        this.setWeights(weights);
        return true;
    }

    protected boolean readTaskWeightAA55() throws Exception {
        this.buffout[0] = 85;
        this.buffout[1] = 96 + this.netaddr;
        this.buffout[2] = 2;
        int crc = CRC.getCrc16(this.buffout, 1, 2);
        Numbers.wordToBytes(crc, this.buffout, 3);
        if (!this.protocolAA55.request(this.buffout, 5) || this.protocolAA55.bufinp[0] != this.netaddr) {
            return false;
        }
        this.tagStorQntActual.setInt(this.protocolAA55.bufinp[2]);
        int qnt = Math.min(this.tagStorQntActual.getInt(), this.storqnt);
        int k = 3;
        for (int i = 0; i < qnt; ++i) {
            this.recs[i].tagReqWeight.setLong(Numbers.bytesToDWord(this.protocolAA55.bufinp, k + 1));
            k += 5;
        }
        return true;
    }

    protected boolean writeTaskWeightAA55() throws Exception {
        this.buffout[0] = 85;
        this.buffout[1] = 160 + this.netaddr;
        this.buffout[2] = 5 + 5 * this.storqnt;
        this.buffout[3] = 0;
        this.buffout[4] = 3;
        this.buffout[5] = this.storqnt;
        int k = 6;
        for (int i = 0; i < this.storqnt; ++i) {
            this.buffout[k] = i + 1;
            Numbers.dwordToBytes(this.recs[i].tagSetWeight.getLong(), this.buffout, k + 1);
            k += 5;
        }
        int crc = CRC.getCrc16(this.buffout, 1, k - 1);
        Numbers.wordToBytes(crc, this.buffout, k);
        if (!this.protocolAA55.request(this.buffout, 8 + 5 * this.storqnt) || this.protocolAA55.bufinp[0] != this.netaddr) {
            return false;
        }
        this.success = this.protocolAA55.bufinp[2] == 0;
        return true;
    }

    protected boolean writeCmdAA55() throws Exception {
        int value;
        this.buffout[0] = 85;
        this.buffout[1] = 192 + this.netaddr;
        this.buffout[2] = 4;
        this.buffout[3] = value = this.tagCmd.getWriteValInt();
        this.buffout[4] = 0;
        int crc = CRC.getCrc16(this.buffout, 1, 4);
        Numbers.wordToBytes(crc, this.buffout, 5);
        if (!this.protocolAA55.request(this.buffout, 7) || this.protocolAA55.bufinp[0] != this.netaddr) {
            return false;
        }
        if (this.protocolAA55.bufinp[2] == 0) {
            this.tagCmd.setReadValInt(value);
        }
        return true;
    }

    protected boolean requestFirmwareAA55() throws Exception {
        return this.protocolAA55.requestFirmware(this.tagFirmware);
    }

    protected boolean readStatusModbus() throws Exception {
        if (!this.protocolModbus.requestCmd4(4097, 11)) {
            return false;
        }
        this.tagTaskMode.setInt(this.protocolModbus.getAnswerWord(0));
        this.tagCurStor.setInt(this.protocolModbus.getAnswerWord(1));
        this.tagStorQntActual.setInt(this.tagCurStor.getInt() + this.protocolModbus.getAnswerWord(2));
        this.tagCurWeight.setLong(this.protocolModbus.getAnswerInt32(3));
        this.tagStatus.setInt(this.protocolModbus.getAnswerWord(9));
        this.tagErrorCode.setInt(this.protocolModbus.getAnswerWord(10));
        return true;
    }

    protected boolean readSumCountersModbus() throws Exception {
        if (!this.protocolModbus.requestCmd4(4352, this.storqnt * 2)) {
            return false;
        }
        long[] weights = new long[this.storqnt];
        for (int i = 0; i < this.storqnt; ++i) {
            weights[i] = this.protocolModbus.getAnswerInt32(i * 2);
        }
        this.setWeights(weights);
        return true;
    }

    protected boolean readTaskWeightModbus() throws Exception {
        if (!this.protocolModbus.requestCmd3(4608, this.storqnt * 2)) {
            return false;
        }
        for (int i = 0; i < this.storqnt; ++i) {
            this.recs[i].tagReqWeight.setLong(this.protocolModbus.getAnswerInt32(i * 2));
        }
        return true;
    }

    protected boolean writeTaskWeightModbus() throws Exception {
        long[] weights = new long[this.storqnt];
        for (int i = 0; i < this.storqnt; ++i) {
            weights[i] = this.recs[i].tagSetWeight.getLong();
        }
        this.success = this.protocolModbus.requestCmd10(4608, this.storqnt, weights);
        return this.success;
    }

    protected boolean writeCmdModbus() throws Exception {
        int value = this.tagCmd.getWriteValInt();
        if (!this.protocolModbus.requestCmd6(4096, value)) {
            return false;
        }
        this.tagCmd.setReadValInt(value);
        return true;
    }

    protected boolean requestFirmwareModbus() throws Exception {
        if (!this.protocolModbus.requestCmd3(0, 20)) {
            return false;
        }
        this.tagFirmware.setReadValString(this.protocolModbus.getAnswerString(0, 10).trim());
        return true;
    }

    private void setWeights(long[] weights) {
        long onlineWeight = 0L;
        for (int i = 0; i < weights.length; ++i) {
            if (this.recs[i].onlineWeight == -1L) {
                this.recs[i].onlineWeight = 0L;
            } else if (weights[i] > this.recs[i].tagSumWeight.getLong()) {
                this.recs[i].onlineWeight += weights[i] - this.recs[i].tagSumWeight.getLong();
            }
            this.recs[i].tagSumWeight.setLong(weights[i]);
            onlineWeight += this.recs[i].onlineWeight;
        }
        this.tagOnlineWeight.setLong(onlineWeight);
        this.calcCrc32();
    }

    private void updateActives() {
        for (int i = 0; i < this.storqnt; ++i) {
            this.recs[i].tagActive.setBool(i + 1 == this.tagCurStor.getInt());
        }
    }

    private void processCmd(Tag tagCmdRequest, int value, boolean active) {
        if (tagCmdRequest.getInt() > 0) {
            if (active) {
                this.tagCmd.setInt(value);
            } else {
                tagCmdRequest.setInt(0);
            }
        }
    }

    private void processCmdDly(Tag tagCmdRequest, int value, boolean active, Tag tagDelay, AtomicLong timer) {
        if (tagDelay.getInt() > 0) {
            if (tagCmdRequest.getInt() > 0 && active) {
                if (timer.get() == 0L) {
                    timer.set(System.currentTimeMillis() + tagDelay.getLong() * 1000L);
                } else if (timer.get() <= System.currentTimeMillis()) {
                    this.tagCmd.setInt(value);
                }
            } else {
                tagCmdRequest.setInt(0);
                timer.set(0L);
            }
        } else {
            this.processCmd(tagCmdRequest, value, active);
        }
    }

    private void calcPercent() {
        int curStor = this.tagCurStor.getInt();
        long curWeight = this.tagCurWeight.getLong();
        long reqWeight = 0L;
        long curWeightTotal = curStor == 0 ? curWeight : 0L;
        long reqWeightTotal = 0L;
        for (int i = 0; i < this.recs.length; ++i) {
            long w = this.recs[i].tagReqWeight.getLong();
            reqWeightTotal += w;
            if (curStor <= 0) continue;
            int cmp = i + 1 - curStor;
            if (cmp < 0) {
                curWeightTotal += w;
                continue;
            }
            if (cmp != 0) continue;
            reqWeight = w;
            curWeightTotal += curWeight;
        }
        int percent = reqWeight > 0L ? (int)(curWeight * 100L / reqWeight) : 0;
        this.tagCurPercent.setInt(Numbers.limit(percent, 0, 100));
        percent = reqWeightTotal > 0L ? (int)(curWeightTotal * 100L / reqWeightTotal) : 0;
        this.tagCurPercentTotal.setInt(Numbers.limit(percent, 0, 100));
    }

    @Override
    protected boolean reload() {
        PaGeliosDozkkmcModule tmp = new PaGeliosDozkkmcModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        if (tmp.storqnt < this.storqnt) {
            for (int i = tmp.storqnt; i < this.storqnt; ++i) {
                this.tagtable.remove(this.recs[i].tagSumWeight);
                this.tagtable.remove(this.recs[i].tagReqWeight);
                this.tagtable.remove(this.recs[i].tagSetWeight);
            }
            this.recs = Arrays.copyOf(this.recs, tmp.storqnt);
        } else if (tmp.storqnt > this.storqnt) {
            this.recs = Arrays.copyOf(this.recs, tmp.storqnt);
            for (int i = this.storqnt; i < tmp.storqnt; ++i) {
                this.recs[i] = tmp.recs[i];
                this.tagtable.add(this.recs[i].tagSumWeight);
                this.tagtable.add(this.recs[i].tagReqWeight);
                this.tagtable.add(this.recs[i].tagSetWeight);
            }
        }
        this.version = tmp.version;
        this.storqnt = tmp.storqnt;
        this.buffout = tmp.buffout;
        this.multireq = tmp.multireq;
        this.tagStorQnt.setReadValInt(this.storqnt);
        this.updateTagsStatus();
        return true;
    }

    private static class StorRec {
        protected Tag tagSumWeight;
        protected Tag tagReqWeight;
        protected Tag tagSetWeight;
        protected Tag tagActive;
        protected long onlineWeight = -1L;

        private StorRec() {
        }
    }
}

