/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.ANSI;
import promauto.jroboplc.core.tags.RefGroup;
import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.raduga.Context;
import promauto.jroboplc.plugin.raduga.Line;

public class CtlDoser {
    private final Logger logger = LoggerFactory.getLogger(CtlDoser.class);
    public static final String ERROR_NONE = "";
    public static final String ERROR_NOT_LINKED = "NOT LINKED";
    public static final String ERROR_NOT_CONNECTED = "NOT CONNECTED";
    private final Context ctx;
    public final Line line;
    protected final String doserModuleName;
    protected TagRW tagCurWeight;
    protected TagRW tagStable;
    protected TagRW tagConnected;
    protected TagRW tagError;
    protected RefItem refSetWeight1;
    protected RefItem refCurWeight;
    protected RefItem refStable;
    protected RefItem refStatus;
    protected RefItem refErrorFlag;
    protected RefItem refSendTask;
    protected RefItem refCmdStartCycle;
    protected RefItem refCmdStartTask;
    protected RefItem refCmdStartLoad;
    protected RefItem refCmdStopLoad;
    protected RefItem refCmdStartUnload;
    public final RefGroup refgr;

    public CtlDoser(Context ctx, Line line, String doserModuleName) {
        this.ctx = ctx;
        this.line = line;
        this.doserModuleName = doserModuleName;
        this.refgr = ctx.env.getRefFactory().createRefGroup();
    }

    public boolean load() {
        boolean res = true;
        TagTable tt = this.ctx.tagtable;
        this.tagConnected = tt.createRWBool(this.makeTagName("Connected"), false);
        this.tagError = tt.createRWString(this.makeTagName("Error"), ERROR_NONE);
        this.tagCurWeight = tt.createRWLong(this.makeTagName("CurWeight"), 0L);
        this.tagStable = tt.createRWBool(this.makeTagName("Stable"), false);
        this.refSetWeight1 = this.refgr.createItem(this.doserModuleName, "SetWeight1");
        this.refCurWeight = this.refgr.createItem(this.doserModuleName, "CurWeight");
        this.refStable = this.refgr.createItem(this.doserModuleName, "Stable");
        this.refStatus = this.refgr.createItem(this.doserModuleName, "Status");
        this.refSendTask = this.refgr.createItem(this.doserModuleName, "SendTask");
        this.refCmdStartCycle = this.refgr.createItem(this.doserModuleName, "CmdStartCycle");
        this.refCmdStartTask = this.refgr.createItem(this.doserModuleName, "CmdStartTask");
        this.refCmdStartLoad = this.refgr.createItem(this.doserModuleName, "CmdStartLoad");
        this.refCmdStopLoad = this.refgr.createItem(this.doserModuleName, "CmdStopLoad");
        this.refCmdStartUnload = this.refgr.createItem(this.doserModuleName, "CmdStartUnload");
        this.refErrorFlag = this.refgr.createItem(this.doserModuleName, "SYSTEM.ErrorFlag");
        return res;
    }

    public String makeTagName(String tagname) {
        return this.line.makeTagName("DC_" + tagname);
    }

    public void prepare() {
        this.refgr.prepare();
    }

    public void execute() throws SQLException {
        String error = ERROR_NONE;
        boolean connected = false;
        if (!this.refgr.linkAndRead()) {
            error = ERROR_NOT_LINKED;
        } else if (this.refErrorFlag.getTag().getBool()) {
            error = ERROR_NOT_CONNECTED;
        } else {
            connected = true;
            this.refSetWeight1.getTag().setLong(2000000L);
            this.updateTags();
        }
        this.tagConnected.setReadValBool(connected);
        this.tagError.setReadValString(error);
    }

    private void updateTags() {
        this.tagCurWeight.setReadValLong(this.refCurWeight.getValue().getLong());
        this.tagStable.setReadValBool(this.refStable.getValue().getBool());
    }

    private boolean isState(int state) {
        return this.refStatus.getValue().getInt() == state;
    }

    public void prepareTaskSend() {
        if (this.tagConnected.getBool() && !this.isState(5)) {
            this.refCmdStartCycle.getTag().setInt(1);
            this.refSendTask.getTag().setInt(0);
        }
    }

    public boolean isTaskSendReady() {
        return this.tagConnected.getBool() && this.refSendTask.getValue().getInt() == 0 && this.isState(4);
    }

    public void sendTask() {
        if (this.tagConnected.getBool()) {
            this.refSendTask.getTag().setInt(1);
        }
    }

    public boolean isTaskAccepted() {
        return this.tagConnected.getBool() && this.refSendTask.getValue().getInt() > 0;
    }

    public boolean isTaskRejected() {
        return this.tagConnected.getBool() && this.refSendTask.getValue().getInt() < 0;
    }

    public boolean isLoading() {
        return this.tagConnected.getBool() && this.isState(2);
    }

    public boolean isUnloadReady() {
        return this.tagConnected.getBool() && this.isState(3);
    }

    public void startLoad() {
        if (this.tagConnected.getBool()) {
            this.refCmdStartTask.getTag().setInt(1);
            this.refCmdStartLoad.getTag().setInt(1);
        }
    }

    public void stopLoad() {
        if (this.tagConnected.getBool()) {
            this.refCmdStopLoad.getTag().setInt(1);
        }
    }

    public boolean isUnloaded() {
        return this.tagConnected.getBool() && this.isState(0);
    }

    public void startUnload() {
        if (this.tagConnected.getBool()) {
            this.refCmdStartUnload.getTag().setInt(1);
        }
    }

    public boolean isStable() {
        return this.tagConnected.getBool() && this.refStable.getValue().getBool();
    }

    public String check() {
        return this.refgr.checkln();
    }

    public String getInfo() {
        return String.format("\r\n\r        CtlDoser %s %s", ANSI.yellow(this.doserModuleName), ANSI.redBold(this.tagError.getString()));
    }
}

