/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.raduga.Context;
import promauto.jroboplc.plugin.raduga.CtlDoser;
import promauto.jroboplc.plugin.raduga.Doser;
import promauto.jroboplc.plugin.raduga.LineSimple;

public class LineCombo
extends LineSimple {
    private final Logger logger = LoggerFactory.getLogger(LineCombo.class);
    protected static final int STATE_HOLD_DOSERS = 8;
    protected static final int STATE_PREPARING_C = 9;
    protected static final int STATE_SETTING_C = 10;
    protected static final int STATE_START_LOAD_C = 11;
    protected static final int STATE_PREPARING_P = 12;
    protected static final int STATE_SETTING_P = 13;
    protected static final int STATE_CAN_LOAD_P = 14;
    protected static final int STATE_LOADING_P = 15;
    protected static final int STATE_HOLD_TRANSPORT = 16;
    protected static final int STATE_UNLOADING_P = 17;
    protected static final int STATE_DELAY_TRANSPORT_P = 18;
    protected static final int STATE_WAIT_CRUSHER_EMPTY = 19;
    protected static final int STATE_LOADING_C = 20;
    protected static final int STATE_STOP_LOAD_C = 21;
    protected static final int STATE_PREPARING_M = 22;
    protected static final int STATE_SETTING_M = 23;
    protected static final int STATE_CAN_LOAD_M = 24;
    protected static final int STATE_LOADING_M = 25;
    protected static final int STATE_WAIT_MIXER_READY = 26;
    protected static final int STATE_MIXER_START = 27;
    protected static final int STATE_UNLOADING_C_M = 28;
    protected static final int STATE_DELAY_AFTER_UNLOAD_C_M = 29;
    protected static final int STATE_MIXER_LOADED = 30;
    protected static final String ERROR_CONFLICT_HOLD_DOSERS = "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u041e\u041a";
    protected static final String ERROR_CONFLICT_HOLD_TRANSPORT = "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u041e\u041a";
    protected static final String ERROR_DOSER_REJECTED_TASK_C = "\u0414\u043e\u0437\u0430\u0442\u043e\u0440 \u043d\u0435 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u0442 \u0437\u0430\u0434\u0430\u0447\u0443 (\u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0439)";
    protected static final String ERROR_DOSER_REJECTED_TASK_P = "\u0414\u043e\u0437\u0430\u0442\u043e\u0440 \u043d\u0435 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u0442 \u0437\u0430\u0434\u0430\u0447\u0443 (\u041e\u041a)";
    protected static final String ERROR_DOSER_REJECTED_TASK_M = "\u0414\u043e\u0437\u0430\u0442\u043e\u0440 \u043d\u0435 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u0442 \u0437\u0430\u0434\u0430\u0447\u0443 (\u041c\u041a)";
    protected TagRW tagHoldDosers;
    protected TagRW tagHoldTransport;
    protected TagRW tagRcpWeightP;
    protected TagRW tagSetWeightP;
    protected TagRW tagExeWeightP;
    protected TagRW tagExeWeightC;
    protected TagRW tagRcpWeightM;
    protected TagRW tagSetWeightM;
    protected TagRW tagExeWeightM;
    protected TagRW tagSetWeightPM;
    protected TagRW tagTimeCnt;
    protected Tag tagTimeTransportP;
    protected Tag tagTimeAfterUnloadCM;
    protected Tag tagUnderweightLimitC;
    protected Tag tagInpCrusherEmpty;
    protected TagRW tagCmdMixerStart;
    protected Tag tagInpMixerLoadReady;
    protected TagRW tagCmdMixerLoaded;
    protected Tag tagInpMixerBusy;
    protected Tag tagEnableLoadP;
    protected Tag tagEnableUnloadP;
    protected Tag tagEnableLoadM;
    protected Tag tagEnableUnloadM;
    protected final List<Doser> dosersP = new ArrayList<Doser>();
    protected final List<Doser> dosersM = new ArrayList<Doser>();
    protected CtlDoser ctlDoser;
    protected long timeHoldCatching;

    protected LineCombo(Context ctx) {
        super(ctx);
    }

    @Override
    public boolean load(Object conf) {
        boolean res = super.load(conf);
        Configuration cm = this.ctx.env.getConfiguration();
        String ctlDoserModule = cm.get(conf, "ctlDoserModule", "");
        if (!this.validatePresented("ctlDoserModule", ctlDoserModule)) {
            return false;
        }
        this.ctlDoser = new CtlDoser(this.ctx, this, ctlDoserModule);
        res &= this.ctlDoser.load();
        this.dosersP.addAll(this.dosers);
        for (Object confDoser : cm.toList(cm.get(conf, "microDosers"))) {
            Doser doser = new Doser(this.ctx, this, this.dosers.size() + 1);
            res &= doser.load(confDoser);
            this.dosers.add(doser);
            this.dosersM.add(doser);
        }
        TagTable tt = this.ctx.tagtable;
        Tag[] tagArray = new Tag[7];
        this.tagHoldDosers = tt.createRWInt(this.makeTagName("HoldDosers"), 0);
        tagArray[0] = this.tagHoldDosers;
        this.tagHoldTransport = tt.createRWInt(this.makeTagName("HoldTransport"), 0);
        tagArray[1] = this.tagHoldTransport;
        this.tagExeWeightC = tt.createRWLong(this.makeTagName("ExeWeightC"), 0L);
        tagArray[2] = this.tagExeWeightC;
        this.tagTimeCnt = tt.createRWInt(this.makeTagName("TimeCnt"), 0);
        tagArray[3] = this.tagTimeCnt;
        this.tagSetWeightP = tt.createRWLong(this.makeTagName("SetWeightP"), 0L);
        tagArray[4] = this.tagSetWeightP;
        this.tagSetWeightM = tt.createRWLong(this.makeTagName("SetWeightM"), 0L);
        tagArray[5] = this.tagSetWeightM;
        this.tagSetWeightPM = tt.createRWLong(this.makeTagName("SetWeightPM"), 0L);
        tagArray[6] = this.tagSetWeightPM;
        this.ctx.addRepoTags(tagArray);
        this.tagRcpWeightP = tt.createRWLong(this.makeTagName("RcpWeightP"), 0L);
        this.tagExeWeightP = tt.createRWLong(this.makeTagName("ExeWeightP"), 0L);
        this.tagRcpWeightM = tt.createRWLong(this.makeTagName("RcpWeightM"), 0L);
        this.tagExeWeightM = tt.createRWLong(this.makeTagName("ExeWeightM"), 0L);
        this.tagTimeTransportP = tt.createInt(this.makeTagName("TimeTransportP"), 0, 1);
        this.tagTimeAfterUnloadCM = tt.createInt(this.makeTagName("TimeAfterUnloadCM"), 0, 1);
        this.tagUnderweightLimitC = tt.createLong(this.makeTagName("UnderweightLimitC"), 0L, 1);
        this.tagInpCrusherEmpty = tt.createBool(this.makeTagName("InpCrusherEmpty"), false);
        this.tagCmdMixerStart = tt.createRWBool(this.makeTagName("CmdMixerStart"), false);
        this.tagInpMixerLoadReady = tt.createBool(this.makeTagName("InpMixerLoadReady"), false);
        this.tagCmdMixerLoaded = tt.createRWBool(this.makeTagName("CmdMixerLoaded"), false);
        this.tagInpMixerBusy = tt.createBool(this.makeTagName("InpMixerBusy"), false);
        this.tagEnableLoadP = tt.createBool(this.makeTagName("EnableLoadP"), false);
        this.tagEnableUnloadP = tt.createBool(this.makeTagName("EnableUnloadP"), false);
        this.tagEnableLoadM = tt.createBool(this.makeTagName("EnableLoadM"), false);
        this.tagEnableUnloadM = tt.createBool(this.makeTagName("EnableUnloadM"), false);
        return res;
    }

    @Override
    public boolean prepare() {
        this.ctlDoser.prepare();
        return super.prepare();
    }

    @Override
    public void execute() throws SQLException {
        this.updateDstBunker();
        this.executeDosers();
        this.ctlDoser.execute();
        this.updateTags();
        this.updateCancelReset(15);
        int state = this.tagState.getInt();
        if (this.tagTaskId.hasWriteValue() && state == 0) {
            state = this.installTask(this.tagTaskId.getWriteValInt()) ? 1 : 99;
        }
        if (state == 1) {
            this.updateSetWeight();
            if (this.isTaskTotalCompleted()) {
                this.saveTaskDtFinish();
                state = 101;
            } else if (this.tagStart.getBool() && this.tagSetWeight.getLong() > 0L) {
                state = 8;
            }
        }
        if (state == 8 && this.canHoldDosers()) {
            state = 9;
            this.startHoldCatching();
            this.generateCycleId();
            this.resetCycle();
        }
        if (state == 9) {
            this.ctlDoser.prepareTaskSend();
            if (this.ctlDoser.isTaskSendReady()) {
                this.ctlDoser.sendTask();
                state = 10;
            }
        }
        if (state == 10) {
            if (this.ctlDoser.isTaskAccepted()) {
                state = 11;
            } else if (this.ctlDoser.isTaskRejected()) {
                state = 99;
                this.setError(ERROR_DOSER_REJECTED_TASK_C);
            }
        }
        if (state == 11) {
            if (this.ctlDoser.isLoading()) {
                state = 12;
            } else {
                this.ctlDoser.startLoad();
            }
        }
        if (state == 12) {
            LineCombo.prepareTaskSend(this.dosersP);
            if (LineCombo.isTaskSendReady(this.dosersP)) {
                LineCombo.sendTask(this.dosersP);
                state = 13;
            }
        }
        if (state == 13) {
            if (LineCombo.isTaskAccepted(this.dosersP)) {
                state = 14;
            } else if (LineCombo.isTaskRejected(this.dosersP)) {
                state = 99;
                this.setError(ERROR_DOSER_REJECTED_TASK_P);
            }
        }
        if (state == 14 && this.canLoadP()) {
            state = 15;
        }
        if (state == 15) {
            if (LineCombo.isUnloadReady(this.dosersP)) {
                state = 16;
                this.startHoldCatching();
            } else {
                LineCombo.startLoad(this.dosersP);
            }
        }
        if (state == 16 && this.canHoldTransport()) {
            this.tagHoldTransport.setReadValInt(1);
            state = 17;
        }
        if (state == 17) {
            if (LineCombo.isUnloaded(this.dosersP)) {
                LineCombo.incrementPassCnt(this.dosersP);
                if (LineCombo.needMorePasses(this.dosersP)) {
                    state = 12;
                } else {
                    state = 18;
                    this.tagTimeCnt.setReadValInt(this.tagTimeTransportP.getInt());
                }
            } else if (this.canUnloadP()) {
                LineCombo.startUnload(this.dosersP);
            }
        }
        if (state == 18) {
            if (this.tagTimeCnt.getInt() <= 0) {
                state = 19;
            } else {
                this.tagTimeCnt.setReadValInt(this.tagTimeCnt.getInt() - 1);
            }
        }
        if (state == 19 && this.tagInpCrusherEmpty.getBool()) {
            state = 20;
        }
        if (state == 20 && this.ctlDoser.isStable() && this.tagExeWeightP.getLong() - this.ctlDoser.tagCurWeight.getLong() <= this.tagUnderweightLimitC.getLong()) {
            state = 21;
        }
        if (state == 21) {
            if (this.ctlDoser.isStable() && this.ctlDoser.isUnloadReady()) {
                this.tagExeWeightC.setReadValLong(this.ctlDoser.tagCurWeight.getLong());
                this.saveExeWeightC();
                this.updateSetWeightM();
                state = 22;
            } else {
                this.ctlDoser.stopLoad();
            }
        }
        if (state == 22) {
            LineCombo.prepareTaskSend(this.dosersM);
            if (LineCombo.isTaskSendReady(this.dosersM)) {
                LineCombo.sendTask(this.dosersM);
                state = 23;
            }
        }
        if (state == 23) {
            if (LineCombo.isTaskAccepted(this.dosersM)) {
                state = 24;
            } else if (LineCombo.isTaskRejected(this.dosersM)) {
                state = 99;
                this.setError(ERROR_DOSER_REJECTED_TASK_M);
            }
        }
        if (state == 24 && this.canLoadM()) {
            state = 25;
        }
        if (state == 25) {
            if (LineCombo.isUnloadReady(this.dosersM)) {
                state = 26;
            } else {
                LineCombo.startLoad(this.dosersM);
            }
        }
        if (state == 26 && !this.tagInpMixerBusy.getBool()) {
            state = 27;
        }
        if (state == 27 && this.tagInpMixerLoadReady.getBool()) {
            state = 28;
        }
        if (state == 28) {
            if (this.ctlDoser.isUnloaded() && LineCombo.isUnloaded(this.dosersM)) {
                state = 29;
                this.tagTimeCnt.setReadValInt(this.tagTimeAfterUnloadCM.getInt());
            } else if (this.canUnloadM()) {
                this.ctlDoser.startUnload();
                LineCombo.startUnload(this.dosersM);
            }
        }
        if (state == 29) {
            if (this.tagTimeCnt.getInt() <= 0) {
                state = 30;
            } else {
                this.tagTimeCnt.setReadValInt(this.tagTimeCnt.getInt() - 1);
            }
        }
        if (state == 30) {
            if (this.tagInpMixerBusy.getBool()) {
                state = 100;
            }
        } else if (state == 100) {
            state = 1;
            this.resetExeWeight();
            if (!this.autostart) {
                this.tagStart.setOff();
            }
        }
        this.tagHoldDosers.setReadValBool(state > 8 && state <= 17);
        if (this.tagHoldDosers.getBool() && this.isTooManyHoldDosers()) {
            this.tagHoldDosers.setReadValBool(false);
            this.setError(ERROR_CONFLICT_HOLD_DOSERS);
            state = 99;
        }
        if (!this.tagHoldDosers.getBool() || !this.tagHoldTransport.getBool()) {
            this.tagHoldTransport.setReadValBool(state > 16 && state <= 18);
        }
        if (this.tagHoldTransport.getBool() && this.isTooManyHoldTransport()) {
            this.tagHoldTransport.setReadValBool(false);
            this.setError(ERROR_CONFLICT_HOLD_TRANSPORT);
            state = 99;
        }
        this.tagCmdMixerStart.setReadValBool(state >= 27 && state <= 30);
        this.tagCmdMixerLoaded.setReadValBool(state == 30);
        this.setState(state);
    }

    private boolean canLoadP() {
        return this.canLoad() && this.tagEnableLoadP.getBool();
    }

    private boolean canUnloadP() {
        return this.canUnload() && this.tagEnableUnloadP.getBool();
    }

    private boolean canLoadM() {
        return this.canLoad() && this.tagEnableLoadM.getBool();
    }

    private boolean canUnloadM() {
        return this.canUnload() && this.tagEnableUnloadM.getBool();
    }

    private void saveExeWeightC() throws SQLException {
        this.ctx.service.saveTaskCtl(this.tagTaskId.getInt(), this.tagCycleId.getInt(), this.ctx.now(), this.tagExeWeightC.getLong());
    }

    @Override
    protected void reset() {
        super.reset();
        this.tagHoldDosers.setReadValInt(0);
        this.tagHoldTransport.setReadValInt(0);
        this.tagRcpWeightP.setReadValLong(0L);
        this.tagSetWeightP.setReadValLong(0L);
        this.tagExeWeightP.setReadValLong(0L);
        this.tagExeWeightC.setReadValLong(0L);
        this.tagRcpWeightM.setReadValLong(0L);
        this.tagSetWeightM.setReadValLong(0L);
        this.tagExeWeightM.setReadValLong(0L);
        this.tagSetWeightPM.setReadValLong(0L);
        this.tagTimeCnt.setReadValInt(0);
        this.tagCmdMixerStart.setReadValBool(false);
        this.tagCmdMixerLoaded.setReadValBool(false);
    }

    @Override
    protected void updateTags() throws SQLException {
        super.updateTags();
        LineCombo.updateSumTags(this.dosersP, this.tagRcpWeightP, this.tagExeWeightP);
        LineCombo.updateSumTags(this.dosersM, this.tagRcpWeightM, this.tagExeWeightM);
    }

    private void updateSetWeight() {
        LineCombo.updateSetWeight(this.dosers, this.tagSetWeight.getLong());
        this.tagSetWeightP.setReadValLong(this.dosersP.stream().mapToLong(Doser::getSetWeight).sum());
        this.tagSetWeightM.setReadValLong(this.dosersM.stream().mapToLong(Doser::getSetWeight).sum());
        this.tagSetWeightPM.setReadValLong(this.tagSetWeightP.getLong() + this.tagSetWeightM.getLong());
    }

    private void updateSetWeightM() {
        double ratio = this.tagRcpWeightP.getLong() == 0L ? 0.0 : this.tagExeWeightC.getDouble() / this.tagRcpWeightP.getDouble();
        this.tagSetWeightM.setReadValLong(Math.round(this.tagRcpWeightM.getDouble() * ratio));
        LineCombo.updateSetWeight(this.dosersM, this.tagSetWeightM.getLong());
        this.tagSetWeightPM.setReadValLong(this.tagSetWeightP.getLong() + this.tagSetWeightM.getLong());
    }

    @Override
    protected boolean installTask(int taskId) throws SQLException {
        boolean res = super.installTask(taskId);
        this.updateSetWeight();
        return res;
    }

    private long countHold(Function<LineCombo, Tag> funcTagHold) {
        return this.ctx.lines.stream().filter(line -> line instanceof LineCombo).filter(line -> ((Tag)funcTagHold.apply((LineCombo)line)).getBool()).count();
    }

    private boolean isTooManyHoldDosers() {
        return this.countHold(line -> line.tagHoldDosers) > 1L;
    }

    private boolean isTooManyHoldTransport() {
        return this.countHold(line -> line.tagHoldTransport) > 1L;
    }

    private boolean canHold(int stateHold, Function<LineCombo, Tag> funcTagHold) {
        return this.ctx.lines.stream().filter(line -> line != this).filter(line -> line instanceof LineCombo).map(line -> (LineCombo)line).noneMatch(line -> ((Tag)funcTagHold.apply((LineCombo)line)).getInt() > 0 || line.tagState.getInt() == stateHold && line.getTimeHoldCatching() < this.timeHoldCatching);
    }

    private boolean canHoldDosers() {
        return this.canHold(8, line -> line.tagHoldDosers);
    }

    private boolean canHoldTransport() {
        return this.canHold(16, line -> line.tagHoldTransport);
    }

    private void startHoldCatching() {
        this.timeHoldCatching = System.currentTimeMillis();
    }

    private void executeDosers() throws SQLException {
        for (Doser doser : this.dosersP) {
            doser.execute(this.tagHoldDosers.getInt() == 0);
        }
        for (Doser doser : this.dosersM) {
            doser.execute();
        }
    }

    @Override
    protected void resetExeWeight() {
        super.resetExeWeight();
        this.tagExeWeightP.setReadValInt(0);
        this.tagExeWeightM.setReadValInt(0);
        this.tagExeWeightC.setReadValInt(0);
    }

    @Override
    protected String getLineType() {
        return "combo";
    }

    public long getTimeHoldCatching() {
        return this.timeHoldCatching;
    }

    static {
        STATES.put(8, "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u0434\u0440\u0443\u0433\u043e\u0439 \u043b\u0438\u043d\u0438\u0435\u0439");
        STATES.put(9, "\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u043a \u0441\u0442\u0430\u0440\u0442\u0443 \u0446\u0438\u043a\u043b\u0430");
        STATES.put(10, "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u0443 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f");
        STATES.put(11, "\u0421\u0442\u0430\u0440\u0442 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f");
        STATES.put(12, "\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u041e\u041a \u043a \u0441\u0442\u0430\u0440\u0442\u0443 \u0446\u0438\u043a\u043b\u0430");
        STATES.put(13, "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u0430\u043c \u041e\u041a");
        STATES.put(14, "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0432\u043d\u0435\u0448\u043d\u0435\u0433\u043e \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u041e\u041a");
        STATES.put(15, "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u041e\u041a");
        STATES.put(16, "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u041e\u041a \u0434\u0440\u0443\u0433\u043e\u0439 \u043b\u0438\u043d\u0438\u0435\u0439");
        STATES.put(17, "\u0420\u0430\u0437\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u041e\u041a");
        STATES.put(18, "\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0434\u043b\u044f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u041e\u041a");
        STATES.put(19, "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u043f\u0443\u0441\u0442\u043e\u0448\u0435\u043d\u0438\u044f \u0434\u0440\u043e\u0431\u0438\u043b\u043a\u0438");
        STATES.put(24, "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0432\u043d\u0435\u0448\u043d\u0435\u0433\u043e \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u041c\u041a");
        STATES.put(20, "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f (\u043d\u0430\u0431\u043e\u0440 \u043c\u0438\u043d.\u0432\u0435\u0441, \u0441\u0442\u0430\u0431.\u0432\u0435\u0441)");
        STATES.put(21, "\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f");
        STATES.put(22, "\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u041c\u041a \u043a \u0441\u0442\u0430\u0440\u0442\u0443 \u0446\u0438\u043a\u043b\u0430");
        STATES.put(23, "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u0430\u043c \u041c\u041a");
        STATES.put(25, "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u041c\u041a");
        STATES.put(26, "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0433\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u0438 \u0441\u043c\u0435\u0441\u0438\u0442\u0435\u043b\u044f \u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435");
        STATES.put(27, "\u0417\u0430\u043f\u0443\u0441\u043a \u0441\u043c\u0435\u0441\u0438\u0442\u0435\u043b\u044f \u0438 \u0448\u043d\u0435\u043a\u043e\u0432 \u0440\u0430\u0437\u0433\u0440\u0443\u0437\u043a\u0438 \u0432 \u0441\u043c\u0435\u0441\u0438\u0442\u0435\u043b\u044c");
        STATES.put(28, "\u0420\u0430\u0437\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u0432 \u0441\u043c\u0435\u0441\u0438\u0442\u0435\u043b\u044c");
        STATES.put(29, "\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043f\u043e\u0441\u043b\u0435 \u0440\u0430\u0437\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u043e\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u0432 \u0441\u043c\u0435\u0441\u0438\u0442\u0435\u043b\u044c");
        STATES.put(30, "\u0417\u0430\u043f\u0443\u0441\u043a \u0446\u0438\u043a\u043b\u0430 \u0441\u043c\u0435\u0448\u0438\u0432\u0430\u043d\u0438\u044f");
    }
}

