/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;

public class Periods {
    private final List<Integer> shifts = new ArrayList<Integer>();

    public void load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.shifts.clear();
        this.shifts.addAll(cm.toList(cm.get(conf, "shifts")).stream().map(val -> (Integer)val).collect(Collectors.toList()));
    }

    public int calcPeriodShift(LocalDateTime dt) {
        int j;
        int hhmm = dt.getHour() * 100 + dt.getMinute();
        int i = this.shifts.size();
        for (j = 0; j < this.shifts.size() && hhmm >= this.shifts.get(j); ++j) {
            i = j + 1;
        }
        if (j < i) {
            dt = dt.minusDays(1L);
        }
        return dt.getYear() * 100000 + dt.getMonthValue() * 1000 + dt.getDayOfMonth() * 10 + i;
    }

    public int calcPeriodHour(LocalDateTime dt) {
        return dt.getYear() * 1000000 + dt.getMonthValue() * 10000 + dt.getDayOfMonth() * 100 + dt.getHour();
    }
}

