/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceSCLA
extends Device {
    Input inpValue;
    Tag tagValue;
    Tag tagPrimeval;
    Tag tagPercent;
    Tag tagMax;
    Tag tagMin;
    Tag tagPointV1;
    Tag tagPointP1;
    Tag tagPointV2;
    Tag tagPointP2;
    Tag tagSPmax;
    Tag tagSPmin;
    Tag tagBlok;
    Tag tagBlokValue;
    Tag tagDlyMax;
    Tag tagDlyMin;
    int cntmax;
    int cntmin;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpValue = this.getInput("Value", res);
        this.tagValue = this.getOutputTag("Value", res);
        this.tagPrimeval = this.getOutputTag("Primeval", res);
        this.tagPercent = this.getOutputTag("Percent", res);
        this.tagMax = this.getOutputTag("Max", res);
        this.tagMin = this.getOutputTag("Min", res);
        this.tagPointV1 = this.getOutputTag("PointV1", res);
        this.tagPointP1 = this.getOutputTag("PointP1", res);
        this.tagPointV2 = this.getOutputTag("PointV2", res);
        this.tagPointP2 = this.getOutputTag("PointP2", res);
        this.tagSPmax = this.getOutputTag("SPmax", res);
        this.tagSPmin = this.getOutputTag("SPmin", res);
        this.tagBlok = this.getOutputTag("Blok", res);
        this.tagBlokValue = this.getOutputTag("BlokValue", res);
        this.tagDlyMax = this.getOutputTag("DlyMax", res);
        this.tagDlyMin = this.getOutputTag("DlyMin", res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagValue.setInt(0);
        this.tagPrimeval.setInt(0);
        this.tagPercent.setInt(0);
        this.tagMax.setInt(0);
        this.tagMin.setInt(0);
        this.cntmax = 0;
        this.cntmin = 0;
    }

    @Override
    public boolean execute() {
        float r;
        int tmpVal = 0;
        if (this.tagBlok.getInt() == 2) {
            this.tagPrimeval.setInt(this.tagBlokValue.getInt());
        } else {
            this.tagPrimeval.setInt(this.inpValue.getInt());
        }
        float r1 = this.tagPointP2.getInt() - this.tagPointP1.getInt();
        float r2 = this.tagPrimeval.getInt() - this.tagPointP1.getInt();
        float r3 = this.tagPointV2.getInt() - this.tagPointV1.getInt();
        if (this.tagBlok.getInt() == 1) {
            tmpVal = this.tagBlokValue.getInt();
            r = tmpVal;
        } else if (r1 == 0.0f) {
            tmpVal = 0;
            r = 0.0f;
        } else {
            r = r2 / r1;
            if ((r = r * r3 + (float)this.tagPointV1.getInt()) < 0.0f) {
                tmpVal = 0;
                r = 0.0f;
            } else {
                tmpVal = Math.round(r);
            }
        }
        int spmax = this.tagSPmax.getInt();
        int spmin = this.tagSPmin.getInt();
        if (tmpVal >= spmax) {
            if (this.cntmax < this.tagDlyMax.getInt()) {
                ++this.cntmax;
            } else {
                this.tagMax.setInt(1);
            }
            tmpVal = spmax;
        } else {
            this.tagMax.setInt(0);
            this.cntmax = 0;
        }
        if (tmpVal <= spmin) {
            if (this.cntmin < this.tagDlyMin.getInt()) {
                ++this.cntmin;
            } else {
                this.tagMin.setInt(1);
            }
            tmpVal = spmin;
        } else {
            this.tagMin.setInt(0);
            this.cntmin = 0;
        }
        if (spmax - spmin > 0) {
            r = tmpVal;
            if ((r = (r - (float)spmin) * 100.0f / (float)(spmax - spmin)) < 0.0f) {
                r = 0.0f;
            }
            this.tagPercent.setInt(Math.round(r));
        }
        this.tagValue.setInt(tmpVal);
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("cntmax", this.cntmax);
        state.saveVar("cntmin", this.cntmin);
    }

    @Override
    public void loadStateExtra(State state) {
        this.cntmax = state.loadVar("cntmax", this.cntmax);
        this.cntmin = state.loadVar("cntmin", this.cntmin);
    }
}

