/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Channel;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceZDVB
extends Device {
    Input inpEnable;
    Input inpDoOpen;
    Input inpImp;
    Input inpIsFullOpen;
    Input inpCurVal;
    Input inpInProc;
    Tag tagOutput;
    Tag tagSost;
    Tag tagOpened;
    Tag tagClosed;
    Tag tagAlarm;
    Tag tagControl;
    Tag tagBlok;
    Tag tagFlags;
    Tag tagTimeOpen;
    Tag tagMaxCloseTime;
    Tag tagMaxOpenTime;
    Tag tagTime100Proc;
    Tag tagProc;
    Channel chnl1out;
    Channel chnl2out;
    Channel chnl1in;
    Channel chnl2in;
    Tag tagRealProc;
    Tag tagCloseVal;
    Tag tagOpenVal;
    Tag tagValue;
    int cur_imp;
    int cur_en;
    int cur_op;
    int cur_optime;
    int old_control;
    long begin_open;
    long current_time;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.createTagDescr();
        this.inpEnable = this.getInput("Enable", res);
        this.inpDoOpen = this.getInput("DoOpen", res);
        this.inpImp = this.getInput("Imp", res);
        this.inpIsFullOpen = this.getInput("IsFullOpen", res);
        this.inpCurVal = this.getInput("CurVal", res);
        this.inpInProc = this.getInput("InProc", res);
        this.tagOutput = this.getOutputTag("Output", res);
        this.tagSost = this.getOutputTag("Sost", res);
        this.tagOpened = this.getOutputTag("Opened", res);
        this.tagClosed = this.getOutputTag("Closed", res);
        this.tagAlarm = this.getOutputTag("Alarm", res);
        this.tagControl = this.getOutputTag("Control", res);
        this.tagBlok = this.getOutputTag("Blok", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.tagTimeOpen = this.getOutputTag("TimeOpen", res);
        this.tagMaxCloseTime = this.getOutputTag("MaxCloseTime", res);
        this.tagMaxOpenTime = this.getOutputTag("MaxOpenTime", res);
        this.tagTime100Proc = this.getOutputTag("Time100Proc", res);
        this.tagProc = this.getOutputTag("Proc", res);
        this.chnl1out = this.createChannel("Chnl1Out", Channel.Type.Out, res);
        this.chnl2out = this.createChannel("Chnl2Out", Channel.Type.Out, res);
        this.chnl1in = this.createChannel("Chnl1In", Channel.Type.In, res);
        this.chnl2in = this.createChannel("Chnl2In", Channel.Type.In, res);
        this.tagRealProc = this.getOutputTag("RealProc", res);
        this.tagCloseVal = this.getOutputTag("CloseVal", res);
        this.tagOpenVal = this.getOutputTag("OpenVal", res);
        this.tagValue = this.getOutputTag("Value", res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagOutput.setInt(0);
        this.tagSost.setInt(30);
        this.tagOpened.setInt(0);
        this.tagClosed.setInt(0);
        this.tagControl.setInt(0);
        this.tagAlarm.setInt(0);
        this.tagRealProc.setInt(0);
        this.tagValue.setInt(0);
        this.cur_imp = 0;
        this.cur_en = 0;
        this.cur_op = 0;
        this.cur_optime = 0;
        this.old_control = 0;
        this.begin_open = 0L;
        this.current_time = 0L;
    }

    @Override
    public boolean execute() {
        int NeedFullOpen;
        boolean Flag6;
        int Output2 = 0;
        int Sost = this.tagSost.getInt();
        int Alarm = 0;
        int Control = this.tagControl.getInt();
        int Blok = this.tagBlok.getInt();
        int Flags2 = this.tagFlags.getInt();
        int TimeOpen = this.tagTimeOpen.getInt();
        int MaxCloseTime = this.tagMaxCloseTime.getInt();
        int MaxOpenTime = this.tagMaxOpenTime.getInt();
        int Time100Proc = this.tagTime100Proc.getInt();
        int Proc = this.tagProc.getInt();
        int RealProc = this.tagRealProc.getInt();
        int CloseVal = this.tagCloseVal.getInt();
        int OpenVal = this.tagOpenVal.getInt();
        int Value = this.tagValue.getInt();
        boolean is_opened = false;
        boolean is_closed = false;
        int CloseOut = 0;
        int OpenOut = 0;
        boolean chnl_ok = false;
        if ((Flags2 & 0xC) == 0) {
            boolean bl = chnl_ok = this.chnl1in.isOk() && this.chnl2in.isOk();
            if (chnl_ok) {
                is_closed = this.chnl1in.tagValue.getBool();
                is_opened = this.chnl2in.tagValue.getBool();
            }
        }
        if ((Flags2 & 0xC) == 4) {
            boolean bl = chnl_ok = this.chnl1in.isOk() && this.chnl2in.isOk();
            if (chnl_ok) {
                is_closed = this.chnl2in.tagValue.getBool();
                is_opened = this.chnl1in.tagValue.getBool();
            }
        }
        if ((Flags2 & 0xC) == 8 && (chnl_ok = this.chnl1in.isOk())) {
            is_closed = this.chnl1in.tagValue.getBool();
            boolean bl = is_opened = !is_closed;
        }
        if ((Flags2 & 0xC) == 12) {
            chnl_ok = true;
        }
        if ((Flags2 & 3) == 0 || (Flags2 & 3) == 1) {
            chnl_ok = chnl_ok && this.chnl1out.isOk() && this.chnl2out.isOk();
        } else if ((Flags2 & 3) == 2) {
            chnl_ok = chnl_ok && this.chnl1out.isOk();
        }
        boolean bl = Flag6 = (Flags2 & 0x40) == 64;
        if ((Flags2 & 0x80) == 128 && Control == 0) {
            Proc = this.inpInProc.getInt();
            this.tagProc.setInt(Proc);
        } else if (Proc > 100) {
            Proc = 100;
            this.tagProc.setInt(100);
        }
        Value = this.inpCurVal.getInt();
        this.tagValue.setInt(Value);
        boolean ValClosedIsLowThenValOpened = CloseVal < OpenVal;
        boolean bl2 = chnl_ok = chnl_ok && (!Flag6 || Flag6 && CloseVal != OpenVal);
        RealProc = ValClosedIsLowThenValOpened ? (Value <= CloseVal ? 0 : (OpenVal <= Value ? 100 : 100 * (Value - CloseVal) / (OpenVal - CloseVal))) : (Value >= CloseVal ? 0 : (OpenVal >= Value ? 100 : 100 - 100 * (Value - OpenVal) / (CloseVal - OpenVal)));
        this.tagRealProc.setInt(RealProc);
        if (!chnl_ok) {
            this.tagSost.setInt(88);
            this.tagAlarm.setInt(1);
            this.tagOutput.setInt(Blok == 0 ? 0 : 1);
            return true;
        }
        if (Sost == 88) {
            Sost = 30;
        }
        if ((Flags2 & 0x20) == 0) {
            is_opened = !is_opened;
            is_closed = !is_closed;
        }
        int old_imp = this.cur_imp = 0;
        int old_optime = this.cur_optime;
        this.tagOpened.setBool(is_opened);
        this.tagClosed.setBool(is_closed);
        this.cur_optime = Flag6 ? Proc : (Time100Proc > 0 ? Time100Proc * Proc / 100 : TimeOpen);
        switch (Control) {
            case 0: {
                this.cur_imp = this.inpImp.getInt();
                this.cur_en = this.inpEnable.getInt();
                this.cur_op = this.inpDoOpen.getInt();
                NeedFullOpen = this.inpIsFullOpen.getInt();
                break;
            }
            case 1: {
                this.cur_imp = 0;
                this.cur_en = 1;
                this.cur_op = 0;
                NeedFullOpen = 0;
                break;
            }
            case 2: {
                this.cur_imp = 0;
                this.cur_en = 1;
                this.cur_op = 1;
                NeedFullOpen = 0;
                break;
            }
            case 3: {
                this.cur_imp = 0;
                this.cur_en = 1;
                this.cur_op = 1;
                NeedFullOpen = 1;
                break;
            }
            default: {
                this.cur_imp = 0;
                this.cur_en = 0;
                this.cur_op = 0;
                NeedFullOpen = 0;
            }
        }
        if (Sost >= 20 && Sost <= 29) {
            Sost -= 10;
        }
        long CurCPUTime = System.currentTimeMillis();
        if (Sost == 30) {
            Sost = 0;
        } else {
            if (this.old_control != 0 && Control == 0 || this.old_control == 0 && Control != 0) {
                Sost = 0;
                this.begin_open = this.current_time = 0L;
            }
            if (this.cur_en == 0) {
                Sost = 0;
                this.current_time = 0L;
                this.begin_open = 0L;
            } else {
                if (this.cur_optime != old_optime) {
                    Sost = 0;
                }
                if ((Sost == 16 || Sost == 18 || Sost == 11 || Sost == 19 || Sost == 13) && this.cur_imp != old_imp && old_imp == 0) {
                    Sost = 0;
                }
                if (this.cur_op > 0 && (Sost == 15 || Sost == 18)) {
                    Sost = 0;
                }
                if (this.cur_op > 0 && Sost == 17) {
                    Sost = is_closed || Blok != 0 ? 10 : 0;
                }
                if (this.cur_op == 0 && (Sost == 10 || Sost == 11 || Sost == 19 || Sost == 12 || Sost == 13 || Sost == 14 || Sost == 16)) {
                    Sost = 0;
                }
                if (Sost == 16) {
                    if (NeedFullOpen > 0) {
                        Sost = 12;
                        this.begin_open = this.current_time = CurCPUTime;
                    } else {
                        Output2 = 1;
                    }
                }
                if (Sost == 17) {
                    if (is_closed || Blok != 0) {
                        Output2 = 1;
                    } else {
                        Sost = 15;
                        CloseOut = 1;
                        this.begin_open = this.current_time = CurCPUTime;
                    }
                }
                if (Sost == 18) {
                    Alarm = 1;
                }
                if (Sost == 19) {
                    Alarm = 1;
                }
                if (Sost == 14) {
                    if (NeedFullOpen == 0) {
                        Sost = 0;
                    }
                    if (Blok == 0 && is_opened || Blok != 0) {
                        Output2 = 1;
                    } else {
                        this.begin_open = this.current_time = CurCPUTime;
                        Sost = 12;
                    }
                }
                if (Sost == 13) {
                    Alarm = 1;
                }
                if (Sost == 15) {
                    if (is_closed || Blok != 0) {
                        Sost = 17;
                        Output2 = 1;
                        this.current_time = 0L;
                        this.begin_open = 0L;
                    } else {
                        if (MaxCloseTime != 0) {
                            this.current_time = CurCPUTime;
                        }
                        if ((this.current_time - this.begin_open) / 1000L <= (long)MaxCloseTime || MaxCloseTime == 0) {
                            CloseOut = 1;
                        } else {
                            Sost = 18;
                            Alarm = 1;
                            this.current_time = 0L;
                            this.begin_open = 0L;
                        }
                    }
                }
                if (Sost == 11 && NeedFullOpen > 0) {
                    Sost = 12;
                }
                if (Sost == 12 && NeedFullOpen == 0) {
                    Sost = 0;
                }
                if (Sost == 11) {
                    if (Flag6) {
                        if (is_opened || Blok != 0 || RealProc >= Proc && ValClosedIsLowThenValOpened || RealProc >= Proc && !ValClosedIsLowThenValOpened) {
                            Sost = 16;
                            Output2 = 1;
                        } else {
                            if (MaxOpenTime != 0) {
                                this.current_time = CurCPUTime;
                            }
                            if ((this.current_time - this.begin_open) / 1000L <= (long)MaxOpenTime || MaxOpenTime == 0) {
                                OpenOut = 1;
                            } else {
                                Sost = 19;
                                Alarm = 1;
                                this.current_time = 0L;
                                this.begin_open = 0L;
                            }
                        }
                    } else {
                        this.current_time = CurCPUTime;
                        if (Blok == 0 && (is_opened || (this.current_time - this.begin_open) / 1000L >= (long)this.cur_optime) || Blok != 0 && (this.current_time - this.begin_open) / 1000L >= (long)this.cur_optime) {
                            Sost = 16;
                            Output2 = 1;
                        } else {
                            OpenOut = 1;
                        }
                    }
                }
                if (Sost == 12) {
                    if (MaxCloseTime > 0) {
                        this.current_time = CurCPUTime;
                    }
                    if (Blok == 0 && is_opened || Blok != 0) {
                        Sost = 14;
                        Output2 = 1;
                    } else if ((this.current_time - this.begin_open) / 1000L <= (long)MaxOpenTime || MaxOpenTime == 0) {
                        OpenOut = 1;
                    } else {
                        Sost = 13;
                        Alarm = 1;
                    }
                }
                if (Sost == 10) {
                    if (Flag6) {
                        if (is_closed || Blok != 0 || RealProc <= Proc && ValClosedIsLowThenValOpened || RealProc <= Proc && !ValClosedIsLowThenValOpened) {
                            Sost = 16;
                            Output2 = 1;
                        } else {
                            if (MaxCloseTime != 0) {
                                this.current_time = CurCPUTime;
                            }
                            if ((this.current_time - this.begin_open) / 1000L <= (long)MaxCloseTime || MaxCloseTime == 0) {
                                CloseOut = 1;
                            } else {
                                Sost = 19;
                                Alarm = 1;
                                this.current_time = 0L;
                                this.begin_open = 0L;
                            }
                        }
                    } else if (is_closed || Blok != 0) {
                        OpenOut = 1;
                        Sost = NeedFullOpen > 0 ? 12 : 11;
                        this.begin_open = this.current_time = CurCPUTime;
                    } else {
                        CloseOut = 1;
                        if (MaxCloseTime != 0) {
                            this.current_time = CurCPUTime;
                        }
                        if ((this.current_time - this.begin_open) / 1000L <= (long)MaxCloseTime || MaxCloseTime == 0) {
                            CloseOut = 1;
                        } else {
                            Sost = 19;
                            Alarm = 1;
                            this.current_time = 0L;
                            this.begin_open = 0L;
                        }
                    }
                }
                if (Sost == 0) {
                    if (this.cur_op > 0) {
                        if (NeedFullOpen > 0) {
                            if (Blok == 0 && is_opened || Blok != 0) {
                                Sost = 14;
                                Output2 = 1;
                            } else {
                                Sost = 12;
                                OpenOut = 1;
                                this.begin_open = this.current_time = CurCPUTime;
                            }
                        } else if (Flag6) {
                            if (RealProc == Proc) {
                                Sost = 16;
                                Output2 = 1;
                            } else if (RealProc < Proc && ValClosedIsLowThenValOpened || RealProc < Proc && !ValClosedIsLowThenValOpened) {
                                if (Blok == 0 && !is_opened) {
                                    OpenOut = 1;
                                    Sost = 11;
                                    this.begin_open = this.current_time = CurCPUTime;
                                } else {
                                    Sost = 16;
                                    Output2 = 1;
                                }
                            } else if (Blok == 0 && !is_closed) {
                                CloseOut = 1;
                                Sost = 10;
                                this.begin_open = this.current_time = CurCPUTime;
                            } else {
                                Sost = 16;
                                Output2 = 1;
                            }
                        } else {
                            Sost = 10;
                            CloseOut = 1;
                            this.begin_open = this.current_time = CurCPUTime;
                        }
                    } else if (is_closed || Blok != 0) {
                        Sost = 17;
                        Output2 = 1;
                        this.current_time = 0L;
                        this.begin_open = 0L;
                    } else {
                        Sost = 15;
                        CloseOut = 1;
                        this.begin_open = this.current_time = CurCPUTime;
                    }
                }
            }
        }
        if (Control != 0) {
            Output2 = 1;
        }
        if (Control != 0 && Sost >= 10 && Sost <= 19) {
            Sost += 10;
        }
        this.old_control = Control;
        if ((Flags2 & 0x10) == 0) {
            CloseOut = CloseOut == 0 ? 1 : 0;
            int n = OpenOut = OpenOut == 0 ? 1 : 0;
        }
        if ((Flags2 & 3) == 0) {
            this.chnl1out.tagValue.setInt(CloseOut);
            this.chnl2out.tagValue.setInt(OpenOut);
        }
        if ((Flags2 & 3) == 1) {
            this.chnl2out.tagValue.setInt(CloseOut);
            this.chnl1out.tagValue.setInt(OpenOut);
        }
        if ((Flags2 & 3) == 2) {
            this.chnl1out.tagValue.setInt(CloseOut);
        }
        this.tagOutput.setInt(Output2);
        this.tagSost.setInt(Sost);
        this.tagAlarm.setInt(Alarm);
        return true;
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("cur_imp", this.cur_imp);
        state.saveVar("cur_en", this.cur_en);
        state.saveVar("cur_op", this.cur_op);
        state.saveVar("cur_optime", this.cur_optime);
        state.saveVar("old_control", this.old_control);
        state.saveVar("begin_open", this.begin_open);
        state.saveVar("current_time", this.current_time);
    }

    @Override
    public void loadStateExtra(State state) {
        this.cur_imp = state.loadVar("cur_imp", this.cur_imp);
        this.cur_en = state.loadVar("cur_en", this.cur_en);
        this.cur_op = state.loadVar("cur_op", this.cur_op);
        this.cur_optime = state.loadVar("cur_optime", this.cur_optime);
        this.old_control = state.loadVar("old_control", this.old_control);
        this.begin_open = state.loadVar("begin_open", this.begin_open);
        this.current_time = state.loadVar("current_time", this.current_time);
    }
}

