/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script;

import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.plugin.script.Action;
import promauto.jroboplc.plugin.script.ScriptModule;

public class ActionCopy
extends Action {
    private ScriptModule module;
    protected Ref src = EnvironmentInst.get().getRefFactory().createRef();
    protected Ref dst = EnvironmentInst.get().getRefFactory().createRef();

    public ActionCopy(ScriptModule module) {
        this.module = module;
    }

    @Override
    public boolean load(Object conf) {
        super.load(conf);
        boolean res = true;
        res &= this.src.init(conf, "src", this.module);
        return res &= this.dst.init(conf, "dst", this.module);
    }

    @Override
    public boolean prepare() {
        if (!this.src.prepare() || !this.dst.prepare()) {
            return false;
        }
        this.src.link();
        this.dst.link();
        return true;
    }

    @Override
    public void execute() {
        if (this.src.linkIfNotValid() && this.dst.linkIfNotValid() && !this.src.getTag().equalsValue(this.dst.getTag())) {
            if (this.delay_ms > 0L) {
                if (this.timeDelay == 0L) {
                    this.timeDelay = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.timeDelay > this.delay_ms) {
                    this.src.getTag().copyValueTo(this.dst.getTag());
                    this.timeDelay = 0L;
                }
            } else {
                this.src.getTag().copyValueTo(this.dst.getTag());
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.src.isValid() && this.dst.isValid();
    }

    @Override
    public String getError() {
        return "copy " + this.getId() + ": " + (this.src.isValid() ? "" : "src = " + this.src.getName() + " ") + (this.dst.isValid() ? "" : "dst = " + this.dst.getName());
    }
}

