/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class OwenTrm138Module
extends PeripherialModule {
    private static final int SIZE = 8;
    private final Logger logger = LoggerFactory.getLogger(OwenTrm138Module.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Sensor[] sensors = new Sensor[8];

    public OwenTrm138Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        int mul = cm.get(conf, "mul", 100);
        boolean badIfError = cm.get(conf, "badIfError", false);
        for (int i = 0; i < 8; ++i) {
            this.sensors[i] = new Sensor();
            this.sensors[i].mul = cm.get(conf, "mul." + i, mul);
            this.sensors[i].badIfError = cm.get(conf, "badIfError." + i, badIfError);
            this.sensors[i].tagValue = this.tagtable.createInt("d" + i + ".value", 0, 8);
            this.sensors[i].tagError = this.tagtable.createInt("d" + i + ".error", 0, 8);
        }
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < 8; ++i) {
            this.addChannelMapTag(chtags, this.sensors[i].tagValue, "" + i);
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            result = this.protocol.requestCmd4(0, 40);
            if (result) {
                for (int i = 0; i < 8; ++i) {
                    int error = this.protocol.getAnswerWord(2);
                    this.sensors[i].tagError.setInt(error);
                    this.sensors[i].tagValue.setDouble((double)this.protocol.getAnswerFloat(i * 5 + 3) * (double)this.sensors[i].mul);
                    if (!this.sensors[i].badIfError) continue;
                    if (error == 0 && this.sensors[i].tagValue.getStatus() != Tag.Status.Good) {
                        this.sensors[i].tagValue.setStatus(Tag.Status.Good);
                    }
                    if (error <= 0 || this.sensors[i].tagValue.getStatus() == Tag.Status.Bad) continue;
                    this.sensors[i].tagValue.setStatus(Tag.Status.Bad);
                }
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }

    @Override
    protected boolean reload() {
        OwenTrm138Module tmp = new OwenTrm138Module(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        for (int i = 0; i < 8; ++i) {
            this.sensors[i].mul = tmp.sensors[i].mul;
            this.sensors[i].badIfError = tmp.sensors[i].badIfError;
        }
        return true;
    }

    public static class Sensor {
        protected Tag tagValue;
        protected Tag tagError;
        protected int mul;
        protected boolean badIfError;
    }
}

