/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.ModbusModule;
import promauto.jroboplc.plugin.peripherial.ModbusTag;

public class PaGeliosDozmanModule
extends ModbusModule {
    private static final int TERM_IO_SIZE = 8;
    private Tag tagUnderweight;
    private Tag tagOverweight;
    private Tag tagWeightReq;
    private Tag tagWeightCur;
    private Tag tagDiffDown;
    private Tag tagDiffUp;
    private TagRW[] bittagsRd = new TagRW[8];
    private TagRW[] bittagsWr = new TagRW[8];

    public PaGeliosDozmanModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        if (!super.loadPeripherialModule(conf)) {
            return false;
        }
        this.tagUnderweight = this.tagtable.createBool("Underweight", false, 8);
        this.tagOverweight = this.tagtable.createBool("Overweight", false, 8);
        this.addCrc32Tags("WeightCur", "WeightTot", "Stable", "Finished", "Run", "Status", this.tagError);
        return true;
    }

    @Override
    protected boolean loadModbusTags(Object conf) {
        this.addModbusTag(ModbusTag.create("IsEmptyCur", 4096).type(ModbusTag.Type.BOOL).access(ModbusTag.Access.RO));
        this.addModbusTag(ModbusTag.create("IsEmptyTot", 4098).type(ModbusTag.Type.BOOL).access(ModbusTag.Access.RO));
        this.addModbusTag(ModbusTag.create("SetEmptyCur", 4097).type(ModbusTag.Type.BOOL));
        this.addModbusTag(ModbusTag.create("SetEmptyTot", 4099).type(ModbusTag.Type.BOOL));
        this.tagWeightReq = this.addModbusTag((ModbusTag)ModbusTag.create((String)"WeightReq", (int)4101).type((ModbusTag.Type)ModbusTag.Type.INT32)).tag;
        this.tagWeightCur = this.addModbusTag((ModbusTag)ModbusTag.create((String)"WeightCur", (int)4103).type((ModbusTag.Type)ModbusTag.Type.INT32).access((ModbusTag.Access)ModbusTag.Access.RO)).tag;
        this.addModbusTag(ModbusTag.create("WeightTot", 4105).type(ModbusTag.Type.INT32).access(ModbusTag.Access.RO));
        this.tagDiffDown = this.addModbusTag((ModbusTag)ModbusTag.create((String)"DiffDown", (int)4107).type((ModbusTag.Type)ModbusTag.Type.INT32)).tag;
        this.tagDiffUp = this.addModbusTag((ModbusTag)ModbusTag.create((String)"DiffUp", (int)4109).type((ModbusTag.Type)ModbusTag.Type.INT32)).tag;
        this.addModbusTag(ModbusTag.create("Stable", 4111).type(ModbusTag.Type.BOOL).access(ModbusTag.Access.RO));
        this.addModbusTag(ModbusTag.create("Finished", 4112).type(ModbusTag.Type.BOOL));
        this.addModbusTag(ModbusTag.create("Run", 4115).type(ModbusTag.Type.BOOL));
        this.addModbusTag(ModbusTag.create("ResetError", 4116).type(ModbusTag.Type.BOOL));
        this.addModbusTag(ModbusTag.create("Status", 4117).type(ModbusTag.Type.UINT16));
        this.addModbusTag(ModbusTag.create("ErrorCode", 4118).type(ModbusTag.Type.UINT16));
        ModbusTag termInp = this.addModbusTag(ModbusTag.create("TermInp", 4119).type(ModbusTag.Type.UINT16));
        ModbusTag termOut = this.addModbusTag(ModbusTag.create("TermOut", 4120).type(ModbusTag.Type.UINT16));
        for (int i = 0; i < 8; ++i) {
            this.bittagsRd[i] = this.addModbusBitTag(termInp, "" + i, 1 << i);
            this.bittagsWr[i] = this.addModbusBitTag(termOut, "" + i, 1 << i);
        }
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < 8; ++i) {
            this.addChannelMapTag(chtags, this.bittagsRd[i], i + "r");
            this.addChannelMapTag(chtags, this.bittagsWr[i], i + "w");
        }
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result = super.executePeripherialModule();
        this.calcCrc32();
        this.tagUnderweight.setBool(this.tagWeightCur.getInt() < this.tagWeightReq.getInt() - this.tagDiffDown.getInt());
        this.tagOverweight.setBool(this.tagWeightCur.getInt() > this.tagWeightReq.getInt() + this.tagDiffUp.getInt());
        return result;
    }

    @Override
    protected boolean reload() {
        PaGeliosDozmanModule tmp = new PaGeliosDozmanModule(this.plugin, this.name);
        return this.reloadFrom(tmp);
    }
}

