/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolAA55;
import promauto.utils.CRC;
import promauto.utils.Numbers;

public class PaGeliosMultiPackerModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(PaGeliosMultiPackerModule.class);
    protected ProtocolAA55 protocol = new ProtocolAA55(this);
    protected List<TagPair> pairs = new LinkedList<TagPair>();
    private TagRW tagFirmware;
    private final int[] buffin = new int[9];
    private final int[] buffout = new int[5];
    protected boolean multireq = false;

    public PaGeliosMultiPackerModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.multireq = cm.get(conf, "multireq", false);
        cm.toMap(cm.get(conf, "tag.pairs")).forEach((regname, addr) -> {
            TagPair tp = new TagPair();
            tp.tagWeight = this.tagtable.createLong(regname + ".weight", 0L, 8);
            tp.tagNum = this.tagtable.createLong(regname + ".num", 0L, 8);
            tp.addr = Integer.parseInt(addr.toString());
            this.pairs.add(tp);
        });
        this.tagFirmware = this.tagtable.createRWString("firmware", "", 8);
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result = true;
        try {
            for (TagPair tp : this.pairs) {
                this.buffout[0] = 85;
                this.buffout[1] = 160 + this.netaddr;
                this.buffout[2] = tp.addr >> 8 & 0xFF;
                this.buffout[3] = tp.addr & 0xFF;
                this.buffout[4] = CRC.getCrc8(this.buffout, 1, 3);
                result = !this.multireq ? this.protocol.request(this.buffout, 5, this.buffin, 9, 1) : this.protocol.multiRequest(this.buffout, 5, this.buffin, 9, 9, 1);
                if (result) {
                    tp.tagNum.setLong(Numbers.bytesToDWord(this.buffin, 0));
                    tp.tagWeight.setLong(Numbers.bytesToDWord(this.buffin, 4));
                }
                if (!result || !this.firstPass && !this.tagError.getBool()) continue;
                result = this.protocol.requestFirmware(this.tagFirmware);
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        return result;
    }

    protected static class TagPair {
        Tag tagWeight;
        Tag tagNum;
        int addr;

        protected TagPair() {
        }
    }
}

